/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.net.logstash.logback.composite.loggingevent;

import java.io.IOException;
import java.util.regex.Pattern;
import org.glowroot.agent.shaded.ch.qos.logback.classic.spi.ILoggingEvent;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.glowroot.agent.shaded.net.logstash.logback.composite.AbstractFieldJsonProvider;
import org.glowroot.agent.shaded.net.logstash.logback.composite.FieldNamesAware;
import org.glowroot.agent.shaded.net.logstash.logback.composite.JsonWritingUtils;
import org.glowroot.agent.shaded.net.logstash.logback.encoder.SeparatorParser;
import org.glowroot.agent.shaded.net.logstash.logback.fieldnames.LogstashFieldNames;

public class MessageJsonProvider
extends AbstractFieldJsonProvider<ILoggingEvent>
implements FieldNamesAware<LogstashFieldNames> {
    public static final String FIELD_MESSAGE = "message";
    private Pattern messageSplitPattern = null;

    public MessageJsonProvider() {
        this.setFieldName(FIELD_MESSAGE);
    }

    @Override
    public void writeTo(JsonGenerator generator, ILoggingEvent event) throws IOException {
        if (this.messageSplitPattern != null) {
            String[] multiLineMessage = this.messageSplitPattern.split(event.getFormattedMessage());
            JsonWritingUtils.writeStringArrayField(generator, this.getFieldName(), multiLineMessage);
        } else {
            JsonWritingUtils.writeStringField(generator, this.getFieldName(), event.getFormattedMessage());
        }
    }

    @Override
    public void setFieldNames(LogstashFieldNames fieldNames) {
        this.setFieldName(fieldNames.getMessage());
    }

    public String getMessageSplitRegex() {
        return this.messageSplitPattern != null ? this.messageSplitPattern.pattern() : null;
    }

    public void setMessageSplitRegex(String messageSplitRegex) {
        String parsedMessageSplitRegex = SeparatorParser.parseSeparator(messageSplitRegex);
        this.messageSplitPattern = parsedMessageSplitRegex != null ? Pattern.compile(parsedMessageSplitRegex) : null;
    }
}

