/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.net.logstash.logback.composite;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.glowroot.agent.shaded.ch.qos.logback.core.spi.DeferredProcessingAware;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.JsonFactory;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.TreeNode;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.glowroot.agent.shaded.net.logstash.logback.composite.AbstractJsonProvider;
import org.glowroot.agent.shaded.net.logstash.logback.composite.JsonFactoryAware;

public class GlobalCustomFieldsJsonProvider<Event extends DeferredProcessingAware>
extends AbstractJsonProvider<Event>
implements JsonFactoryAware {
    private String customFields;
    private JsonNode customFieldsNode;
    private JsonFactory jsonFactory;

    @Override
    public void writeTo(JsonGenerator generator, Event event) throws IOException {
        this.writeFieldsOfNode(generator, this.customFieldsNode);
    }

    private void writeFieldsOfNode(JsonGenerator generator, JsonNode node) throws IOException {
        if (node != null) {
            Iterator fields = node.fields();
            while (fields.hasNext()) {
                Map.Entry field = (Map.Entry)fields.next();
                generator.writeFieldName((String)field.getKey());
                generator.writeTree((TreeNode)field.getValue());
            }
        }
    }

    @Override
    public void start() {
        this.initializeCustomFields();
        super.start();
    }

    private void initializeCustomFields() {
        if (this.customFields != null && this.jsonFactory != null) {
            try {
                this.customFieldsNode = (JsonNode)this.jsonFactory.createParser(this.customFields).readValueAsTree();
            }
            catch (IOException e) {
                this.addError("Failed to parse custom fields [" + this.customFields + "]", e);
            }
        }
    }

    public void setCustomFields(String customFields) {
        this.customFields = customFields;
        if (this.isStarted()) {
            this.initializeCustomFields();
        }
    }

    public String getCustomFields() {
        return this.customFields;
    }

    public JsonNode getCustomFieldsNode() {
        return this.customFieldsNode;
    }

    public void setCustomFieldsNode(JsonNode customFields) {
        this.customFieldsNode = customFields;
        if (this.customFieldsNode != null && customFields == null) {
            this.customFields = this.customFieldsNode.toString();
        }
    }

    @Override
    public void setJsonFactory(JsonFactory jsonFactory) {
        this.jsonFactory = jsonFactory;
    }
}

