/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.util;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;
import org.checkerframework.checker.tainting.qual.Untainted;
import org.glowroot.agent.embedded.sql.SQLException;
import org.glowroot.agent.embedded.util.ImmutableIndex;
import org.glowroot.agent.embedded.util.ResultSetCloser;
import org.glowroot.agent.shaded.com.google.common.annotations.VisibleForTesting;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.ArrayListMultimap;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableSet;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Maps;
import org.glowroot.agent.shaded.com.google.common.collect.Sets;
import org.glowroot.agent.shaded.org.glowroot.common.util.Styles;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.glowroot.agent.util.Checkers;
import org.immutables.value.Value;

public class Schemas {
    private static final Logger logger = LoggerFactory.getLogger(Schemas.class);
    private static final Map<ColumnType, String> typeNames = Maps.newHashMap();

    private Schemas() {
    }

    static void syncTable(@Untainted String tableName, List<Column> columns, Connection connection) throws SQLException {
        if (!Schemas.tableExists(tableName, connection)) {
            Schemas.createTable(tableName, columns, connection);
        } else if (Schemas.tableNeedsUpgrade(tableName, columns, connection)) {
            logger.warn("upgrading table {}, which unfortunately at this point just means dropping and re-create the table (losing existing data)", (Object)tableName);
            Schemas.execute("drop table " + tableName, connection);
            Schemas.createTable(tableName, columns, connection);
        }
    }

    static void syncIndexes(@Untainted String tableName, ImmutableList<Index> indexes, Connection connection) throws SQLException {
        ImmutableSet desiredIndexes = ImmutableSet.copyOf(indexes);
        ImmutableSet<Index> existingIndexes = Schemas.getIndexes(tableName, connection);
        for (Index index : Sets.difference(existingIndexes, (Set)desiredIndexes)) {
            Schemas.execute("drop index " + index.name(), connection);
        }
        for (Index index : Sets.difference((Set)desiredIndexes, existingIndexes)) {
            Schemas.createIndex(tableName, index, connection);
        }
        existingIndexes = Schemas.getIndexes(tableName, connection);
        if (!existingIndexes.equals(desiredIndexes)) {
            logger.error("the logic in syncIndexes() needs fixing");
        }
    }

    static boolean tableExists(String tableName, Connection connection) throws SQLException {
        logger.debug("tableExists(): tableName={}", (Object)tableName);
        ResultSet resultSet = Schemas.getMetaDataTables(connection, tableName);
        try (ResultSetCloser closer = new ResultSetCloser(resultSet);){
            boolean bl = resultSet.next();
            return bl;
        }
    }

    static boolean columnExists(String tableName, String columnName, Connection connection) throws SQLException {
        logger.debug("columnExists(): tableName={}, columnName={}", (Object)tableName, (Object)columnName);
        ResultSet resultSet = Schemas.getMetaDataColumns(connection, tableName, columnName);
        try (ResultSetCloser closer = new ResultSetCloser(resultSet);){
            boolean bl = resultSet.next();
            return bl;
        }
    }

    private static void createTable(@Untainted String tableName, List<Column> columns, Connection connection) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("create table ");
        sql.append(tableName);
        sql.append(" (");
        for (int i = 0; i < columns.size(); ++i) {
            if (i > 0) {
                sql.append(", ");
            }
            String sqlTypeName = typeNames.get((Object)columns.get(i).type());
            Preconditions.checkNotNull((Object)sqlTypeName, (String)"Unexpected sql type: %s", (Object)((Object)columns.get(i).type()));
            sql.append(columns.get(i).name());
            sql.append(" ");
            sql.append(sqlTypeName);
        }
        sql.append(")");
        Schemas.execute((String)Checkers.castUntainted((Object)sql.toString()), connection);
        if (Schemas.tableNeedsUpgrade(tableName, columns, connection)) {
            logger.warn("table {} thinks it still needs to be upgraded, even after it was just upgraded", (Object)tableName);
        }
    }

    private static boolean tableNeedsUpgrade(String tableName, List<Column> columns, Connection connection) throws SQLException {
        TreeMap<String, Column> columnMap = new TreeMap<String, Column>(String.CASE_INSENSITIVE_ORDER);
        for (Column column : columns) {
            columnMap.put(column.name(), column);
        }
        ResultSet resultSet = Schemas.getMetaDataColumns(connection, tableName, null);
        try (ResultSetCloser closer = new ResultSetCloser(resultSet);){
            boolean bl = !Schemas.columnNamesAndTypesMatch(resultSet, columnMap, connection);
            return bl;
        }
    }

    private static boolean columnNamesAndTypesMatch(ResultSet resultSet, Map<String, Column> columnMap, Connection connection) throws SQLException {
        while (resultSet.next()) {
            Column column = columnMap.remove(resultSet.getString("COLUMN_NAME"));
            if (column == null) {
                return false;
            }
            String typeName = typeNames.get((Object)column.type());
            if (typeName == null) {
                return false;
            }
            int index = typeName.indexOf(32);
            if (index != -1) {
                typeName = typeName.substring(0, index);
            }
            if ((typeName = Schemas.convert(connection.getMetaData(), typeName)).equals(resultSet.getString("TYPE_NAME"))) continue;
            return false;
        }
        return columnMap.isEmpty();
    }

    @VisibleForTesting
    static ImmutableSet<Index> getIndexes(String tableName, Connection connection) throws SQLException {
        ArrayListMultimap indexColumns = ArrayListMultimap.create();
        ResultSet resultSet = Schemas.getMetaDataIndexInfo(connection, tableName);
        try (ResultSetCloser closer = new ResultSetCloser(resultSet);){
            while (resultSet.next()) {
                String indexName = (String)Preconditions.checkNotNull((Object)resultSet.getString("INDEX_NAME"));
                String columnName = (String)Preconditions.checkNotNull((Object)resultSet.getString("COLUMN_NAME"));
                if (indexName.startsWith("PRIMARY_KEY_")) continue;
                indexColumns.put((Object)((String)Checkers.castUntainted((Object)indexName)), (Object)((String)Checkers.castUntainted((Object)columnName)));
            }
        }
        ImmutableSet.Builder indexes = ImmutableSet.builder();
        for (Map.Entry entry : indexColumns.asMap().entrySet()) {
            String name = ((String)entry.getKey()).toLowerCase(Locale.ENGLISH);
            ArrayList columns = Lists.newArrayList();
            for (String column : (Collection)entry.getValue()) {
                columns.add(column.toLowerCase(Locale.ENGLISH));
            }
            indexes.add((Object)ImmutableIndex.of(name, columns));
        }
        return indexes.build();
    }

    private static void createIndex(String tableName, Index index, Connection connection) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("create index ");
        sql.append(index.name());
        sql.append(" on ");
        sql.append(tableName);
        sql.append(" (");
        for (int i = 0; i < index.columns().size(); ++i) {
            if (i > 0) {
                sql.append(", ");
            }
            sql.append((String)index.columns().get(i));
        }
        sql.append(")");
        Schemas.execute((String)Checkers.castUntainted((Object)sql.toString()), connection);
    }

    private static void execute(@Untainted String sql, Connection connection) throws SQLException {
        try (Statement statement = connection.createStatement();){
            statement.execute(sql);
        }
    }

    private static ResultSet getMetaDataTables(Connection connection, String tableName) throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        return metaData.getTables(null, null, Schemas.convert(metaData, tableName), null);
    }

    private static ResultSet getMetaDataColumns(Connection connection, String tableName, @Nullable String columnName) throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        return metaData.getColumns(null, null, Schemas.convert(metaData, tableName), Schemas.convert(metaData, columnName));
    }

    private static ResultSet getMetaDataIndexInfo(Connection connection, String tableName) throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        return metaData.getIndexInfo(null, null, Schemas.convert(metaData, tableName), false, false);
    }

    private static @PolyNull String convert(DatabaseMetaData metaData, @PolyNull String name) throws SQLException {
        if (name == null) {
            return null;
        }
        if (metaData.storesUpperCaseIdentifiers()) {
            return name.toUpperCase(Locale.ENGLISH);
        }
        return name;
    }

    static {
        typeNames.put(ColumnType.VARCHAR, "varchar");
        typeNames.put(ColumnType.BIGINT, "bigint");
        typeNames.put(ColumnType.BOOLEAN, "boolean");
        typeNames.put(ColumnType.VARBINARY, "varbinary");
        typeNames.put(ColumnType.DOUBLE, "double");
        typeNames.put(ColumnType.AUTO_IDENTITY, "bigint identity");
    }

    @Value.Immutable
    @Styles.AllParameters
    public static interface Index {
        public @Untainted String name();

        public ImmutableList<String> columns();
    }

    @Value.Immutable
    @Styles.AllParameters
    public static interface Column {
        public String name();

        public ColumnType type();
    }

    public static enum ColumnType {
        VARCHAR,
        BIGINT,
        BOOLEAN,
        DOUBLE,
        VARBINARY,
        AUTO_IDENTITY;

    }
}

