/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.owasp.html;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import org.glowroot.agent.embedded.shaded.org.owasp.html.AttributePolicy;
import org.glowroot.agent.embedded.shaded.org.owasp.html.ElementAndAttributePolicies;
import org.glowroot.agent.embedded.shaded.org.owasp.html.ElementAndAttributePolicyBasedSanitizerPolicy;
import org.glowroot.agent.embedded.shaded.org.owasp.html.Handler;
import org.glowroot.agent.embedded.shaded.org.owasp.html.HtmlChangeListener;
import org.glowroot.agent.embedded.shaded.org.owasp.html.HtmlChangeReporter;
import org.glowroot.agent.embedded.shaded.org.owasp.html.HtmlSanitizer;
import org.glowroot.agent.embedded.shaded.org.owasp.html.HtmlStreamEventProcessor;
import org.glowroot.agent.embedded.shaded.org.owasp.html.HtmlStreamEventReceiver;
import org.glowroot.agent.embedded.shaded.org.owasp.html.HtmlStreamRenderer;
import org.glowroot.agent.shaded.com.google.common.base.Function;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableMap;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableSet;

@ThreadSafe
@Immutable
public final class PolicyFactory
implements Function<HtmlStreamEventReceiver, HtmlSanitizer.Policy> {
    private final ImmutableMap<String, ElementAndAttributePolicies> policies;
    private final ImmutableMap<String, AttributePolicy> globalAttrPolicies;
    private final ImmutableSet<String> textContainers;
    private final HtmlStreamEventProcessor preprocessor;
    private final HtmlStreamEventProcessor postprocessor;

    PolicyFactory(ImmutableMap<String, ElementAndAttributePolicies> policies, ImmutableSet<String> textContainers, ImmutableMap<String, AttributePolicy> globalAttrPolicies, HtmlStreamEventProcessor preprocessor, HtmlStreamEventProcessor postprocessor) {
        this.policies = policies;
        this.textContainers = textContainers;
        this.globalAttrPolicies = globalAttrPolicies;
        this.preprocessor = preprocessor;
        this.postprocessor = postprocessor;
    }

    public HtmlSanitizer.Policy apply(@Nonnull HtmlStreamEventReceiver out) {
        return new ElementAndAttributePolicyBasedSanitizerPolicy(this.postprocessor.wrap(out), this.policies, this.textContainers);
    }

    public <CTX> HtmlSanitizer.Policy apply(HtmlStreamEventReceiver out, @Nullable HtmlChangeListener<CTX> listener, @Nullable CTX context) {
        if (listener == null) {
            return this.apply(out);
        }
        HtmlChangeReporter<CTX> r = new HtmlChangeReporter<CTX>(out, listener, context);
        r.setPolicy(this.apply(r.getWrappedRenderer()));
        return r.getWrappedPolicy();
    }

    public String sanitize(@Nullable String html) {
        return this.sanitize(html, null, null);
    }

    public <CTX> String sanitize(@Nullable String html, @Nullable HtmlChangeListener<CTX> listener, @Nullable CTX context) {
        if (html == null) {
            return "";
        }
        StringBuilder out = new StringBuilder(html.length());
        HtmlSanitizer.sanitize(html, this.apply(HtmlStreamRenderer.create(out, Handler.DO_NOTHING), listener, context), this.preprocessor);
        return out.toString();
    }
}

