/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.h2.value;

import java.sql.PreparedStatement;
import org.glowroot.agent.embedded.shaded.org.h2.message.DbException;
import org.glowroot.agent.embedded.shaded.org.h2.util.MathUtils;
import org.glowroot.agent.embedded.shaded.org.h2.value.CompareMode;
import org.glowroot.agent.embedded.shaded.org.h2.value.Value;
import org.glowroot.agent.embedded.sql.SQLException;

public class ValueInt
extends Value {
    private static final ValueInt[] STATIC_CACHE = new ValueInt[128];
    private static final ValueInt[] DYNAMIC_CACHE = new ValueInt[256];
    private final int value;

    private ValueInt(int n) {
        this.value = n;
    }

    public static ValueInt get(int n) {
        if (n >= 0 && n < 128) {
            return STATIC_CACHE[n];
        }
        ValueInt valueInt = DYNAMIC_CACHE[n & 0xFF];
        if (valueInt == null || valueInt.value != n) {
            ValueInt.DYNAMIC_CACHE[n & 0xFF] = valueInt = new ValueInt(n);
        }
        return valueInt;
    }

    @Override
    public Value add(Value value) {
        ValueInt valueInt = (ValueInt)value;
        return ValueInt.checkRange((long)this.value + (long)valueInt.value);
    }

    private static ValueInt checkRange(long l) {
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            throw DbException.get(22003, Long.toString(l));
        }
        return ValueInt.get((int)l);
    }

    @Override
    public int getSignum() {
        return Integer.signum(this.value);
    }

    @Override
    public Value negate() {
        return ValueInt.checkRange(-((long)this.value));
    }

    @Override
    public Value subtract(Value value) {
        ValueInt valueInt = (ValueInt)value;
        return ValueInt.checkRange((long)this.value - (long)valueInt.value);
    }

    @Override
    public Value multiply(Value value) {
        ValueInt valueInt = (ValueInt)value;
        return ValueInt.checkRange((long)this.value * (long)valueInt.value);
    }

    @Override
    public Value divide(Value value) {
        ValueInt valueInt = (ValueInt)value;
        if (valueInt.value == 0) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueInt.get(this.value / valueInt.value);
    }

    @Override
    public Value modulus(Value value) {
        ValueInt valueInt = (ValueInt)value;
        if (valueInt.value == 0) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueInt.get(this.value % valueInt.value);
    }

    @Override
    public String getSQL() {
        return this.getString();
    }

    @Override
    public int getType() {
        return 4;
    }

    @Override
    public int getInt() {
        return this.value;
    }

    @Override
    public long getLong() {
        return this.value;
    }

    @Override
    protected int compareSecure(Value value, CompareMode compareMode) {
        ValueInt valueInt = (ValueInt)value;
        return MathUtils.compareInt(this.value, valueInt.value);
    }

    @Override
    public String getString() {
        return String.valueOf(this.value);
    }

    @Override
    public long getPrecision() {
        return 10L;
    }

    @Override
    public int hashCode() {
        return this.value;
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setInt(n, this.value);
    }

    @Override
    public int getDisplaySize() {
        return 11;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof ValueInt && this.value == ((ValueInt)object).value;
    }

    static {
        for (int i = 0; i < 128; ++i) {
            ValueInt.STATIC_CACHE[i] = new ValueInt(i);
        }
    }
}

