/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.h2.value;

import java.sql.Date;
import java.sql.PreparedStatement;
import org.glowroot.agent.embedded.shaded.org.h2.message.DbException;
import org.glowroot.agent.embedded.shaded.org.h2.util.DateTimeUtils;
import org.glowroot.agent.embedded.shaded.org.h2.util.MathUtils;
import org.glowroot.agent.embedded.shaded.org.h2.util.StringUtils;
import org.glowroot.agent.embedded.shaded.org.h2.value.CompareMode;
import org.glowroot.agent.embedded.shaded.org.h2.value.Value;
import org.glowroot.agent.embedded.sql.SQLException;

public class ValueDate
extends Value {
    private final long dateValue;

    private ValueDate(long l) {
        this.dateValue = l;
    }

    public static ValueDate fromDateValue(long l) {
        return (ValueDate)Value.cache(new ValueDate(l));
    }

    public static ValueDate get(Date date) {
        return ValueDate.fromDateValue(DateTimeUtils.dateValueFromDate(date.getTime()));
    }

    public static ValueDate parse(String string) {
        try {
            return ValueDate.fromDateValue(DateTimeUtils.parseDateValue(string, 0, string.length()));
        }
        catch (Exception exception) {
            throw DbException.get(22007, exception, "DATE", string);
        }
    }

    public long getDateValue() {
        return this.dateValue;
    }

    @Override
    public Date getDate() {
        return DateTimeUtils.convertDateValueToDate(this.dateValue);
    }

    @Override
    public int getType() {
        return 10;
    }

    @Override
    public String getString() {
        StringBuilder stringBuilder = new StringBuilder(10);
        ValueDate.appendDate(stringBuilder, this.dateValue);
        return stringBuilder.toString();
    }

    @Override
    public String getSQL() {
        return "DATE '" + this.getString() + "'";
    }

    @Override
    public long getPrecision() {
        return 8L;
    }

    @Override
    public int getDisplaySize() {
        return 10;
    }

    @Override
    protected int compareSecure(Value value, CompareMode compareMode) {
        return MathUtils.compareLong(this.dateValue, ((ValueDate)value).dateValue);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof ValueDate && this.dateValue == ((ValueDate)object).dateValue;
    }

    @Override
    public int hashCode() {
        return (int)(this.dateValue ^ this.dateValue >>> 32);
    }

    @Override
    public Object getObject() {
        return this.getDate();
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setDate(n, this.getDate());
    }

    static void appendDate(StringBuilder stringBuilder, long l) {
        int n = DateTimeUtils.yearFromDateValue(l);
        int n2 = DateTimeUtils.monthFromDateValue(l);
        int n3 = DateTimeUtils.dayFromDateValue(l);
        if (n > 0 && n < 10000) {
            StringUtils.appendZeroPadded(stringBuilder, 4, n);
        } else {
            stringBuilder.append(n);
        }
        stringBuilder.append('-');
        StringUtils.appendZeroPadded(stringBuilder, 2, n2);
        stringBuilder.append('-');
        StringUtils.appendZeroPadded(stringBuilder, 2, n3);
    }
}

