/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.h2.store;

import org.glowroot.agent.embedded.shaded.org.h2.message.DbException;
import org.glowroot.agent.embedded.shaded.org.h2.store.InDoubtTransaction;
import org.glowroot.agent.embedded.shaded.org.h2.store.PageStore;

public class PageStoreInDoubtTransaction
implements InDoubtTransaction {
    private final PageStore store;
    private final int sessionId;
    private final int pos;
    private final String transactionName;
    private int state;

    public PageStoreInDoubtTransaction(PageStore pageStore, int n, int n2, String string) {
        this.store = pageStore;
        this.sessionId = n;
        this.pos = n2;
        this.transactionName = string;
        this.state = 0;
    }

    @Override
    public void setState(int n) {
        switch (n) {
            case 1: {
                this.store.setInDoubtTransactionState(this.sessionId, this.pos, true);
                break;
            }
            case 2: {
                this.store.setInDoubtTransactionState(this.sessionId, this.pos, false);
                break;
            }
            default: {
                DbException.throwInternalError("state=" + n);
            }
        }
        this.state = n;
    }

    @Override
    public String getState() {
        switch (this.state) {
            case 0: {
                return "IN_DOUBT";
            }
            case 1: {
                return "COMMIT";
            }
            case 2: {
                return "ROLLBACK";
            }
        }
        throw DbException.throwInternalError("state=" + this.state);
    }

    @Override
    public String getTransactionName() {
        return this.transactionName;
    }
}

