/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.h2.engine;

import java.sql.Connection;
import org.glowroot.agent.embedded.shaded.org.h2.api.Aggregate;
import org.glowroot.agent.embedded.shaded.org.h2.api.AggregateFunction;
import org.glowroot.agent.embedded.shaded.org.h2.command.Parser;
import org.glowroot.agent.embedded.shaded.org.h2.engine.Database;
import org.glowroot.agent.embedded.shaded.org.h2.engine.DbObjectBase;
import org.glowroot.agent.embedded.shaded.org.h2.engine.Session;
import org.glowroot.agent.embedded.shaded.org.h2.message.DbException;
import org.glowroot.agent.embedded.shaded.org.h2.table.Table;
import org.glowroot.agent.embedded.shaded.org.h2.util.Utils;
import org.glowroot.agent.embedded.shaded.org.h2.value.DataType;
import org.glowroot.agent.embedded.sql.SQLException;

public class UserAggregate
extends DbObjectBase {
    private String className;
    private Class<?> javaClass;

    public UserAggregate(Database database, int n, String string, String string2, boolean bl) {
        this.initDbObjectBase(database, n, string, "function");
        this.className = string2;
        if (!bl) {
            this.getInstance();
        }
    }

    public Aggregate getInstance() {
        if (this.javaClass == null) {
            this.javaClass = Utils.loadUserClass(this.className);
        }
        try {
            Object obj = this.javaClass.newInstance();
            Aggregate aggregate = obj instanceof Aggregate ? (Aggregate)obj : new AggregateWrapper((AggregateFunction)obj);
            return aggregate;
        }
        catch (Exception exception) {
            throw DbException.convert(exception);
        }
    }

    @Override
    public String getCreateSQLForCopy(Table table, String string) {
        throw DbException.throwInternalError();
    }

    @Override
    public String getDropSQL() {
        return "DROP AGGREGATE IF EXISTS " + this.getSQL();
    }

    @Override
    public String getCreateSQL() {
        return "CREATE FORCE AGGREGATE " + this.getSQL() + " FOR " + Parser.quoteIdentifier(this.className);
    }

    @Override
    public int getType() {
        return 14;
    }

    @Override
    public synchronized void removeChildrenAndResources(Session session) {
        this.database.removeMeta(session, this.getId());
        this.className = null;
        this.javaClass = null;
        this.invalidate();
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("AGGREGATE");
    }

    public String getJavaClassName() {
        return this.className;
    }

    private static class AggregateWrapper
    implements Aggregate {
        private final AggregateFunction aggregateFunction;

        AggregateWrapper(AggregateFunction aggregateFunction) {
            this.aggregateFunction = aggregateFunction;
        }

        @Override
        public void init(Connection connection) throws SQLException {
            this.aggregateFunction.init(connection);
        }

        @Override
        public int getInternalType(int[] nArray) throws SQLException {
            int[] nArray2 = new int[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray2[i] = DataType.convertTypeToSQLType(nArray[i]);
            }
            return DataType.convertSQLTypeToValueType(this.aggregateFunction.getType(nArray2));
        }

        @Override
        public void add(Object object) throws SQLException {
            this.aggregateFunction.add(object);
        }

        @Override
        public Object getResult() throws SQLException {
            return this.aggregateFunction.getResult();
        }
    }
}

