/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.MoreConfigDefaults;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.CassandraProfile;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ConfigRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util.Compilations;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util.Encryption;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util.IdGenerator;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util.LazySecretKey;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.BindAgentRollupId;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.BindRequest;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.GET;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableSyntheticMonitorConfigDto;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableSyntheticMonitorConfigListDto;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.JsonService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.JsonServiceException;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.POST;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.Module;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.glowroot.agent.shaded.com.google.common.annotations.VisibleForTesting;
import org.glowroot.agent.shaded.com.google.common.base.Optional;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.base.Strings;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Ordering;
import org.glowroot.agent.shaded.com.google.common.io.CharStreams;
import org.glowroot.agent.shaded.com.google.protobuf.AbstractMessage;
import org.glowroot.agent.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import org.glowroot.agent.shaded.org.glowroot.common.util.ObjectMappers;
import org.glowroot.agent.shaded.org.glowroot.common.util.Versions;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AgentConfigOuterClass;
import org.immutables.value.Value;

@JsonService
class SyntheticMonitorConfigJsonService {
    private static final ObjectMapper mapper = ObjectMappers.create((Module[])new Module[0]);
    private static final Pattern encryptPattern = Pattern.compile("\"ENCRYPT:([^\"]*)\"");
    @VisibleForTesting
    static final Ordering<AgentConfigOuterClass.AgentConfig.SyntheticMonitorConfig> orderingByDisplay = new Ordering<AgentConfigOuterClass.AgentConfig.SyntheticMonitorConfig>(){

        public int compare(AgentConfigOuterClass.AgentConfig.SyntheticMonitorConfig left, AgentConfigOuterClass.AgentConfig.SyntheticMonitorConfig right) {
            return MoreConfigDefaults.getDisplayOrDefault(left).compareToIgnoreCase(MoreConfigDefaults.getDisplayOrDefault(right));
        }
    };
    private final ConfigRepository configRepository;

    SyntheticMonitorConfigJsonService(ConfigRepository configRepository) {
        this.configRepository = configRepository;
    }

    @GET(path="/backend/config/synthetic-monitors", permission="agent:config:view:syntheticMonitor")
    String getSyntheticMonitor(@BindAgentRollupId String agentRollupId, @BindRequest SyntheticMonitorConfigRequest request) throws Exception {
        Optional<String> id = request.id();
        if (id.isPresent()) {
            AgentConfigOuterClass.AgentConfig.SyntheticMonitorConfig config = this.configRepository.getSyntheticMonitorConfig(agentRollupId, (String)id.get()).toCompletableFuture().join();
            if (config == null) {
                throw new JsonServiceException(HttpResponseStatus.NOT_FOUND);
            }
            return mapper.writeValueAsString((Object)SyntheticMonitorConfigDto.create(config));
        }
        ArrayList configDtos = Lists.newArrayList();
        ImmutableList configs = this.configRepository.getSyntheticMonitorConfigs(agentRollupId).toCompletableFuture().join();
        configs = orderingByDisplay.immutableSortedCopy(configs);
        for (AgentConfigOuterClass.AgentConfig.SyntheticMonitorConfig config : configs) {
            configDtos.add(SyntheticMonitorConfigListDto.create(config));
        }
        return mapper.writeValueAsString((Object)configDtos);
    }

    @POST(path="/backend/config/synthetic-monitors/add", permission="agent:config:edit:syntheticMonitors")
    String addSyntheticMonitor(@BindAgentRollupId String agentRollupId, @BindRequest SyntheticMonitorConfigDto configDto) throws Exception {
        AgentConfigOuterClass.AgentConfig.SyntheticMonitorConfig config;
        try {
            config = configDto.convert(this.configRepository.getLazySecretKey());
        }
        catch (LazySecretKey.SymmetricEncryptionKeyMissingException e) {
            return "{\"symmetricEncryptionKeyMissing\":true}";
        }
        String errorResponse = SyntheticMonitorConfigJsonService.validate(config);
        if (errorResponse != null) {
            return errorResponse;
        }
        String id = config.getId();
        if (id.isEmpty()) {
            id = IdGenerator.generateNewId();
            config = config.toBuilder().setId(id).build();
        }
        this.configRepository.insertSyntheticMonitorConfig(agentRollupId, config, CassandraProfile.web).toCompletableFuture().join();
        return mapper.writeValueAsString((Object)SyntheticMonitorConfigDto.create(config));
    }

    @POST(path="/backend/config/synthetic-monitors/update", permission="agent:config:edit:syntheticMonitors")
    String updateSyntheticMonitor(@BindAgentRollupId String agentRollupId, @BindRequest SyntheticMonitorConfigDto configDto) throws Exception {
        AgentConfigOuterClass.AgentConfig.SyntheticMonitorConfig config;
        try {
            config = configDto.convert(this.configRepository.getLazySecretKey());
        }
        catch (LazySecretKey.SymmetricEncryptionKeyMissingException e) {
            return "{\"symmetricEncryptionKeyMissing\":true}";
        }
        String errorResponse = SyntheticMonitorConfigJsonService.validate(config);
        if (errorResponse != null) {
            return errorResponse;
        }
        this.configRepository.updateSyntheticMonitorConfig(agentRollupId, config, (String)configDto.version().get(), CassandraProfile.web).toCompletableFuture().join();
        return mapper.writeValueAsString((Object)SyntheticMonitorConfigDto.create(config));
    }

    @POST(path="/backend/config/synthetic-monitors/remove", permission="agent:config:edit:syntheticMonitors")
    void removeSyntheticMonitor(@BindAgentRollupId String agentRollupId, @BindRequest SyntheticMonitorConfigRequest request) throws Exception {
        this.configRepository.deleteSyntheticMonitorConfig(agentRollupId, (String)request.id().get(), CassandraProfile.web).toCompletableFuture().join();
    }

    private static @Nullable String validate(AgentConfigOuterClass.AgentConfig.SyntheticMonitorConfig config) throws Exception {
        if (config.getKind() == AgentConfigOuterClass.AgentConfig.SyntheticMonitorConfig.SyntheticMonitorKind.JAVA) {
            Class<?> javaSource;
            try {
                javaSource = Compilations.compile(config.getJavaSource());
            }
            catch (Compilations.CompilationException e) {
                return SyntheticMonitorConfigJsonService.buildCompilationErrorResponse(e.getCompilationErrors());
            }
            try {
                javaSource.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                return SyntheticMonitorConfigJsonService.buildCompilationErrorResponse((List<String>)ImmutableList.of((Object)"Class must have a public default constructor"));
            }
            Class<?> httpClientClass = Class.forName("org.apache.http.impl.client.CloseableHttpClient");
            try {
                javaSource.getMethod("test", httpClientClass);
            }
            catch (NoSuchMethodException e) {
                Class<?> webDriverClass = Class.forName("org.openqa.selenium.WebDriver");
                try {
                    javaSource.getMethod("test", webDriverClass);
                }
                catch (NoSuchMethodException f) {
                    return SyntheticMonitorConfigJsonService.buildCompilationErrorResponse((List<String>)ImmutableList.of((Object)"Class must have a \"public void test(HttpClient httpClient) { ... }\" or \"public void test(WebDriver driver) { ... }\" method"));
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String buildCompilationErrorResponse(List<String> compilationErrors) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (JsonGenerator jg = mapper.getFactory().createGenerator(CharStreams.asWriter((Appendable)sb));){
            jg.writeStartObject();
            jg.writeArrayFieldStart("javaSourceCompilationErrors");
            for (String compilationError : compilationErrors) {
                jg.writeString(compilationError);
            }
            jg.writeEndArray();
            jg.writeEndObject();
        }
        return sb.toString();
    }

    @Value.Immutable
    static abstract class SyntheticMonitorConfigDto {
        SyntheticMonitorConfigDto() {
        }

        abstract AgentConfigOuterClass.AgentConfig.SyntheticMonitorConfig.SyntheticMonitorKind kind();

        abstract @Nullable String display();

        abstract @Nullable String pingUrl();

        abstract @Nullable String javaSource();

        abstract Optional<String> id();

        abstract Optional<String> version();

        private AgentConfigOuterClass.AgentConfig.SyntheticMonitorConfig convert(LazySecretKey lazySecretKey) throws Exception {
            Optional<String> id;
            String javaSource;
            AgentConfigOuterClass.AgentConfig.SyntheticMonitorConfig.Builder builder = AgentConfigOuterClass.AgentConfig.SyntheticMonitorConfig.newBuilder().setDisplay(Strings.nullToEmpty((String)this.display())).setKind(this.kind());
            String pingUrl = this.pingUrl();
            if (pingUrl != null) {
                builder.setPingUrl(pingUrl);
            }
            if ((javaSource = this.javaSource()) != null) {
                Matcher matcher = encryptPattern.matcher(javaSource);
                StringBuffer sb = new StringBuffer();
                while (matcher.find()) {
                    String unencryptedPassword = (String)Preconditions.checkNotNull((Object)matcher.group(1));
                    matcher.appendReplacement(sb, "\"ENCRYPTED:" + Encryption.encrypt(unencryptedPassword, lazySecretKey) + "\"");
                }
                matcher.appendTail(sb);
                builder.setJavaSource(sb.toString());
            }
            if ((id = this.id()).isPresent()) {
                builder.setId((String)id.get());
            }
            return builder.build();
        }

        private static SyntheticMonitorConfigDto create(AgentConfigOuterClass.AgentConfig.SyntheticMonitorConfig config) {
            String javaSource;
            ImmutableSyntheticMonitorConfigDto.Builder builder = ImmutableSyntheticMonitorConfigDto.builder().display(config.getDisplay()).kind(config.getKind());
            String pingUrl = config.getPingUrl();
            if (!pingUrl.isEmpty()) {
                builder.pingUrl(pingUrl);
            }
            if (!(javaSource = config.getJavaSource()).isEmpty()) {
                builder.javaSource(javaSource);
            }
            return builder.id(config.getId()).version(Versions.getVersion((AbstractMessage)config)).build();
        }
    }

    @Value.Immutable
    static abstract class SyntheticMonitorConfigListDto {
        SyntheticMonitorConfigListDto() {
        }

        abstract String display();

        abstract String id();

        private static SyntheticMonitorConfigListDto create(AgentConfigOuterClass.AgentConfig.SyntheticMonitorConfig config) {
            return ImmutableSyntheticMonitorConfigListDto.builder().display(MoreConfigDefaults.getDisplayOrDefault(config)).id(config.getId()).build();
        }
    }

    @Value.Immutable
    static interface SyntheticMonitorConfigRequest {
        public Optional<String> id();
    }
}

