/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.management.ObjectName;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.CassandraProfile;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ConfigRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.EnvironmentRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util.UsedByJsonSerialization;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.BindAgentId;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.BindRequest;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.GET;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.JsonService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ObjectNames;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.POST;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.Module;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.base.Splitter;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableSet;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableSortedMap;
import org.glowroot.agent.shaded.com.google.common.collect.Iterables;
import org.glowroot.agent.shaded.com.google.common.collect.LinkedListMultimap;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Maps;
import org.glowroot.agent.shaded.com.google.common.collect.Ordering;
import org.glowroot.agent.shaded.com.google.common.collect.Sets;
import org.glowroot.agent.shaded.com.google.common.io.CharStreams;
import org.glowroot.agent.shaded.com.google.common.primitives.Longs;
import org.glowroot.agent.shaded.org.glowroot.common.live.LiveJvmService;
import org.glowroot.agent.shaded.org.glowroot.common.util.Masking;
import org.glowroot.agent.shaded.org.glowroot.common.util.ObjectMappers;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.CollectorServiceOuterClass;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.DownstreamServiceOuterClass;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.immutables.value.Value;

@JsonService
class JvmJsonService {
    private static final Logger logger = LoggerFactory.getLogger(JvmJsonService.class);
    private static final ObjectMapper mapper = ObjectMappers.create((Module[])new Module[0]);
    private static final Set<String> PATH_SEPARATED_SYSTEM_PROPERTIES = ImmutableSet.of((Object)"java.class.path", (Object)"java.ext.dirs", (Object)"java.library.path", (Object)"sun.boot.class.path");
    private final EnvironmentRepository environmentRepository;
    private final ConfigRepository configRepository;
    private final @Nullable LiveJvmService liveJvmService;

    JvmJsonService(EnvironmentRepository environmentRepository, ConfigRepository configRepository, @Nullable LiveJvmService liveJvmService) {
        this.environmentRepository = environmentRepository;
        this.configRepository = configRepository;
        this.liveJvmService = liveJvmService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET(path="/backend/jvm/environment", permission="agent:jvm:environment")
    String getEnvironment(@BindAgentId String agentId) throws Exception {
        CollectorServiceOuterClass.InitMessage.Environment environment = this.environmentRepository.read(agentId, CassandraProfile.web).toCompletableFuture().join();
        if (environment == null) {
            return "{}";
        }
        CollectorServiceOuterClass.InitMessage.Environment.HostInfo hostInfo = environment.getHostInfo();
        CollectorServiceOuterClass.InitMessage.Environment.ProcessInfo processInfo = environment.getProcessInfo();
        CollectorServiceOuterClass.InitMessage.Environment.JavaInfo javaInfo = environment.getJavaInfo();
        StringBuilder sb = new StringBuilder();
        try (JsonGenerator jg = mapper.getFactory().createGenerator(CharStreams.asWriter((Appendable)sb));){
            jg.writeStartObject();
            Long hostCurrentTime = null;
            if (this.liveJvmService != null) {
                jg.writeBooleanField("agentNotConnected", !this.liveJvmService.isAvailable(agentId));
                try {
                    hostCurrentTime = this.liveJvmService.getCurrentTime(agentId);
                }
                catch (LiveJvmService.AgentNotConnectedException e) {
                    logger.debug(e.getMessage(), (Throwable)e);
                }
                catch (LiveJvmService.AgentUnsupportedOperationException e) {
                    logger.debug(e.getMessage(), (Throwable)e);
                }
            }
            jg.writeObjectFieldStart("host");
            jg.writeStringField("hostname", hostInfo.getHostname());
            jg.writeNumberField("availableProcessors", hostInfo.getAvailableProcessors());
            if (hostInfo.hasTotalPhysicalMemoryBytes()) {
                jg.writeNumberField("totalPhysicalMemoryBytes", hostInfo.getTotalPhysicalMemoryBytes().getValue());
            }
            jg.writeStringField("osName", hostInfo.getOsName());
            jg.writeStringField("osVersion", hostInfo.getOsVersion());
            if (hostCurrentTime != null) {
                jg.writeNumberField("currentTime", hostCurrentTime.longValue());
            }
            jg.writeEndObject();
            jg.writeObjectFieldStart("process");
            if (processInfo.hasProcessId()) {
                jg.writeNumberField("processId", processInfo.getProcessId().getValue());
            }
            jg.writeNumberField("startTime", processInfo.getStartTime());
            jg.writeEndObject();
            jg.writeObjectFieldStart("java");
            jg.writeStringField("version", javaInfo.getVersion());
            jg.writeStringField("vm", javaInfo.getVm());
            jg.writeArrayFieldStart("args");
            for (String arg : Masking.maskJvmArgs((List)javaInfo.getArgList(), this.getJvmMaskSystemProperties(agentId))) {
                jg.writeString(arg);
            }
            jg.writeEndArray();
            jg.writeStringField("glowrootAgentVersion", javaInfo.getGlowrootAgentVersion());
            jg.writeEndObject();
            jg.writeEndObject();
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET(path="/backend/jvm/thread-dump", permission="agent:jvm:threadDump")
    String getThreadDump(@BindAgentId String agentId) throws Exception {
        DownstreamServiceOuterClass.ThreadDump threadDump;
        Preconditions.checkNotNull((Object)this.liveJvmService);
        try {
            threadDump = this.liveJvmService.getThreadDump(agentId);
        }
        catch (LiveJvmService.AgentNotConnectedException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return "{\"agentNotConnected\":true}";
        }
        ArrayList allThreads = Lists.newArrayList();
        StringBuilder sb = new StringBuilder();
        try (JsonGenerator jg = mapper.getFactory().createGenerator(CharStreams.asWriter((Appendable)sb));){
            jg.writeStartObject();
            jg.writeArrayFieldStart("transactions");
            List transactions = new TransactionOrderingByTotalTimeDesc().sortedCopy(threadDump.getTransactionList());
            for (DownstreamServiceOuterClass.ThreadDump.Transaction transaction : transactions) {
                JvmJsonService.writeTransactionThread(transaction, jg);
                allThreads.addAll(transaction.getThreadList());
            }
            jg.writeEndArray();
            List unmatchedThreads = new ThreadOrderingByStackTraceSizeDesc().sortedCopy(threadDump.getUnmatchedThreadList());
            LinkedListMultimap unmatchedThreadsGroupedByStackTrace = LinkedListMultimap.create();
            ArrayList glowrootThreads = Lists.newArrayList();
            for (DownstreamServiceOuterClass.ThreadDump.Thread thread : unmatchedThreads) {
                if (thread.getName().startsWith("Glowroot-")) {
                    glowrootThreads.add(thread);
                } else {
                    unmatchedThreadsGroupedByStackTrace.put((Object)JvmJsonService.getGrouping(thread), (Object)thread);
                }
                allThreads.add(thread);
            }
            jg.writeArrayFieldStart("unmatchedThreadsByStackTrace");
            for (Map.Entry entry : unmatchedThreadsGroupedByStackTrace.asMap().entrySet()) {
                jg.writeStartArray();
                for (DownstreamServiceOuterClass.ThreadDump.Thread thread : (Collection)entry.getValue()) {
                    JvmJsonService.writeThread(thread, jg);
                }
                jg.writeEndArray();
            }
            jg.writeStartArray();
            for (DownstreamServiceOuterClass.ThreadDump.Thread thread : glowrootThreads) {
                JvmJsonService.writeThread(thread, jg);
            }
            jg.writeEndArray();
            jg.writeEndArray();
            jg.writeFieldName("threadDumpingThread");
            JvmJsonService.writeThread(threadDump.getThreadDumpingThread(), jg);
            allThreads.add(threadDump.getThreadDumpingThread());
            JvmJsonService.writeDeadlockedCycles(allThreads, jg);
            jg.writeEndObject();
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET(path="/backend/jvm/jstack", permission="agent:jvm:threadDump")
    String getJstack(@BindAgentId String agentId) throws Exception {
        String jstack;
        Preconditions.checkNotNull((Object)this.liveJvmService);
        try {
            jstack = this.liveJvmService.getJstack(agentId);
        }
        catch (LiveJvmService.AgentNotConnectedException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return "{\"agentNotConnected\":true}";
        }
        catch (LiveJvmService.UnavailableDueToRunningInJreException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return "{\"unavailableDueToRunningInJre\":true}";
        }
        catch (LiveJvmService.UnavailableDueToRunningInJ9JvmException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return "{\"unavailableDueToRunningInJ9Jvm\":true}";
        }
        catch (LiveJvmService.AgentUnsupportedOperationException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return this.getAgentUnsupportedOperationResponse(agentId);
        }
        StringBuilder sb = new StringBuilder();
        try (JsonGenerator jg = mapper.getFactory().createGenerator(CharStreams.asWriter((Appendable)sb));){
            jg.writeStartObject();
            jg.writeStringField("jstack", jstack);
            jg.writeEndObject();
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET(path="/backend/jvm/heap-dump-default-dir", permission="agent:jvm:heapDump")
    String getHeapDumpDefaultDir(@BindAgentId String agentId) throws Exception {
        Preconditions.checkNotNull((Object)this.liveJvmService);
        if (!this.liveJvmService.isAvailable(agentId)) {
            return "{\"agentNotConnected\":true}";
        }
        CollectorServiceOuterClass.InitMessage.Environment environment = this.environmentRepository.read(agentId, CassandraProfile.web).toCompletableFuture().join();
        Preconditions.checkNotNull((Object)environment);
        StringBuilder sb = new StringBuilder();
        try (JsonGenerator jg = mapper.getFactory().createGenerator(CharStreams.asWriter((Appendable)sb));){
            jg.writeStartObject();
            jg.writeStringField("directory", environment.getJavaInfo().getHeapDumpDefaultDir());
            jg.writeEndObject();
        }
        return sb.toString();
    }

    @POST(path="/backend/jvm/available-disk-space", permission="agent:jvm:heapDump")
    String getAvailableDiskSpace(@BindAgentId String agentId, @BindRequest HeapDumpRequest request) throws Exception {
        Preconditions.checkNotNull((Object)this.liveJvmService);
        try {
            return Long.toString(this.liveJvmService.getAvailableDiskSpace(agentId, request.directory()));
        }
        catch (LiveJvmService.DirectoryDoesNotExistException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return "{\"directoryDoesNotExist\": true}";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST(path="/backend/jvm/heap-dump", permission="agent:jvm:heapDump")
    String heapDump(@BindAgentId String agentId, @BindRequest HeapDumpRequest request) throws Exception {
        DownstreamServiceOuterClass.HeapDumpFileInfo heapDumpFileInfo;
        Preconditions.checkNotNull((Object)this.liveJvmService);
        try {
            heapDumpFileInfo = this.liveJvmService.heapDump(agentId, request.directory());
        }
        catch (LiveJvmService.DirectoryDoesNotExistException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return "{\"directoryDoesNotExist\": true}";
        }
        StringBuilder sb = new StringBuilder();
        try (JsonGenerator jg = mapper.getFactory().createGenerator(CharStreams.asWriter((Appendable)sb));){
            jg.writeStartObject();
            jg.writeStringField("filePath", heapDumpFileInfo.getFilePath());
            jg.writeNumberField("fileSizeBytes", heapDumpFileInfo.getFileSizeBytes());
            jg.writeEndObject();
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST(path="/backend/jvm/heap-histogram", permission="agent:jvm:heapHistogram")
    String heapHistogram(@BindAgentId String agentId) throws Exception {
        DownstreamServiceOuterClass.HeapHistogram heapHistogram;
        Preconditions.checkNotNull((Object)this.liveJvmService);
        try {
            heapHistogram = this.liveJvmService.heapHistogram(agentId);
        }
        catch (LiveJvmService.AgentNotConnectedException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return "{\"agentNotConnected\":true}";
        }
        catch (LiveJvmService.UnavailableDueToRunningInJreException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return "{\"unavailableDueToRunningInJre\":true}";
        }
        catch (LiveJvmService.UnavailableDueToRunningInJ9JvmException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return "{\"unavailableDueToRunningInJ9Jvm\":true}";
        }
        catch (LiveJvmService.UnavailableDueToDockerAlpinePidOneException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return "{\"unavailableDueToDockerAlpinePidOne\":true}";
        }
        catch (LiveJvmService.AgentUnsupportedOperationException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return this.getAgentUnsupportedOperationResponse(agentId);
        }
        StringBuilder sb = new StringBuilder();
        try (JsonGenerator jg = mapper.getFactory().createGenerator(CharStreams.asWriter((Appendable)sb));){
            jg.writeStartObject();
            jg.writeArrayFieldStart("items");
            long totalBytes = 0L;
            long totalCount = 0L;
            for (DownstreamServiceOuterClass.HeapHistogram.ClassInfo classInfo : heapHistogram.getClassInfoList()) {
                jg.writeStartObject();
                jg.writeStringField("className", classInfo.getClassName());
                jg.writeNumberField("bytes", classInfo.getBytes());
                jg.writeNumberField("count", classInfo.getCount());
                jg.writeEndObject();
                totalBytes += classInfo.getBytes();
                totalCount += classInfo.getCount();
            }
            jg.writeEndArray();
            jg.writeNumberField("totalBytes", totalBytes);
            jg.writeNumberField("totalCount", totalCount);
            jg.writeEndObject();
        }
        return sb.toString();
    }

    @GET(path="/backend/jvm/explicit-gc-disabled", permission="agent:jvm:forceGC")
    String explicitGcDisabled(@BindAgentId String agentId) throws Exception {
        Preconditions.checkNotNull((Object)this.liveJvmService);
        try {
            boolean explicitGcDisabled = this.liveJvmService.isExplicitGcDisabled(agentId);
            return "{\"explicitGcDisabled\":" + explicitGcDisabled + "}";
        }
        catch (LiveJvmService.AgentNotConnectedException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return "{\"agentNotConnected\":true}";
        }
    }

    @POST(path="/backend/jvm/force-gc", permission="agent:jvm:forceGC")
    void performGC(@BindAgentId String agentId) throws Exception {
        Preconditions.checkNotNull((Object)this.liveJvmService);
        this.liveJvmService.forceGC(agentId);
    }

    @GET(path="/backend/jvm/mbean-tree", permission="agent:jvm:mbeanTree")
    String getMBeanTree(@BindAgentId String agentId, @BindRequest MBeanTreeRequest request) throws Exception {
        DownstreamServiceOuterClass.MBeanDump mbeanDump;
        Preconditions.checkNotNull((Object)this.liveJvmService);
        try {
            mbeanDump = this.liveJvmService.getMBeanDump(agentId, DownstreamServiceOuterClass.MBeanDumpRequest.MBeanDumpKind.ALL_MBEANS_INCLUDE_ATTRIBUTES_FOR_SOME, request.expanded());
        }
        catch (LiveJvmService.AgentNotConnectedException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return "{\"agentNotConnected\":true}";
        }
        TreeMap sortedRootNodes = Maps.newTreeMap();
        for (DownstreamServiceOuterClass.MBeanDump.MBeanInfo mbeanInfo : mbeanDump.getMbeanInfoList()) {
            ObjectName objectName = ObjectName.getInstance(mbeanInfo.getObjectName());
            String domain = objectName.getDomain();
            MBeanTreeInnerNode node = (MBeanTreeInnerNode)sortedRootNodes.get(domain);
            if (node == null) {
                node = new MBeanTreeInnerNode(domain);
                sortedRootNodes.put(domain, node);
            }
            List<String> propertyValues = ObjectNames.getPropertyValues(objectName);
            for (int i = 0; i < propertyValues.size() - 1; ++i) {
                node = node.getOrCreateNode(propertyValues.get(i));
            }
            String name = objectName.toString();
            String value = (String)Iterables.getLast(propertyValues);
            if (request.expanded().contains(name)) {
                node.addLeafNode(new MBeanTreeLeafNode(value, name, true, JvmJsonService.getSortedAttributeMap(mbeanInfo.getAttributeList())));
                continue;
            }
            node.addLeafNode(new MBeanTreeLeafNode(value, name, false, null));
        }
        return mapper.writeValueAsString((Object)sortedRootNodes);
    }

    @GET(path="/backend/jvm/mbean-attribute-map", permission="agent:jvm:mbeanTree")
    String getMBeanAttributeMap(@BindAgentId String agentId, @BindRequest MBeanAttributeMapRequest request) throws Exception {
        Preconditions.checkNotNull((Object)this.liveJvmService);
        DownstreamServiceOuterClass.MBeanDump mbeanDump = this.liveJvmService.getMBeanDump(agentId, DownstreamServiceOuterClass.MBeanDumpRequest.MBeanDumpKind.SOME_MBEANS_INCLUDE_ATTRIBUTES, (List)ImmutableList.of((Object)request.objectName()));
        List mbeanInfos = mbeanDump.getMbeanInfoList();
        if (mbeanInfos.isEmpty()) {
            throw new IllegalStateException("Could not find mbean with object name: " + request.objectName());
        }
        if (mbeanInfos.size() > 1) {
            logger.warn("returned more than one mbean with object name: {}", (Object)request.objectName());
        }
        DownstreamServiceOuterClass.MBeanDump.MBeanInfo mbeanInfo = (DownstreamServiceOuterClass.MBeanDump.MBeanInfo)mbeanInfos.get(0);
        return mapper.writeValueAsString(JvmJsonService.getSortedAttributeMap(mbeanInfo.getAttributeList()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET(path="/backend/jvm/system-properties", permission="agent:jvm:systemProperties")
    String getSystemProperties(@BindAgentId String agentId) throws Exception {
        Map properties;
        Preconditions.checkNotNull((Object)this.liveJvmService);
        try {
            properties = this.liveJvmService.getSystemProperties(agentId);
        }
        catch (LiveJvmService.AgentNotConnectedException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return "{\"agentNotConnected\":true}";
        }
        catch (LiveJvmService.AgentUnsupportedOperationException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return this.getAgentUnsupportedOperationResponse(agentId);
        }
        List<String> maskSystemProperties = this.getJvmMaskSystemProperties(agentId);
        properties = Masking.maskSystemProperties((Map)properties, maskSystemProperties);
        StringBuilder sb = new StringBuilder();
        try (JsonGenerator jg = mapper.getFactory().createGenerator(CharStreams.asWriter((Appendable)sb));){
            jg.writeStartObject();
            jg.writeArrayFieldStart("properties");
            for (Map.Entry entry : ImmutableSortedMap.copyOf((Map)properties).entrySet()) {
                jg.writeStartObject();
                String propertyName = (String)entry.getKey();
                jg.writeStringField("name", propertyName);
                if (PATH_SEPARATED_SYSTEM_PROPERTIES.contains(propertyName)) {
                    jg.writeArrayFieldStart("value");
                    for (String item : Splitter.on((char)File.pathSeparatorChar).splitToList((CharSequence)entry.getValue())) {
                        jg.writeString(item);
                    }
                    jg.writeEndArray();
                } else {
                    jg.writeStringField("value", (String)entry.getValue());
                }
                jg.writeEndObject();
            }
            jg.writeEndArray();
            jg.writeEndObject();
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET(path="/backend/jvm/capabilities", permission="agent:jvm:capabilities")
    String getCapabilities(@BindAgentId String agentId) throws Exception {
        DownstreamServiceOuterClass.Capabilities capabilities;
        Preconditions.checkNotNull((Object)this.liveJvmService);
        try {
            capabilities = this.liveJvmService.getCapabilities(agentId);
        }
        catch (LiveJvmService.AgentNotConnectedException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return "{\"agentNotConnected\":true}";
        }
        StringBuilder sb = new StringBuilder();
        try (JsonGenerator jg = mapper.getFactory().createGenerator(CharStreams.asWriter((Appendable)sb));){
            jg.writeStartObject();
            JvmJsonService.writeAvailability("threadCpuTime", capabilities.getThreadCpuTime(), jg);
            JvmJsonService.writeAvailability("threadContentionTime", capabilities.getThreadContentionTime(), jg);
            JvmJsonService.writeAvailability("threadAllocatedBytes", capabilities.getThreadAllocatedBytes(), jg);
            jg.writeEndObject();
        }
        return sb.toString();
    }

    private List<String> getJvmMaskSystemProperties(String agentId) throws Exception {
        try {
            return this.configRepository.getJvmConfig(agentId).getMaskSystemPropertyList();
        }
        catch (ConfigRepository.AgentConfigNotFoundException e) {
            return ImmutableList.of();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAgentUnsupportedOperationResponse(String agentId) throws Exception {
        StringBuilder sb = new StringBuilder();
        try (JsonGenerator jg = mapper.getFactory().createGenerator(CharStreams.asWriter((Appendable)sb));){
            jg.writeStartObject();
            jg.writeStringField("agentUnsupportedOperation", this.getAgentVersion(agentId));
            jg.writeEndObject();
        }
        return sb.toString();
    }

    private String getAgentVersion(String agentId) throws Exception {
        CollectorServiceOuterClass.InitMessage.Environment environment = this.environmentRepository.read(agentId, CassandraProfile.web).toCompletableFuture().join();
        return environment == null ? "unknown" : environment.getJavaInfo().getGlowrootAgentVersion();
    }

    private static void writeAvailability(String fieldName, DownstreamServiceOuterClass.Availability availability, JsonGenerator jg) throws IOException {
        jg.writeObjectFieldStart(fieldName);
        jg.writeBooleanField("available", availability.getAvailable());
        jg.writeStringField("reason", availability.getReason());
        jg.writeEndObject();
    }

    private static void writeTransactionThread(DownstreamServiceOuterClass.ThreadDump.Transaction transaction, JsonGenerator jg) throws IOException {
        jg.writeStartObject();
        jg.writeStringField("traceId", transaction.getTraceId());
        jg.writeStringField("headline", transaction.getHeadline());
        jg.writeStringField("transactionType", transaction.getTransactionType());
        jg.writeStringField("transactionName", transaction.getTransactionName());
        jg.writeNumberField("durationNanos", transaction.getDurationNanos());
        if (transaction.hasCpuNanos()) {
            jg.writeNumberField("cpuNanos", transaction.getCpuNanos().getValue());
        } else {
            jg.writeNumberField("cpuNanos", -1);
        }
        jg.writeArrayFieldStart("threads");
        for (DownstreamServiceOuterClass.ThreadDump.Thread thread : transaction.getThreadList()) {
            JvmJsonService.writeThread(thread, jg);
        }
        jg.writeEndArray();
        jg.writeEndObject();
    }

    private static DownstreamServiceOuterClass.ThreadDump.Thread getGrouping(DownstreamServiceOuterClass.ThreadDump.Thread thread) {
        DownstreamServiceOuterClass.ThreadDump.Thread.Builder builder = DownstreamServiceOuterClass.ThreadDump.Thread.newBuilder();
        for (DownstreamServiceOuterClass.ThreadDump.StackTraceElement stackTraceElement : thread.getStackTraceElementList()) {
            builder.addStackTraceElement(stackTraceElement.toBuilder().clearMonitorInfo());
        }
        return builder.build();
    }

    private static void writeThread(DownstreamServiceOuterClass.ThreadDump.Thread thread, JsonGenerator jg) throws IOException {
        jg.writeStartObject();
        jg.writeStringField("name", thread.getName());
        jg.writeStringField("id", Long.toString(thread.getId()));
        jg.writeStringField("state", thread.getState());
        jg.writeArrayFieldStart("stackTraceElements");
        boolean first = true;
        for (DownstreamServiceOuterClass.ThreadDump.StackTraceElement stackTraceElement : thread.getStackTraceElementList()) {
            JvmJsonService.writeStackTraceElement(stackTraceElement, jg);
            if (first) {
                if (thread.hasLockInfo()) {
                    if (thread.getState().equals(Thread.State.BLOCKED.name())) {
                        JvmJsonService.writeMonitorInfo("waiting to lock", thread.getLockInfo(), jg);
                    } else {
                        JvmJsonService.writeMonitorInfo("waiting on", thread.getLockInfo(), jg);
                    }
                } else {
                    String lockName = thread.getLockName();
                    if (!lockName.isEmpty()) {
                        if (thread.getState().equals(Thread.State.BLOCKED.name())) {
                            jg.writeString("- waiting to lock " + lockName);
                        } else {
                            jg.writeString("- waiting on " + lockName);
                        }
                    }
                }
            }
            for (DownstreamServiceOuterClass.ThreadDump.LockInfo monitorInfo : stackTraceElement.getMonitorInfoList()) {
                JvmJsonService.writeMonitorInfo("locked on", monitorInfo, jg);
            }
            first = false;
        }
        jg.writeEndArray();
        jg.writeEndObject();
    }

    private static void writeDeadlockedCycles(List<DownstreamServiceOuterClass.ThreadDump.Thread> allThreads, JsonGenerator jg) throws IOException {
        HashMap blockedThreads = Maps.newHashMap();
        for (DownstreamServiceOuterClass.ThreadDump.Thread thread : allThreads) {
            if (!thread.hasLockOwnerId()) continue;
            blockedThreads.put(thread.getId(), thread);
        }
        List<List<DownstreamServiceOuterClass.ThreadDump.Thread>> deadlockedCycles = JvmJsonService.findDeadlockedCycles(blockedThreads);
        jg.writeArrayFieldStart("deadlockedCycles");
        for (List<DownstreamServiceOuterClass.ThreadDump.Thread> deadlockedCycle : deadlockedCycles) {
            jg.writeStartArray();
            for (DownstreamServiceOuterClass.ThreadDump.Thread thread : deadlockedCycle) {
                jg.writeStartObject();
                jg.writeStringField("name", thread.getName());
                DownstreamServiceOuterClass.ThreadDump.LockInfo lockInfo = thread.getLockInfo();
                jg.writeStringField("desc1", "waiting to lock " + lockInfo.getClassName() + "@" + Integer.toHexString(lockInfo.getIdentityHashCode()));
                DownstreamServiceOuterClass.ThreadDump.Thread lockOwner = (DownstreamServiceOuterClass.ThreadDump.Thread)Preconditions.checkNotNull((Object)((DownstreamServiceOuterClass.ThreadDump.Thread)blockedThreads.get(thread.getLockOwnerId().getValue())));
                jg.writeStringField("desc2", "which is held by \"" + lockOwner.getName() + "\"");
                jg.writeEndObject();
            }
            jg.writeEndArray();
        }
        jg.writeEndArray();
    }

    private static List<List<DownstreamServiceOuterClass.ThreadDump.Thread>> findDeadlockedCycles(Map<Long, DownstreamServiceOuterClass.ThreadDump.Thread> blockedThreads) {
        if (blockedThreads.isEmpty()) {
            return ImmutableList.of();
        }
        HashMap remainingBlockedThreads = Maps.newHashMap(blockedThreads);
        ArrayList cycleRoots = Lists.newArrayList();
        block0: while (!remainingBlockedThreads.isEmpty()) {
            Iterator i = remainingBlockedThreads.entrySet().iterator();
            Map.Entry entry = i.next();
            long currThreadId = (Long)entry.getKey();
            DownstreamServiceOuterClass.ThreadDump.Thread currThread = (DownstreamServiceOuterClass.ThreadDump.Thread)entry.getValue();
            i.remove();
            HashSet seenThreadIds = Sets.newHashSet();
            while (currThread != null) {
                seenThreadIds.add(currThreadId);
                currThreadId = currThread.getLockOwnerId().getValue();
                if (seenThreadIds.contains(currThreadId)) {
                    cycleRoots.add(currThread);
                    continue block0;
                }
                currThread = (DownstreamServiceOuterClass.ThreadDump.Thread)remainingBlockedThreads.remove(currThreadId);
            }
        }
        if (cycleRoots.isEmpty()) {
            return ImmutableList.of();
        }
        ArrayList cycles = Lists.newArrayList();
        for (DownstreamServiceOuterClass.ThreadDump.Thread cycleRoot : cycleRoots) {
            ArrayList cycle = Lists.newArrayList((Object[])new DownstreamServiceOuterClass.ThreadDump.Thread[]{cycleRoot});
            DownstreamServiceOuterClass.ThreadDump.Thread cycleThread = (DownstreamServiceOuterClass.ThreadDump.Thread)Preconditions.checkNotNull((Object)blockedThreads.get(cycleRoot.getLockOwnerId().getValue()));
            while (cycleThread != cycleRoot) {
                cycle.add(cycleThread);
                cycleThread = (DownstreamServiceOuterClass.ThreadDump.Thread)Preconditions.checkNotNull((Object)blockedThreads.get(cycleThread.getLockOwnerId().getValue()));
            }
            Collections.sort(cycle, new ThreadOrderingByIdDesc());
            cycles.add(cycle);
        }
        Collections.sort(cycles, new DeadlockedCycleOrdering());
        return cycles;
    }

    private static void writeStackTraceElement(DownstreamServiceOuterClass.ThreadDump.StackTraceElement stackTraceElement, JsonGenerator jg) throws IOException {
        jg.writeString("at " + new StackTraceElement(stackTraceElement.getClassName(), stackTraceElement.getMethodName(), stackTraceElement.getFileName(), stackTraceElement.getLineNumber()).toString());
    }

    private static void writeMonitorInfo(String operation, DownstreamServiceOuterClass.ThreadDump.LockInfo monitorInfo, JsonGenerator jg) throws IOException {
        jg.writeString("- " + operation + " " + monitorInfo.getClassName() + "@" + Integer.toHexString(monitorInfo.getIdentityHashCode()));
    }

    private static Map<String, Object> getSortedAttributeMap(List<DownstreamServiceOuterClass.MBeanDump.MBeanAttribute> attributes) {
        TreeMap sortedAttributeMap = Maps.newTreeMap();
        for (DownstreamServiceOuterClass.MBeanDump.MBeanAttribute attribute : attributes) {
            sortedAttributeMap.put(attribute.getName(), JvmJsonService.getAttributeValue(attribute.getValue()));
        }
        return sortedAttributeMap;
    }

    private static @Nullable Object getAttributeValue(DownstreamServiceOuterClass.MBeanDump.MBeanValue value) {
        if (value.getNull()) {
            return null;
        }
        switch (value.getValCase()) {
            case STRING: {
                return value.getString();
            }
            case DOUBLE: {
                return value.getDouble();
            }
            case LONG: {
                return value.getLong();
            }
            case BOOLEAN: {
                return value.getBoolean();
            }
            case LIST: {
                ArrayList list = Lists.newArrayList();
                for (DownstreamServiceOuterClass.MBeanDump.MBeanValue val : value.getList().getValueList()) {
                    list.add(JvmJsonService.getAttributeValue(val));
                }
                return list;
            }
            case MAP: {
                HashMap map = Maps.newHashMap();
                for (DownstreamServiceOuterClass.MBeanDump.MBeanValueMapEntry val : value.getMap().getEntryList()) {
                    map.put(val.getKey(), JvmJsonService.getAttributeValue(val.getValue()));
                }
                return map;
            }
        }
        throw new IllegalStateException("Unexpected mbean value case: " + value.getValCase());
    }

    private static class DeadlockedCycleOrdering
    extends Ordering<List<DownstreamServiceOuterClass.ThreadDump.Thread>> {
        private DeadlockedCycleOrdering() {
        }

        public int compare(List<DownstreamServiceOuterClass.ThreadDump.Thread> left, List<DownstreamServiceOuterClass.ThreadDump.Thread> right) {
            return Longs.compare((long)right.get(0).getId(), (long)left.get(0).getId());
        }
    }

    private static class ThreadOrderingByStackTraceSizeDesc
    extends Ordering<DownstreamServiceOuterClass.ThreadDump.Thread> {
        private ThreadOrderingByStackTraceSizeDesc() {
        }

        public int compare(DownstreamServiceOuterClass.ThreadDump.Thread left, DownstreamServiceOuterClass.ThreadDump.Thread right) {
            return Longs.compare((long)right.getStackTraceElementCount(), (long)left.getStackTraceElementCount());
        }
    }

    private static class ThreadOrderingByIdDesc
    extends Ordering<DownstreamServiceOuterClass.ThreadDump.Thread> {
        private ThreadOrderingByIdDesc() {
        }

        public int compare(DownstreamServiceOuterClass.ThreadDump.Thread left, DownstreamServiceOuterClass.ThreadDump.Thread right) {
            return Longs.compare((long)right.getId(), (long)left.getId());
        }
    }

    private static class TransactionOrderingByTotalTimeDesc
    extends Ordering<DownstreamServiceOuterClass.ThreadDump.Transaction> {
        private TransactionOrderingByTotalTimeDesc() {
        }

        public int compare(DownstreamServiceOuterClass.ThreadDump.Transaction left, DownstreamServiceOuterClass.ThreadDump.Transaction right) {
            return Longs.compare((long)right.getDurationNanos(), (long)left.getDurationNanos());
        }
    }

    static class MBeanTreeLeafNode
    implements MBeanTreeNode {
        private final String nodeName;
        private final String objectName;
        private final boolean expanded;
        private final @Nullable Map<String, Object> attributeMap;

        private MBeanTreeLeafNode(String nodeName, String objectName, boolean expanded, @Nullable Map<String, Object> attributeMap) {
            this.nodeName = nodeName;
            this.objectName = objectName;
            this.expanded = expanded;
            this.attributeMap = attributeMap;
        }

        @Override
        @UsedByJsonSerialization
        public String getNodeName() {
            return this.nodeName;
        }

        @UsedByJsonSerialization
        public String getObjectName() {
            return this.objectName;
        }

        @UsedByJsonSerialization
        public boolean isExpanded() {
            return this.expanded;
        }

        @UsedByJsonSerialization
        public @Nullable Map<String, Object> getAttributeMap() {
            return this.attributeMap;
        }
    }

    static class MBeanTreeInnerNode
    implements MBeanTreeNode {
        private static final Ordering<MBeanTreeNode> ordering = new Ordering<MBeanTreeNode>(){

            public int compare(MBeanTreeNode left, MBeanTreeNode right) {
                return left.getNodeName().compareToIgnoreCase(right.getNodeName());
            }
        };
        private final String name;
        private final List<MBeanTreeNode> childNodes = Lists.newArrayList();
        private final Map<String, MBeanTreeInnerNode> innerNodes = Maps.newHashMap();

        private MBeanTreeInnerNode(String name) {
            this.name = name;
        }

        @Override
        @UsedByJsonSerialization
        public String getNodeName() {
            return this.name;
        }

        @UsedByJsonSerialization
        public List<MBeanTreeNode> getChildNodes() {
            return ordering.sortedCopy(this.childNodes);
        }

        private MBeanTreeInnerNode getOrCreateNode(String name) {
            MBeanTreeInnerNode innerNode = this.innerNodes.get(name);
            if (innerNode == null) {
                innerNode = new MBeanTreeInnerNode(name);
                this.innerNodes.put(name, innerNode);
                this.childNodes.add(innerNode);
            }
            return innerNode;
        }

        private void addLeafNode(MBeanTreeLeafNode leafNode) {
            this.childNodes.add(leafNode);
        }
    }

    private static interface MBeanTreeNode {
        public String getNodeName();
    }

    @Value.Immutable
    static interface MBeanAttributeMapRequest {
        public String objectName();
    }

    @Value.Immutable
    static interface MBeanTreeRequest {
        public List<String> expanded();
    }

    @Value.Immutable
    static interface HeapDumpRequest {
        public String directory();
    }
}

