/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.TracePointJsonService;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.primitives.Doubles;
import org.glowroot.agent.shaded.com.google.common.primitives.Longs;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.org.glowroot.common.live.StringComparator;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TracePointJsonService.TracePointRequest", generator="Immutables")
@Immutable
public final class ImmutableTracePointRequest
extends TracePointJsonService.TracePointRequest {
    private final String transactionType;
    private final @org.checkerframework.checker.nullness.qual.Nullable String transactionName;
    private final long from;
    private final long to;
    private final double durationMillisLow;
    private final @org.checkerframework.checker.nullness.qual.Nullable Double durationMillisHigh;
    private final @org.checkerframework.checker.nullness.qual.Nullable StringComparator headlineComparator;
    private final @org.checkerframework.checker.nullness.qual.Nullable String headline;
    private final @org.checkerframework.checker.nullness.qual.Nullable StringComparator errorMessageComparator;
    private final @org.checkerframework.checker.nullness.qual.Nullable String errorMessage;
    private final @org.checkerframework.checker.nullness.qual.Nullable StringComparator userComparator;
    private final @org.checkerframework.checker.nullness.qual.Nullable String user;
    private final @org.checkerframework.checker.nullness.qual.Nullable String attributeName;
    private final @org.checkerframework.checker.nullness.qual.Nullable StringComparator attributeValueComparator;
    private final @org.checkerframework.checker.nullness.qual.Nullable String attributeValue;
    private final int limit;

    private ImmutableTracePointRequest(String transactionType, @org.checkerframework.checker.nullness.qual.Nullable String transactionName, long from, long to, double durationMillisLow, @org.checkerframework.checker.nullness.qual.Nullable Double durationMillisHigh, @org.checkerframework.checker.nullness.qual.Nullable StringComparator headlineComparator, @org.checkerframework.checker.nullness.qual.Nullable String headline, @org.checkerframework.checker.nullness.qual.Nullable StringComparator errorMessageComparator, @org.checkerframework.checker.nullness.qual.Nullable String errorMessage, @org.checkerframework.checker.nullness.qual.Nullable StringComparator userComparator, @org.checkerframework.checker.nullness.qual.Nullable String user, @org.checkerframework.checker.nullness.qual.Nullable String attributeName, @org.checkerframework.checker.nullness.qual.Nullable StringComparator attributeValueComparator, @org.checkerframework.checker.nullness.qual.Nullable String attributeValue, int limit) {
        this.transactionType = transactionType;
        this.transactionName = transactionName;
        this.from = from;
        this.to = to;
        this.durationMillisLow = durationMillisLow;
        this.durationMillisHigh = durationMillisHigh;
        this.headlineComparator = headlineComparator;
        this.headline = headline;
        this.errorMessageComparator = errorMessageComparator;
        this.errorMessage = errorMessage;
        this.userComparator = userComparator;
        this.user = user;
        this.attributeName = attributeName;
        this.attributeValueComparator = attributeValueComparator;
        this.attributeValue = attributeValue;
        this.limit = limit;
    }

    @Override
    @JsonProperty(value="transactionType")
    public String transactionType() {
        return this.transactionType;
    }

    @Override
    @JsonProperty(value="transactionName")
    public @org.checkerframework.checker.nullness.qual.Nullable String transactionName() {
        return this.transactionName;
    }

    @Override
    @JsonProperty(value="from")
    public long from() {
        return this.from;
    }

    @Override
    @JsonProperty(value="to")
    public long to() {
        return this.to;
    }

    @Override
    @JsonProperty(value="durationMillisLow")
    public double durationMillisLow() {
        return this.durationMillisLow;
    }

    @Override
    @JsonProperty(value="durationMillisHigh")
    public @org.checkerframework.checker.nullness.qual.Nullable Double durationMillisHigh() {
        return this.durationMillisHigh;
    }

    @Override
    @JsonProperty(value="headlineComparator")
    public @org.checkerframework.checker.nullness.qual.Nullable StringComparator headlineComparator() {
        return this.headlineComparator;
    }

    @Override
    @JsonProperty(value="headline")
    public @org.checkerframework.checker.nullness.qual.Nullable String headline() {
        return this.headline;
    }

    @Override
    @JsonProperty(value="errorMessageComparator")
    public @org.checkerframework.checker.nullness.qual.Nullable StringComparator errorMessageComparator() {
        return this.errorMessageComparator;
    }

    @Override
    @JsonProperty(value="errorMessage")
    public @org.checkerframework.checker.nullness.qual.Nullable String errorMessage() {
        return this.errorMessage;
    }

    @Override
    @JsonProperty(value="userComparator")
    public @org.checkerframework.checker.nullness.qual.Nullable StringComparator userComparator() {
        return this.userComparator;
    }

    @Override
    @JsonProperty(value="user")
    public @org.checkerframework.checker.nullness.qual.Nullable String user() {
        return this.user;
    }

    @Override
    @JsonProperty(value="attributeName")
    public @org.checkerframework.checker.nullness.qual.Nullable String attributeName() {
        return this.attributeName;
    }

    @Override
    @JsonProperty(value="attributeValueComparator")
    public @org.checkerframework.checker.nullness.qual.Nullable StringComparator attributeValueComparator() {
        return this.attributeValueComparator;
    }

    @Override
    @JsonProperty(value="attributeValue")
    public @org.checkerframework.checker.nullness.qual.Nullable String attributeValue() {
        return this.attributeValue;
    }

    @Override
    @JsonProperty(value="limit")
    public int limit() {
        return this.limit;
    }

    public final ImmutableTracePointRequest withTransactionType(String value) {
        String newValue = Objects.requireNonNull(value, "transactionType");
        if (this.transactionType.equals(newValue)) {
            return this;
        }
        return new ImmutableTracePointRequest(newValue, this.transactionName, this.from, this.to, this.durationMillisLow, this.durationMillisHigh, this.headlineComparator, this.headline, this.errorMessageComparator, this.errorMessage, this.userComparator, this.user, this.attributeName, this.attributeValueComparator, this.attributeValue, this.limit);
    }

    public final ImmutableTracePointRequest withTransactionName(@org.checkerframework.checker.nullness.qual.Nullable String value) {
        if (Objects.equals(this.transactionName, value)) {
            return this;
        }
        return new ImmutableTracePointRequest(this.transactionType, value, this.from, this.to, this.durationMillisLow, this.durationMillisHigh, this.headlineComparator, this.headline, this.errorMessageComparator, this.errorMessage, this.userComparator, this.user, this.attributeName, this.attributeValueComparator, this.attributeValue, this.limit);
    }

    public final ImmutableTracePointRequest withFrom(long value) {
        if (this.from == value) {
            return this;
        }
        return new ImmutableTracePointRequest(this.transactionType, this.transactionName, value, this.to, this.durationMillisLow, this.durationMillisHigh, this.headlineComparator, this.headline, this.errorMessageComparator, this.errorMessage, this.userComparator, this.user, this.attributeName, this.attributeValueComparator, this.attributeValue, this.limit);
    }

    public final ImmutableTracePointRequest withTo(long value) {
        if (this.to == value) {
            return this;
        }
        return new ImmutableTracePointRequest(this.transactionType, this.transactionName, this.from, value, this.durationMillisLow, this.durationMillisHigh, this.headlineComparator, this.headline, this.errorMessageComparator, this.errorMessage, this.userComparator, this.user, this.attributeName, this.attributeValueComparator, this.attributeValue, this.limit);
    }

    public final ImmutableTracePointRequest withDurationMillisLow(double value) {
        if (Double.doubleToLongBits(this.durationMillisLow) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableTracePointRequest(this.transactionType, this.transactionName, this.from, this.to, value, this.durationMillisHigh, this.headlineComparator, this.headline, this.errorMessageComparator, this.errorMessage, this.userComparator, this.user, this.attributeName, this.attributeValueComparator, this.attributeValue, this.limit);
    }

    public final ImmutableTracePointRequest withDurationMillisHigh(@org.checkerframework.checker.nullness.qual.Nullable Double value) {
        if (Objects.equals(this.durationMillisHigh, value)) {
            return this;
        }
        return new ImmutableTracePointRequest(this.transactionType, this.transactionName, this.from, this.to, this.durationMillisLow, value, this.headlineComparator, this.headline, this.errorMessageComparator, this.errorMessage, this.userComparator, this.user, this.attributeName, this.attributeValueComparator, this.attributeValue, this.limit);
    }

    public final ImmutableTracePointRequest withHeadlineComparator(@org.checkerframework.checker.nullness.qual.Nullable StringComparator value) {
        if (this.headlineComparator == value) {
            return this;
        }
        return new ImmutableTracePointRequest(this.transactionType, this.transactionName, this.from, this.to, this.durationMillisLow, this.durationMillisHigh, value, this.headline, this.errorMessageComparator, this.errorMessage, this.userComparator, this.user, this.attributeName, this.attributeValueComparator, this.attributeValue, this.limit);
    }

    public final ImmutableTracePointRequest withHeadline(@org.checkerframework.checker.nullness.qual.Nullable String value) {
        if (Objects.equals(this.headline, value)) {
            return this;
        }
        return new ImmutableTracePointRequest(this.transactionType, this.transactionName, this.from, this.to, this.durationMillisLow, this.durationMillisHigh, this.headlineComparator, value, this.errorMessageComparator, this.errorMessage, this.userComparator, this.user, this.attributeName, this.attributeValueComparator, this.attributeValue, this.limit);
    }

    public final ImmutableTracePointRequest withErrorMessageComparator(@org.checkerframework.checker.nullness.qual.Nullable StringComparator value) {
        if (this.errorMessageComparator == value) {
            return this;
        }
        return new ImmutableTracePointRequest(this.transactionType, this.transactionName, this.from, this.to, this.durationMillisLow, this.durationMillisHigh, this.headlineComparator, this.headline, value, this.errorMessage, this.userComparator, this.user, this.attributeName, this.attributeValueComparator, this.attributeValue, this.limit);
    }

    public final ImmutableTracePointRequest withErrorMessage(@org.checkerframework.checker.nullness.qual.Nullable String value) {
        if (Objects.equals(this.errorMessage, value)) {
            return this;
        }
        return new ImmutableTracePointRequest(this.transactionType, this.transactionName, this.from, this.to, this.durationMillisLow, this.durationMillisHigh, this.headlineComparator, this.headline, this.errorMessageComparator, value, this.userComparator, this.user, this.attributeName, this.attributeValueComparator, this.attributeValue, this.limit);
    }

    public final ImmutableTracePointRequest withUserComparator(@org.checkerframework.checker.nullness.qual.Nullable StringComparator value) {
        if (this.userComparator == value) {
            return this;
        }
        return new ImmutableTracePointRequest(this.transactionType, this.transactionName, this.from, this.to, this.durationMillisLow, this.durationMillisHigh, this.headlineComparator, this.headline, this.errorMessageComparator, this.errorMessage, value, this.user, this.attributeName, this.attributeValueComparator, this.attributeValue, this.limit);
    }

    public final ImmutableTracePointRequest withUser(@org.checkerframework.checker.nullness.qual.Nullable String value) {
        if (Objects.equals(this.user, value)) {
            return this;
        }
        return new ImmutableTracePointRequest(this.transactionType, this.transactionName, this.from, this.to, this.durationMillisLow, this.durationMillisHigh, this.headlineComparator, this.headline, this.errorMessageComparator, this.errorMessage, this.userComparator, value, this.attributeName, this.attributeValueComparator, this.attributeValue, this.limit);
    }

    public final ImmutableTracePointRequest withAttributeName(@org.checkerframework.checker.nullness.qual.Nullable String value) {
        if (Objects.equals(this.attributeName, value)) {
            return this;
        }
        return new ImmutableTracePointRequest(this.transactionType, this.transactionName, this.from, this.to, this.durationMillisLow, this.durationMillisHigh, this.headlineComparator, this.headline, this.errorMessageComparator, this.errorMessage, this.userComparator, this.user, value, this.attributeValueComparator, this.attributeValue, this.limit);
    }

    public final ImmutableTracePointRequest withAttributeValueComparator(@org.checkerframework.checker.nullness.qual.Nullable StringComparator value) {
        if (this.attributeValueComparator == value) {
            return this;
        }
        return new ImmutableTracePointRequest(this.transactionType, this.transactionName, this.from, this.to, this.durationMillisLow, this.durationMillisHigh, this.headlineComparator, this.headline, this.errorMessageComparator, this.errorMessage, this.userComparator, this.user, this.attributeName, value, this.attributeValue, this.limit);
    }

    public final ImmutableTracePointRequest withAttributeValue(@org.checkerframework.checker.nullness.qual.Nullable String value) {
        if (Objects.equals(this.attributeValue, value)) {
            return this;
        }
        return new ImmutableTracePointRequest(this.transactionType, this.transactionName, this.from, this.to, this.durationMillisLow, this.durationMillisHigh, this.headlineComparator, this.headline, this.errorMessageComparator, this.errorMessage, this.userComparator, this.user, this.attributeName, this.attributeValueComparator, value, this.limit);
    }

    public final ImmutableTracePointRequest withLimit(int value) {
        if (this.limit == value) {
            return this;
        }
        return new ImmutableTracePointRequest(this.transactionType, this.transactionName, this.from, this.to, this.durationMillisLow, this.durationMillisHigh, this.headlineComparator, this.headline, this.errorMessageComparator, this.errorMessage, this.userComparator, this.user, this.attributeName, this.attributeValueComparator, this.attributeValue, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTracePointRequest && this.equalTo(0, (ImmutableTracePointRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableTracePointRequest another) {
        return this.transactionType.equals(another.transactionType) && Objects.equals(this.transactionName, another.transactionName) && this.from == another.from && this.to == another.to && Double.doubleToLongBits(this.durationMillisLow) == Double.doubleToLongBits(another.durationMillisLow) && Objects.equals(this.durationMillisHigh, another.durationMillisHigh) && Objects.equals(this.headlineComparator, another.headlineComparator) && Objects.equals(this.headline, another.headline) && Objects.equals(this.errorMessageComparator, another.errorMessageComparator) && Objects.equals(this.errorMessage, another.errorMessage) && Objects.equals(this.userComparator, another.userComparator) && Objects.equals(this.user, another.user) && Objects.equals(this.attributeName, another.attributeName) && Objects.equals(this.attributeValueComparator, another.attributeValueComparator) && Objects.equals(this.attributeValue, another.attributeValue) && this.limit == another.limit;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.transactionType.hashCode();
        h += (h << 5) + Objects.hashCode(this.transactionName);
        h += (h << 5) + Longs.hashCode((long)this.from);
        h += (h << 5) + Longs.hashCode((long)this.to);
        h += (h << 5) + Doubles.hashCode((double)this.durationMillisLow);
        h += (h << 5) + Objects.hashCode(this.durationMillisHigh);
        h += (h << 5) + Objects.hashCode(this.headlineComparator);
        h += (h << 5) + Objects.hashCode(this.headline);
        h += (h << 5) + Objects.hashCode(this.errorMessageComparator);
        h += (h << 5) + Objects.hashCode(this.errorMessage);
        h += (h << 5) + Objects.hashCode(this.userComparator);
        h += (h << 5) + Objects.hashCode(this.user);
        h += (h << 5) + Objects.hashCode(this.attributeName);
        h += (h << 5) + Objects.hashCode(this.attributeValueComparator);
        h += (h << 5) + Objects.hashCode(this.attributeValue);
        h += (h << 5) + this.limit;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TracePointRequest").omitNullValues().add("transactionType", (Object)this.transactionType).add("transactionName", (Object)this.transactionName).add("from", this.from).add("to", this.to).add("durationMillisLow", this.durationMillisLow).add("durationMillisHigh", (Object)this.durationMillisHigh).add("headlineComparator", (Object)this.headlineComparator).add("headline", (Object)this.headline).add("errorMessageComparator", (Object)this.errorMessageComparator).add("errorMessage", (Object)this.errorMessage).add("userComparator", (Object)this.userComparator).add("user", (Object)this.user).add("attributeName", (Object)this.attributeName).add("attributeValueComparator", (Object)this.attributeValueComparator).add("attributeValue", (Object)this.attributeValue).add("limit", this.limit).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTracePointRequest fromJson(Json json) {
        Builder builder = ImmutableTracePointRequest.builder();
        if (json.transactionType != null) {
            builder.transactionType(json.transactionType);
        }
        if (json.transactionName != null) {
            builder.transactionName(json.transactionName);
        }
        if (json.fromIsSet) {
            builder.from(json.from);
        }
        if (json.toIsSet) {
            builder.to(json.to);
        }
        if (json.durationMillisLowIsSet) {
            builder.durationMillisLow(json.durationMillisLow);
        }
        if (json.durationMillisHigh != null) {
            builder.durationMillisHigh(json.durationMillisHigh);
        }
        if (json.headlineComparator != null) {
            builder.headlineComparator(json.headlineComparator);
        }
        if (json.headline != null) {
            builder.headline(json.headline);
        }
        if (json.errorMessageComparator != null) {
            builder.errorMessageComparator(json.errorMessageComparator);
        }
        if (json.errorMessage != null) {
            builder.errorMessage(json.errorMessage);
        }
        if (json.userComparator != null) {
            builder.userComparator(json.userComparator);
        }
        if (json.user != null) {
            builder.user(json.user);
        }
        if (json.attributeName != null) {
            builder.attributeName(json.attributeName);
        }
        if (json.attributeValueComparator != null) {
            builder.attributeValueComparator(json.attributeValueComparator);
        }
        if (json.attributeValue != null) {
            builder.attributeValue(json.attributeValue);
        }
        if (json.limitIsSet) {
            builder.limit(json.limit);
        }
        return builder.build();
    }

    public static ImmutableTracePointRequest copyOf(TracePointJsonService.TracePointRequest instance) {
        if (instance instanceof ImmutableTracePointRequest) {
            return (ImmutableTracePointRequest)instance;
        }
        return ImmutableTracePointRequest.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TracePointJsonService.TracePointRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TRANSACTION_TYPE = 1L;
        private static final long INIT_BIT_FROM = 2L;
        private static final long INIT_BIT_TO = 4L;
        private static final long INIT_BIT_DURATION_MILLIS_LOW = 8L;
        private static final long INIT_BIT_LIMIT = 16L;
        private long initBits = 31L;
        @Nullable
        private String transactionType;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable String transactionName;
        private long from;
        private long to;
        private double durationMillisLow;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable Double durationMillisHigh;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable StringComparator headlineComparator;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable String headline;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable StringComparator errorMessageComparator;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable String errorMessage;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable StringComparator userComparator;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable String user;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable String attributeName;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable StringComparator attributeValueComparator;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable String attributeValue;
        private int limit;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(TracePointJsonService.TracePointRequest instance) {
            String attributeValueValue;
            StringComparator attributeValueComparatorValue;
            String attributeNameValue;
            String userValue;
            StringComparator userComparatorValue;
            String errorMessageValue;
            StringComparator errorMessageComparatorValue;
            String headlineValue;
            StringComparator headlineComparatorValue;
            Objects.requireNonNull(instance, "instance");
            this.transactionType(instance.transactionType());
            @org.checkerframework.checker.nullness.qual.Nullable String transactionNameValue = instance.transactionName();
            if (transactionNameValue != null) {
                this.transactionName(transactionNameValue);
            }
            this.from(instance.from());
            this.to(instance.to());
            this.durationMillisLow(instance.durationMillisLow());
            @org.checkerframework.checker.nullness.qual.Nullable Double durationMillisHighValue = instance.durationMillisHigh();
            if (durationMillisHighValue != null) {
                this.durationMillisHigh(durationMillisHighValue);
            }
            if ((headlineComparatorValue = instance.headlineComparator()) != null) {
                this.headlineComparator(headlineComparatorValue);
            }
            if ((headlineValue = instance.headline()) != null) {
                this.headline(headlineValue);
            }
            if ((errorMessageComparatorValue = instance.errorMessageComparator()) != null) {
                this.errorMessageComparator(errorMessageComparatorValue);
            }
            if ((errorMessageValue = instance.errorMessage()) != null) {
                this.errorMessage(errorMessageValue);
            }
            if ((userComparatorValue = instance.userComparator()) != null) {
                this.userComparator(userComparatorValue);
            }
            if ((userValue = instance.user()) != null) {
                this.user(userValue);
            }
            if ((attributeNameValue = instance.attributeName()) != null) {
                this.attributeName(attributeNameValue);
            }
            if ((attributeValueComparatorValue = instance.attributeValueComparator()) != null) {
                this.attributeValueComparator(attributeValueComparatorValue);
            }
            if ((attributeValueValue = instance.attributeValue()) != null) {
                this.attributeValue(attributeValueValue);
            }
            this.limit(instance.limit());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder transactionType(String transactionType) {
            this.transactionType = Objects.requireNonNull(transactionType, "transactionType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder transactionName(@org.checkerframework.checker.nullness.qual.Nullable String transactionName) {
            this.transactionName = transactionName;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(long from) {
            this.from = from;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder to(long to) {
            this.to = to;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder durationMillisLow(double durationMillisLow) {
            this.durationMillisLow = durationMillisLow;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder durationMillisHigh(@org.checkerframework.checker.nullness.qual.Nullable Double durationMillisHigh) {
            this.durationMillisHigh = durationMillisHigh;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder headlineComparator(@org.checkerframework.checker.nullness.qual.Nullable StringComparator headlineComparator) {
            this.headlineComparator = headlineComparator;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder headline(@org.checkerframework.checker.nullness.qual.Nullable String headline) {
            this.headline = headline;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder errorMessageComparator(@org.checkerframework.checker.nullness.qual.Nullable StringComparator errorMessageComparator) {
            this.errorMessageComparator = errorMessageComparator;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder errorMessage(@org.checkerframework.checker.nullness.qual.Nullable String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder userComparator(@org.checkerframework.checker.nullness.qual.Nullable StringComparator userComparator) {
            this.userComparator = userComparator;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder user(@org.checkerframework.checker.nullness.qual.Nullable String user) {
            this.user = user;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder attributeName(@org.checkerframework.checker.nullness.qual.Nullable String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder attributeValueComparator(@org.checkerframework.checker.nullness.qual.Nullable StringComparator attributeValueComparator) {
            this.attributeValueComparator = attributeValueComparator;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder attributeValue(@org.checkerframework.checker.nullness.qual.Nullable String attributeValue) {
            this.attributeValue = attributeValue;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder limit(int limit) {
            this.limit = limit;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableTracePointRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTracePointRequest(this.transactionType, this.transactionName, this.from, this.to, this.durationMillisLow, this.durationMillisHigh, this.headlineComparator, this.headline, this.errorMessageComparator, this.errorMessage, this.userComparator, this.user, this.attributeName, this.attributeValueComparator, this.attributeValue, this.limit);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("transactionType");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("from");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("to");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("durationMillisLow");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("limit");
            }
            return "Cannot build TracePointRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="TracePointJsonService.TracePointRequest", generator="Immutables")
    static final class Json
    extends TracePointJsonService.TracePointRequest {
        @Nullable
        String transactionType;
        @Nullable
        @org.checkerframework.checker.nullness.qual.Nullable String transactionName;
        long from;
        boolean fromIsSet;
        long to;
        boolean toIsSet;
        double durationMillisLow;
        boolean durationMillisLowIsSet;
        @Nullable
        @org.checkerframework.checker.nullness.qual.Nullable Double durationMillisHigh;
        @Nullable
        @org.checkerframework.checker.nullness.qual.Nullable StringComparator headlineComparator;
        @Nullable
        @org.checkerframework.checker.nullness.qual.Nullable String headline;
        @Nullable
        @org.checkerframework.checker.nullness.qual.Nullable StringComparator errorMessageComparator;
        @Nullable
        @org.checkerframework.checker.nullness.qual.Nullable String errorMessage;
        @Nullable
        @org.checkerframework.checker.nullness.qual.Nullable StringComparator userComparator;
        @Nullable
        @org.checkerframework.checker.nullness.qual.Nullable String user;
        @Nullable
        @org.checkerframework.checker.nullness.qual.Nullable String attributeName;
        @Nullable
        @org.checkerframework.checker.nullness.qual.Nullable StringComparator attributeValueComparator;
        @Nullable
        @org.checkerframework.checker.nullness.qual.Nullable String attributeValue;
        int limit;
        boolean limitIsSet;

        Json() {
        }

        @JsonProperty(value="transactionType")
        public void setTransactionType(String transactionType) {
            this.transactionType = transactionType;
        }

        @JsonProperty(value="transactionName")
        public void setTransactionName(@org.checkerframework.checker.nullness.qual.Nullable String transactionName) {
            this.transactionName = transactionName;
        }

        @JsonProperty(value="from")
        public void setFrom(long from) {
            this.from = from;
            this.fromIsSet = true;
        }

        @JsonProperty(value="to")
        public void setTo(long to) {
            this.to = to;
            this.toIsSet = true;
        }

        @JsonProperty(value="durationMillisLow")
        public void setDurationMillisLow(double durationMillisLow) {
            this.durationMillisLow = durationMillisLow;
            this.durationMillisLowIsSet = true;
        }

        @JsonProperty(value="durationMillisHigh")
        public void setDurationMillisHigh(@org.checkerframework.checker.nullness.qual.Nullable Double durationMillisHigh) {
            this.durationMillisHigh = durationMillisHigh;
        }

        @JsonProperty(value="headlineComparator")
        public void setHeadlineComparator(@org.checkerframework.checker.nullness.qual.Nullable StringComparator headlineComparator) {
            this.headlineComparator = headlineComparator;
        }

        @JsonProperty(value="headline")
        public void setHeadline(@org.checkerframework.checker.nullness.qual.Nullable String headline) {
            this.headline = headline;
        }

        @JsonProperty(value="errorMessageComparator")
        public void setErrorMessageComparator(@org.checkerframework.checker.nullness.qual.Nullable StringComparator errorMessageComparator) {
            this.errorMessageComparator = errorMessageComparator;
        }

        @JsonProperty(value="errorMessage")
        public void setErrorMessage(@org.checkerframework.checker.nullness.qual.Nullable String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @JsonProperty(value="userComparator")
        public void setUserComparator(@org.checkerframework.checker.nullness.qual.Nullable StringComparator userComparator) {
            this.userComparator = userComparator;
        }

        @JsonProperty(value="user")
        public void setUser(@org.checkerframework.checker.nullness.qual.Nullable String user) {
            this.user = user;
        }

        @JsonProperty(value="attributeName")
        public void setAttributeName(@org.checkerframework.checker.nullness.qual.Nullable String attributeName) {
            this.attributeName = attributeName;
        }

        @JsonProperty(value="attributeValueComparator")
        public void setAttributeValueComparator(@org.checkerframework.checker.nullness.qual.Nullable StringComparator attributeValueComparator) {
            this.attributeValueComparator = attributeValueComparator;
        }

        @JsonProperty(value="attributeValue")
        public void setAttributeValue(@org.checkerframework.checker.nullness.qual.Nullable String attributeValue) {
            this.attributeValue = attributeValue;
        }

        @JsonProperty(value="limit")
        public void setLimit(int limit) {
            this.limit = limit;
            this.limitIsSet = true;
        }

        @Override
        public String transactionType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public @org.checkerframework.checker.nullness.qual.Nullable String transactionName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long from() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long to() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double durationMillisLow() {
            throw new UnsupportedOperationException();
        }

        @Override
        public @org.checkerframework.checker.nullness.qual.Nullable Double durationMillisHigh() {
            throw new UnsupportedOperationException();
        }

        @Override
        public @org.checkerframework.checker.nullness.qual.Nullable StringComparator headlineComparator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public @org.checkerframework.checker.nullness.qual.Nullable String headline() {
            throw new UnsupportedOperationException();
        }

        @Override
        public @org.checkerframework.checker.nullness.qual.Nullable StringComparator errorMessageComparator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public @org.checkerframework.checker.nullness.qual.Nullable String errorMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public @org.checkerframework.checker.nullness.qual.Nullable StringComparator userComparator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public @org.checkerframework.checker.nullness.qual.Nullable String user() {
            throw new UnsupportedOperationException();
        }

        @Override
        public @org.checkerframework.checker.nullness.qual.Nullable String attributeName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public @org.checkerframework.checker.nullness.qual.Nullable StringComparator attributeValueComparator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public @org.checkerframework.checker.nullness.qual.Nullable String attributeValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int limit() {
            throw new UnsupportedOperationException();
        }
    }
}

