/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.HttpSessionManager;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableSet;
import org.glowroot.agent.shaded.com.google.common.primitives.Booleans;
import org.glowroot.agent.shaded.com.google.common.primitives.Longs;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="HttpSessionManager.Session", generator="Immutables")
@Immutable
final class ImmutableSession
extends HttpSessionManager.Session
implements Serializable {
    private final String caseAmbiguousUsername;
    private final boolean ldap;
    private final ImmutableSet<String> roles;
    private final long lastRequest;

    private ImmutableSession(String caseAmbiguousUsername, boolean ldap, ImmutableSet<String> roles, long lastRequest) {
        this.caseAmbiguousUsername = caseAmbiguousUsername;
        this.ldap = ldap;
        this.roles = roles;
        this.lastRequest = lastRequest;
    }

    @Override
    @JsonProperty(value="caseAmbiguousUsername")
    String caseAmbiguousUsername() {
        return this.caseAmbiguousUsername;
    }

    @Override
    @JsonProperty(value="ldap")
    boolean ldap() {
        return this.ldap;
    }

    @JsonProperty(value="roles")
    ImmutableSet<String> roles() {
        return this.roles;
    }

    @Override
    @JsonProperty(value="lastRequest")
    long lastRequest() {
        return this.lastRequest;
    }

    public final ImmutableSession withCaseAmbiguousUsername(String value) {
        String newValue = Objects.requireNonNull(value, "caseAmbiguousUsername");
        if (this.caseAmbiguousUsername.equals(newValue)) {
            return this;
        }
        return new ImmutableSession(newValue, this.ldap, this.roles, this.lastRequest);
    }

    public final ImmutableSession withLdap(boolean value) {
        if (this.ldap == value) {
            return this;
        }
        return new ImmutableSession(this.caseAmbiguousUsername, value, this.roles, this.lastRequest);
    }

    public final ImmutableSession withRoles(String ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new ImmutableSession(this.caseAmbiguousUsername, this.ldap, (ImmutableSet<String>)newValue, this.lastRequest);
    }

    public final ImmutableSession withRoles(Iterable<String> elements) {
        if (this.roles == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ImmutableSession(this.caseAmbiguousUsername, this.ldap, (ImmutableSet<String>)newValue, this.lastRequest);
    }

    public final ImmutableSession withLastRequest(long value) {
        if (this.lastRequest == value) {
            return this;
        }
        return new ImmutableSession(this.caseAmbiguousUsername, this.ldap, this.roles, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSession && this.equalTo(0, (ImmutableSession)another);
    }

    private boolean equalTo(int synthetic, ImmutableSession another) {
        return this.caseAmbiguousUsername.equals(another.caseAmbiguousUsername) && this.ldap == another.ldap && this.roles.equals(another.roles) && this.lastRequest == another.lastRequest;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.caseAmbiguousUsername.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.ldap);
        h += (h << 5) + this.roles.hashCode();
        h += (h << 5) + Longs.hashCode((long)this.lastRequest);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Session").omitNullValues().add("caseAmbiguousUsername", (Object)this.caseAmbiguousUsername).add("ldap", this.ldap).add("roles", this.roles).add("lastRequest", this.lastRequest).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableSession fromJson(Json json) {
        Builder builder = ImmutableSession.builder();
        if (json.caseAmbiguousUsername != null) {
            builder.caseAmbiguousUsername(json.caseAmbiguousUsername);
        }
        if (json.ldapIsSet) {
            builder.ldap(json.ldap);
        }
        if (json.roles != null) {
            builder.addAllRoles(json.roles);
        }
        if (json.lastRequestIsSet) {
            builder.lastRequest(json.lastRequest);
        }
        return builder.build();
    }

    public static ImmutableSession copyOf(HttpSessionManager.Session instance) {
        if (instance instanceof ImmutableSession) {
            return (ImmutableSession)instance;
        }
        return ImmutableSession.builder().copyFrom(instance).build();
    }

    private Object writeReplace() {
        return new SerialForm(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="HttpSessionManager.Session", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CASE_AMBIGUOUS_USERNAME = 1L;
        private static final long INIT_BIT_LDAP = 2L;
        private static final long INIT_BIT_LAST_REQUEST = 4L;
        private long initBits = 7L;
        @Nullable
        private String caseAmbiguousUsername;
        private boolean ldap;
        private ImmutableSet.Builder<String> roles = ImmutableSet.builder();
        private long lastRequest;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(HttpSessionManager.Session instance) {
            Objects.requireNonNull(instance, "instance");
            this.caseAmbiguousUsername(instance.caseAmbiguousUsername());
            this.ldap(instance.ldap());
            this.addAllRoles(instance.roles());
            this.lastRequest(instance.lastRequest());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder caseAmbiguousUsername(String caseAmbiguousUsername) {
            this.caseAmbiguousUsername = Objects.requireNonNull(caseAmbiguousUsername, "caseAmbiguousUsername");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ldap(boolean ldap) {
            this.ldap = ldap;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRoles(String element) {
            this.roles.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRoles(String ... elements) {
            this.roles.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder roles(Iterable<String> elements) {
            this.roles = ImmutableSet.builder();
            return this.addAllRoles(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllRoles(Iterable<String> elements) {
            this.roles.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder lastRequest(long lastRequest) {
            this.lastRequest = lastRequest;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableSession build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSession(this.caseAmbiguousUsername, this.ldap, this.roles.build(), this.lastRequest);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("caseAmbiguousUsername");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("ldap");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("lastRequest");
            }
            return "Cannot build Session, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="HttpSessionManager.Session", generator="Immutables")
    private static class SerialForm
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final String[] names;
        private final Object[] values;

        SerialForm(ImmutableSession instance) {
            ArrayList<String> names = new ArrayList<String>(4);
            ArrayList<Object> values = new ArrayList<Object>(4);
            names.add("caseAmbiguousUsername");
            values.add(instance.caseAmbiguousUsername());
            names.add("ldap");
            values.add(instance.ldap());
            if (!instance.roles().isEmpty()) {
                names.add("roles");
                values.add(instance.roles().toArray());
            }
            names.add("lastRequest");
            values.add(instance.lastRequest());
            this.names = names.toArray(new String[names.size()]);
            this.values = values.toArray();
        }

        Object readResolve() {
            Builder builder = ImmutableSession.builder();
            for (int i = 0; i < this.names.length; ++i) {
                String name = this.names[i];
                if ("caseAmbiguousUsername".equals(name)) {
                    builder.caseAmbiguousUsername((String)SerialForm.toSingle("caseAmbiguousUsername", this.values[i]));
                    continue;
                }
                if ("ldap".equals(name)) {
                    builder.ldap((Boolean)SerialForm.toSingle("ldap", this.values[i]));
                    continue;
                }
                if ("roles".equals(name)) {
                    Object[] items;
                    for (Object e : items = SerialForm.toArray(this.values[i])) {
                        builder.addRoles((String)e);
                    }
                    continue;
                }
                if (!"lastRequest".equals(name)) continue;
                builder.lastRequest((Long)SerialForm.toSingle("lastRequest", this.values[i]));
            }
            return builder.build();
        }

        private static Object toSingle(String attribute, Object value) {
            if (value instanceof Object[]) {
                Object[] elements = (Object[])value;
                if (elements.length == 1) {
                    return elements[0];
                }
                throw new IllegalStateException("Cannot extract scalar value for attribute '" + attribute + "' from array of length " + elements.length);
            }
            return value;
        }

        private static Object[] toArray(@Nullable Object value) {
            if (value == null) {
                return new Object[0];
            }
            if (value instanceof Object[]) {
                return (Object[])value;
            }
            return new Object[]{value};
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="HttpSessionManager.Session", generator="Immutables")
    static final class Json
    extends HttpSessionManager.Session
    implements Serializable {
        @Nullable
        String caseAmbiguousUsername;
        boolean ldap;
        boolean ldapIsSet;
        @Nullable
        Set<String> roles = ImmutableSet.of();
        long lastRequest;
        boolean lastRequestIsSet;

        Json() {
        }

        @JsonProperty(value="caseAmbiguousUsername")
        public void setCaseAmbiguousUsername(String caseAmbiguousUsername) {
            this.caseAmbiguousUsername = caseAmbiguousUsername;
        }

        @JsonProperty(value="ldap")
        public void setLdap(boolean ldap) {
            this.ldap = ldap;
            this.ldapIsSet = true;
        }

        @JsonProperty(value="roles")
        public void setRoles(Set<String> roles) {
            this.roles = roles;
        }

        @JsonProperty(value="lastRequest")
        public void setLastRequest(long lastRequest) {
            this.lastRequest = lastRequest;
            this.lastRequestIsSet = true;
        }

        @Override
        String caseAmbiguousUsername() {
            throw new UnsupportedOperationException();
        }

        @Override
        boolean ldap() {
            throw new UnsupportedOperationException();
        }

        @Override
        Set<String> roles() {
            throw new UnsupportedOperationException();
        }

        @Override
        long lastRequest() {
            throw new UnsupportedOperationException();
        }
    }
}

