/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ConfigJsonService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutablePluginPropertyDto;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ConfigJsonService.PluginConfigDto", generator="Immutables")
@Immutable
final class ImmutablePluginConfigDto
extends ConfigJsonService.PluginConfigDto {
    private final String name;
    private final ImmutableList<ImmutablePluginPropertyDto> properties;
    private final String version;

    private ImmutablePluginConfigDto(String name, ImmutableList<ImmutablePluginPropertyDto> properties, String version) {
        this.name = name;
        this.properties = properties;
        this.version = version;
    }

    @Override
    @JsonProperty(value="name")
    String name() {
        return this.name;
    }

    @JsonProperty(value="properties")
    ImmutableList<ImmutablePluginPropertyDto> properties() {
        return this.properties;
    }

    @Override
    @JsonProperty(value="version")
    String version() {
        return this.version;
    }

    public final ImmutablePluginConfigDto withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutablePluginConfigDto(newValue, this.properties, this.version);
    }

    public final ImmutablePluginConfigDto withProperties(ImmutablePluginPropertyDto ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutablePluginConfigDto(this.name, (ImmutableList<ImmutablePluginPropertyDto>)newValue, this.version);
    }

    public final ImmutablePluginConfigDto withProperties(Iterable<? extends ImmutablePluginPropertyDto> elements) {
        if (this.properties == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutablePluginConfigDto(this.name, (ImmutableList<ImmutablePluginPropertyDto>)newValue, this.version);
    }

    public final ImmutablePluginConfigDto withVersion(String value) {
        String newValue = Objects.requireNonNull(value, "version");
        if (this.version.equals(newValue)) {
            return this;
        }
        return new ImmutablePluginConfigDto(this.name, this.properties, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePluginConfigDto && this.equalTo(0, (ImmutablePluginConfigDto)another);
    }

    private boolean equalTo(int synthetic, ImmutablePluginConfigDto another) {
        return this.name.equals(another.name) && this.properties.equals(another.properties) && this.version.equals(another.version);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.properties.hashCode();
        h += (h << 5) + this.version.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"PluginConfigDto").omitNullValues().add("name", (Object)this.name).add("properties", this.properties).add("version", (Object)this.version).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePluginConfigDto fromJson(Json json) {
        Builder builder = ImmutablePluginConfigDto.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.properties != null) {
            builder.addAllProperties(json.properties);
        }
        if (json.version != null) {
            builder.version(json.version);
        }
        return builder.build();
    }

    public static ImmutablePluginConfigDto copyOf(ConfigJsonService.PluginConfigDto instance) {
        if (instance instanceof ImmutablePluginConfigDto) {
            return (ImmutablePluginConfigDto)instance;
        }
        return ImmutablePluginConfigDto.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ConfigJsonService.PluginConfigDto", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_VERSION = 2L;
        private long initBits = 3L;
        @Nullable
        private String name;
        private ImmutableList.Builder<ImmutablePluginPropertyDto> properties = ImmutableList.builder();
        @Nullable
        private String version;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(ConfigJsonService.PluginConfigDto instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            this.addAllProperties(instance.properties());
            this.version(instance.version());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addProperties(ImmutablePluginPropertyDto element) {
            this.properties.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addProperties(ImmutablePluginPropertyDto ... elements) {
            this.properties.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder properties(Iterable<? extends ImmutablePluginPropertyDto> elements) {
            this.properties = ImmutableList.builder();
            return this.addAllProperties(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllProperties(Iterable<? extends ImmutablePluginPropertyDto> elements) {
            this.properties.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder version(String version) {
            this.version = Objects.requireNonNull(version, "version");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutablePluginConfigDto build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePluginConfigDto(this.name, this.properties.build(), this.version);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("version");
            }
            return "Cannot build PluginConfigDto, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ConfigJsonService.PluginConfigDto", generator="Immutables")
    static final class Json
    extends ConfigJsonService.PluginConfigDto {
        @Nullable
        String name;
        @Nullable
        List<ImmutablePluginPropertyDto> properties = ImmutableList.of();
        @Nullable
        String version;

        Json() {
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="properties")
        public void setProperties(List<ImmutablePluginPropertyDto> properties) {
            this.properties = properties;
        }

        @JsonProperty(value="version")
        public void setVersion(String version) {
            this.version = version;
        }

        @Override
        String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        List<ImmutablePluginPropertyDto> properties() {
            throw new UnsupportedOperationException();
        }

        @Override
        String version() {
            throw new UnsupportedOperationException();
        }
    }
}

