/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.InstrumentationConfigJsonService;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="InstrumentationConfigJsonService.MethodSignatureDto", generator="Immutables")
@Immutable
final class ImmutableMethodSignatureDto
extends InstrumentationConfigJsonService.MethodSignatureDto {
    private final String name;
    private final ImmutableList<String> parameterTypes;
    private final String returnType;
    private final ImmutableList<String> modifiers;

    private ImmutableMethodSignatureDto(String name, ImmutableList<String> parameterTypes, String returnType, ImmutableList<String> modifiers) {
        this.name = name;
        this.parameterTypes = parameterTypes;
        this.returnType = returnType;
        this.modifiers = modifiers;
    }

    @Override
    @JsonProperty(value="name")
    String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="parameterTypes")
    ImmutableList<String> parameterTypes() {
        return this.parameterTypes;
    }

    @Override
    @JsonProperty(value="returnType")
    String returnType() {
        return this.returnType;
    }

    @Override
    @JsonProperty(value="modifiers")
    ImmutableList<String> modifiers() {
        return this.modifiers;
    }

    public final ImmutableMethodSignatureDto withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableMethodSignatureDto(newValue, this.parameterTypes, this.returnType, this.modifiers);
    }

    public final ImmutableMethodSignatureDto withParameterTypes(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableMethodSignatureDto(this.name, (ImmutableList<String>)newValue, this.returnType, this.modifiers);
    }

    public final ImmutableMethodSignatureDto withParameterTypes(Iterable<String> elements) {
        if (this.parameterTypes == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableMethodSignatureDto(this.name, (ImmutableList<String>)newValue, this.returnType, this.modifiers);
    }

    public final ImmutableMethodSignatureDto withReturnType(String value) {
        String newValue = Objects.requireNonNull(value, "returnType");
        if (this.returnType.equals(newValue)) {
            return this;
        }
        return new ImmutableMethodSignatureDto(this.name, this.parameterTypes, newValue, this.modifiers);
    }

    public final ImmutableMethodSignatureDto withModifiers(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableMethodSignatureDto(this.name, this.parameterTypes, this.returnType, (ImmutableList<String>)newValue);
    }

    public final ImmutableMethodSignatureDto withModifiers(Iterable<String> elements) {
        if (this.modifiers == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableMethodSignatureDto(this.name, this.parameterTypes, this.returnType, (ImmutableList<String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMethodSignatureDto && this.equalTo(0, (ImmutableMethodSignatureDto)another);
    }

    private boolean equalTo(int synthetic, ImmutableMethodSignatureDto another) {
        return this.name.equals(another.name) && this.parameterTypes.equals(another.parameterTypes) && this.returnType.equals(another.returnType) && this.modifiers.equals(another.modifiers);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.parameterTypes.hashCode();
        h += (h << 5) + this.returnType.hashCode();
        h += (h << 5) + this.modifiers.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MethodSignatureDto").omitNullValues().add("name", (Object)this.name).add("parameterTypes", this.parameterTypes).add("returnType", (Object)this.returnType).add("modifiers", this.modifiers).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMethodSignatureDto fromJson(Json json) {
        Builder builder = ImmutableMethodSignatureDto.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.parameterTypes != null) {
            builder.addAllParameterTypes((Iterable<String>)json.parameterTypes);
        }
        if (json.returnType != null) {
            builder.returnType(json.returnType);
        }
        if (json.modifiers != null) {
            builder.addAllModifiers((Iterable<String>)json.modifiers);
        }
        return builder.build();
    }

    public static ImmutableMethodSignatureDto copyOf(InstrumentationConfigJsonService.MethodSignatureDto instance) {
        if (instance instanceof ImmutableMethodSignatureDto) {
            return (ImmutableMethodSignatureDto)instance;
        }
        return ImmutableMethodSignatureDto.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="InstrumentationConfigJsonService.MethodSignatureDto", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_RETURN_TYPE = 2L;
        private long initBits = 3L;
        @Nullable
        private String name;
        private ImmutableList.Builder<String> parameterTypes = ImmutableList.builder();
        @Nullable
        private String returnType;
        private ImmutableList.Builder<String> modifiers = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(InstrumentationConfigJsonService.MethodSignatureDto instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            this.addAllParameterTypes((Iterable<String>)instance.parameterTypes());
            this.returnType(instance.returnType());
            this.addAllModifiers((Iterable<String>)instance.modifiers());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addParameterTypes(String element) {
            this.parameterTypes.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addParameterTypes(String ... elements) {
            this.parameterTypes.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder parameterTypes(Iterable<String> elements) {
            this.parameterTypes = ImmutableList.builder();
            return this.addAllParameterTypes(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllParameterTypes(Iterable<String> elements) {
            this.parameterTypes.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder returnType(String returnType) {
            this.returnType = Objects.requireNonNull(returnType, "returnType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addModifiers(String element) {
            this.modifiers.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addModifiers(String ... elements) {
            this.modifiers.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder modifiers(Iterable<String> elements) {
            this.modifiers = ImmutableList.builder();
            return this.addAllModifiers(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllModifiers(Iterable<String> elements) {
            this.modifiers.addAll(elements);
            return this;
        }

        public ImmutableMethodSignatureDto build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMethodSignatureDto(this.name, this.parameterTypes.build(), this.returnType, this.modifiers.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("returnType");
            }
            return "Cannot build MethodSignatureDto, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="InstrumentationConfigJsonService.MethodSignatureDto", generator="Immutables")
    static final class Json
    extends InstrumentationConfigJsonService.MethodSignatureDto {
        @Nullable
        String name;
        @Nullable
        ImmutableList<String> parameterTypes = ImmutableList.of();
        @Nullable
        String returnType;
        @Nullable
        ImmutableList<String> modifiers = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="parameterTypes")
        public void setParameterTypes(ImmutableList<String> parameterTypes) {
            this.parameterTypes = parameterTypes;
        }

        @JsonProperty(value="returnType")
        public void setReturnType(String returnType) {
            this.returnType = returnType;
        }

        @JsonProperty(value="modifiers")
        public void setModifiers(ImmutableList<String> modifiers) {
            this.modifiers = modifiers;
        }

        @Override
        String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        ImmutableList<String> parameterTypes() {
            throw new UnsupportedOperationException();
        }

        @Override
        String returnType() {
            throw new UnsupportedOperationException();
        }

        @Override
        ImmutableList<String> modifiers() {
            throw new UnsupportedOperationException();
        }
    }
}

