/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.InstrumentationConfigJsonService;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.primitives.Booleans;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="InstrumentationConfigJsonService.InstrumentationListResponse", generator="Immutables")
@Immutable
final class ImmutableInstrumentationListResponse
implements InstrumentationConfigJsonService.InstrumentationListResponse {
    private final ImmutableList<InstrumentationConfigJsonService.InstrumentationConfigDto> configs;
    private final boolean jvmOutOfSync;
    private final boolean jvmRetransformClassesSupported;

    private ImmutableInstrumentationListResponse(ImmutableList<InstrumentationConfigJsonService.InstrumentationConfigDto> configs, boolean jvmOutOfSync, boolean jvmRetransformClassesSupported) {
        this.configs = configs;
        this.jvmOutOfSync = jvmOutOfSync;
        this.jvmRetransformClassesSupported = jvmRetransformClassesSupported;
    }

    @Override
    @JsonProperty(value="configs")
    public ImmutableList<InstrumentationConfigJsonService.InstrumentationConfigDto> configs() {
        return this.configs;
    }

    @Override
    @JsonProperty(value="jvmOutOfSync")
    public boolean jvmOutOfSync() {
        return this.jvmOutOfSync;
    }

    @Override
    @JsonProperty(value="jvmRetransformClassesSupported")
    public boolean jvmRetransformClassesSupported() {
        return this.jvmRetransformClassesSupported;
    }

    public final ImmutableInstrumentationListResponse withConfigs(InstrumentationConfigJsonService.InstrumentationConfigDto ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableInstrumentationListResponse((ImmutableList<InstrumentationConfigJsonService.InstrumentationConfigDto>)newValue, this.jvmOutOfSync, this.jvmRetransformClassesSupported);
    }

    public final ImmutableInstrumentationListResponse withConfigs(Iterable<? extends InstrumentationConfigJsonService.InstrumentationConfigDto> elements) {
        if (this.configs == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableInstrumentationListResponse((ImmutableList<InstrumentationConfigJsonService.InstrumentationConfigDto>)newValue, this.jvmOutOfSync, this.jvmRetransformClassesSupported);
    }

    public final ImmutableInstrumentationListResponse withJvmOutOfSync(boolean value) {
        if (this.jvmOutOfSync == value) {
            return this;
        }
        return new ImmutableInstrumentationListResponse(this.configs, value, this.jvmRetransformClassesSupported);
    }

    public final ImmutableInstrumentationListResponse withJvmRetransformClassesSupported(boolean value) {
        if (this.jvmRetransformClassesSupported == value) {
            return this;
        }
        return new ImmutableInstrumentationListResponse(this.configs, this.jvmOutOfSync, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInstrumentationListResponse && this.equalTo(0, (ImmutableInstrumentationListResponse)another);
    }

    private boolean equalTo(int synthetic, ImmutableInstrumentationListResponse another) {
        return this.configs.equals(another.configs) && this.jvmOutOfSync == another.jvmOutOfSync && this.jvmRetransformClassesSupported == another.jvmRetransformClassesSupported;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.configs.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.jvmOutOfSync);
        h += (h << 5) + Booleans.hashCode((boolean)this.jvmRetransformClassesSupported);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"InstrumentationListResponse").omitNullValues().add("configs", this.configs).add("jvmOutOfSync", this.jvmOutOfSync).add("jvmRetransformClassesSupported", this.jvmRetransformClassesSupported).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableInstrumentationListResponse fromJson(Json json) {
        Builder builder = ImmutableInstrumentationListResponse.builder();
        if (json.configs != null) {
            builder.addAllConfigs((Iterable<? extends InstrumentationConfigJsonService.InstrumentationConfigDto>)json.configs);
        }
        if (json.jvmOutOfSyncIsSet) {
            builder.jvmOutOfSync(json.jvmOutOfSync);
        }
        if (json.jvmRetransformClassesSupportedIsSet) {
            builder.jvmRetransformClassesSupported(json.jvmRetransformClassesSupported);
        }
        return builder.build();
    }

    public static ImmutableInstrumentationListResponse copyOf(InstrumentationConfigJsonService.InstrumentationListResponse instance) {
        if (instance instanceof ImmutableInstrumentationListResponse) {
            return (ImmutableInstrumentationListResponse)instance;
        }
        return ImmutableInstrumentationListResponse.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="InstrumentationConfigJsonService.InstrumentationListResponse", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_JVM_OUT_OF_SYNC = 1L;
        private static final long INIT_BIT_JVM_RETRANSFORM_CLASSES_SUPPORTED = 2L;
        private long initBits = 3L;
        private ImmutableList.Builder<InstrumentationConfigJsonService.InstrumentationConfigDto> configs = ImmutableList.builder();
        private boolean jvmOutOfSync;
        private boolean jvmRetransformClassesSupported;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(InstrumentationConfigJsonService.InstrumentationListResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllConfigs((Iterable<? extends InstrumentationConfigJsonService.InstrumentationConfigDto>)instance.configs());
            this.jvmOutOfSync(instance.jvmOutOfSync());
            this.jvmRetransformClassesSupported(instance.jvmRetransformClassesSupported());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addConfigs(InstrumentationConfigJsonService.InstrumentationConfigDto element) {
            this.configs.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addConfigs(InstrumentationConfigJsonService.InstrumentationConfigDto ... elements) {
            this.configs.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder configs(Iterable<? extends InstrumentationConfigJsonService.InstrumentationConfigDto> elements) {
            this.configs = ImmutableList.builder();
            return this.addAllConfigs(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllConfigs(Iterable<? extends InstrumentationConfigJsonService.InstrumentationConfigDto> elements) {
            this.configs.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder jvmOutOfSync(boolean jvmOutOfSync) {
            this.jvmOutOfSync = jvmOutOfSync;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder jvmRetransformClassesSupported(boolean jvmRetransformClassesSupported) {
            this.jvmRetransformClassesSupported = jvmRetransformClassesSupported;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableInstrumentationListResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInstrumentationListResponse(this.configs.build(), this.jvmOutOfSync, this.jvmRetransformClassesSupported);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("jvmOutOfSync");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("jvmRetransformClassesSupported");
            }
            return "Cannot build InstrumentationListResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="InstrumentationConfigJsonService.InstrumentationListResponse", generator="Immutables")
    static final class Json
    implements InstrumentationConfigJsonService.InstrumentationListResponse {
        @Nullable
        ImmutableList<InstrumentationConfigJsonService.InstrumentationConfigDto> configs = ImmutableList.of();
        boolean jvmOutOfSync;
        boolean jvmOutOfSyncIsSet;
        boolean jvmRetransformClassesSupported;
        boolean jvmRetransformClassesSupportedIsSet;

        Json() {
        }

        @JsonProperty(value="configs")
        public void setConfigs(ImmutableList<InstrumentationConfigJsonService.InstrumentationConfigDto> configs) {
            this.configs = configs;
        }

        @JsonProperty(value="jvmOutOfSync")
        public void setJvmOutOfSync(boolean jvmOutOfSync) {
            this.jvmOutOfSync = jvmOutOfSync;
            this.jvmOutOfSyncIsSet = true;
        }

        @JsonProperty(value="jvmRetransformClassesSupported")
        public void setJvmRetransformClassesSupported(boolean jvmRetransformClassesSupported) {
            this.jvmRetransformClassesSupported = jvmRetransformClassesSupported;
            this.jvmRetransformClassesSupportedIsSet = true;
        }

        @Override
        public ImmutableList<InstrumentationConfigJsonService.InstrumentationConfigDto> configs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean jvmOutOfSync() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean jvmRetransformClassesSupported() {
            throw new UnsupportedOperationException();
        }
    }
}

