/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.CommonHandler;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CommonHandler.Credentials", generator="Immutables")
@Immutable
final class ImmutableCredentials
implements CommonHandler.Credentials {
    private final String username;
    private final String password;

    private ImmutableCredentials(String username, String password) {
        this.username = username;
        this.password = password;
    }

    @Override
    @JsonProperty(value="username")
    public String username() {
        return this.username;
    }

    @Override
    @JsonProperty(value="password")
    public String password() {
        return this.password;
    }

    public final ImmutableCredentials withUsername(String value) {
        String newValue = Objects.requireNonNull(value, "username");
        if (this.username.equals(newValue)) {
            return this;
        }
        return new ImmutableCredentials(newValue, this.password);
    }

    public final ImmutableCredentials withPassword(String value) {
        String newValue = Objects.requireNonNull(value, "password");
        if (this.password.equals(newValue)) {
            return this;
        }
        return new ImmutableCredentials(this.username, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCredentials && this.equalTo(0, (ImmutableCredentials)another);
    }

    private boolean equalTo(int synthetic, ImmutableCredentials another) {
        return this.username.equals(another.username) && this.password.equals(another.password);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.username.hashCode();
        h += (h << 5) + this.password.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Credentials").omitNullValues().add("username", (Object)this.username).add("password", (Object)this.password).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableCredentials fromJson(Json json) {
        Builder builder = ImmutableCredentials.builder();
        if (json.username != null) {
            builder.username(json.username);
        }
        if (json.password != null) {
            builder.password(json.password);
        }
        return builder.build();
    }

    public static ImmutableCredentials copyOf(CommonHandler.Credentials instance) {
        if (instance instanceof ImmutableCredentials) {
            return (ImmutableCredentials)instance;
        }
        return ImmutableCredentials.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CommonHandler.Credentials", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_USERNAME = 1L;
        private static final long INIT_BIT_PASSWORD = 2L;
        private long initBits = 3L;
        @Nullable
        private String username;
        @Nullable
        private String password;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(CommonHandler.Credentials instance) {
            Objects.requireNonNull(instance, "instance");
            this.username(instance.username());
            this.password(instance.password());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder username(String username) {
            this.username = Objects.requireNonNull(username, "username");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder password(String password) {
            this.password = Objects.requireNonNull(password, "password");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableCredentials build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCredentials(this.username, this.password);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("username");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("password");
            }
            return "Cannot build Credentials, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="CommonHandler.Credentials", generator="Immutables")
    static final class Json
    implements CommonHandler.Credentials {
        @Nullable
        String username;
        @Nullable
        String password;

        Json() {
        }

        @JsonProperty(value="username")
        public void setUsername(String username) {
            this.username = username;
        }

        @JsonProperty(value="password")
        public void setPassword(String password) {
            this.password = password;
        }

        @Override
        public String username() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String password() {
            throw new UnsupportedOperationException();
        }
    }
}

