/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.LdapAuthentication;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableSet;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="LdapAuthentication.AuthenticationResult", generator="Immutables")
@Immutable
final class ImmutableAuthenticationResult
implements LdapAuthentication.AuthenticationResult {
    private final String userDn;
    private final ImmutableSet<String> ldapGroupDns;

    private ImmutableAuthenticationResult(String userDn, ImmutableSet<String> ldapGroupDns) {
        this.userDn = userDn;
        this.ldapGroupDns = ldapGroupDns;
    }

    @Override
    @JsonProperty(value="userDn")
    public String userDn() {
        return this.userDn;
    }

    @JsonProperty(value="ldapGroupDns")
    public ImmutableSet<String> ldapGroupDns() {
        return this.ldapGroupDns;
    }

    public final ImmutableAuthenticationResult withUserDn(String value) {
        String newValue = Objects.requireNonNull(value, "userDn");
        if (this.userDn.equals(newValue)) {
            return this;
        }
        return new ImmutableAuthenticationResult(newValue, this.ldapGroupDns);
    }

    public final ImmutableAuthenticationResult withLdapGroupDns(String ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new ImmutableAuthenticationResult(this.userDn, (ImmutableSet<String>)newValue);
    }

    public final ImmutableAuthenticationResult withLdapGroupDns(Iterable<String> elements) {
        if (this.ldapGroupDns == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ImmutableAuthenticationResult(this.userDn, (ImmutableSet<String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAuthenticationResult && this.equalTo(0, (ImmutableAuthenticationResult)another);
    }

    private boolean equalTo(int synthetic, ImmutableAuthenticationResult another) {
        return this.userDn.equals(another.userDn) && this.ldapGroupDns.equals(another.ldapGroupDns);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.userDn.hashCode();
        h += (h << 5) + this.ldapGroupDns.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AuthenticationResult").omitNullValues().add("userDn", (Object)this.userDn).add("ldapGroupDns", this.ldapGroupDns).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAuthenticationResult fromJson(Json json) {
        Builder builder = ImmutableAuthenticationResult.builder();
        if (json.userDn != null) {
            builder.userDn(json.userDn);
        }
        if (json.ldapGroupDns != null) {
            builder.addAllLdapGroupDns(json.ldapGroupDns);
        }
        return builder.build();
    }

    public static ImmutableAuthenticationResult copyOf(LdapAuthentication.AuthenticationResult instance) {
        if (instance instanceof ImmutableAuthenticationResult) {
            return (ImmutableAuthenticationResult)instance;
        }
        return ImmutableAuthenticationResult.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="LdapAuthentication.AuthenticationResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_USER_DN = 1L;
        private long initBits = 1L;
        @Nullable
        private String userDn;
        private ImmutableSet.Builder<String> ldapGroupDns = ImmutableSet.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(LdapAuthentication.AuthenticationResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.userDn(instance.userDn());
            this.addAllLdapGroupDns(instance.ldapGroupDns());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder userDn(String userDn) {
            this.userDn = Objects.requireNonNull(userDn, "userDn");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLdapGroupDns(String element) {
            this.ldapGroupDns.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLdapGroupDns(String ... elements) {
            this.ldapGroupDns.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ldapGroupDns(Iterable<String> elements) {
            this.ldapGroupDns = ImmutableSet.builder();
            return this.addAllLdapGroupDns(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllLdapGroupDns(Iterable<String> elements) {
            this.ldapGroupDns.addAll(elements);
            return this;
        }

        public ImmutableAuthenticationResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAuthenticationResult(this.userDn, this.ldapGroupDns.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("userDn");
            }
            return "Cannot build AuthenticationResult, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="LdapAuthentication.AuthenticationResult", generator="Immutables")
    static final class Json
    implements LdapAuthentication.AuthenticationResult {
        @Nullable
        String userDn;
        @Nullable
        Set<String> ldapGroupDns = ImmutableSet.of();

        Json() {
        }

        @JsonProperty(value="userDn")
        public void setUserDn(String userDn) {
            this.userDn = userDn;
        }

        @JsonProperty(value="ldapGroupDns")
        public void setLdapGroupDns(Set<String> ldapGroupDns) {
            this.ldapGroupDns = ldapGroupDns;
        }

        @Override
        public String userDn() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<String> ldapGroupDns() {
            throw new UnsupportedOperationException();
        }
    }
}

