/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ConfigRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.HttpSessionManager;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableSet;
import org.glowroot.agent.shaded.com.google.common.primitives.Booleans;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="HttpSessionManager.Authentication", generator="Immutables")
@Immutable
final class ImmutableAuthentication
extends HttpSessionManager.Authentication {
    private final boolean central;
    private final boolean offlineViewer;
    private final boolean anonymous;
    private final boolean ldap;
    private final String caseAmbiguousUsername;
    private final ImmutableSet<String> roles;
    private final ConfigRepository configRepository;

    private ImmutableAuthentication(boolean central, boolean offlineViewer, boolean anonymous, boolean ldap, String caseAmbiguousUsername, ImmutableSet<String> roles, ConfigRepository configRepository) {
        this.central = central;
        this.offlineViewer = offlineViewer;
        this.anonymous = anonymous;
        this.ldap = ldap;
        this.caseAmbiguousUsername = caseAmbiguousUsername;
        this.roles = roles;
        this.configRepository = configRepository;
    }

    @Override
    @JsonProperty(value="central")
    boolean central() {
        return this.central;
    }

    @Override
    @JsonProperty(value="offlineViewer")
    boolean offlineViewer() {
        return this.offlineViewer;
    }

    @Override
    @JsonProperty(value="anonymous")
    boolean anonymous() {
        return this.anonymous;
    }

    @Override
    @JsonProperty(value="ldap")
    boolean ldap() {
        return this.ldap;
    }

    @Override
    @JsonProperty(value="caseAmbiguousUsername")
    String caseAmbiguousUsername() {
        return this.caseAmbiguousUsername;
    }

    @JsonProperty(value="roles")
    ImmutableSet<String> roles() {
        return this.roles;
    }

    @Override
    @JsonProperty(value="configRepository")
    ConfigRepository configRepository() {
        return this.configRepository;
    }

    public final ImmutableAuthentication withCentral(boolean value) {
        if (this.central == value) {
            return this;
        }
        return new ImmutableAuthentication(value, this.offlineViewer, this.anonymous, this.ldap, this.caseAmbiguousUsername, this.roles, this.configRepository);
    }

    public final ImmutableAuthentication withOfflineViewer(boolean value) {
        if (this.offlineViewer == value) {
            return this;
        }
        return new ImmutableAuthentication(this.central, value, this.anonymous, this.ldap, this.caseAmbiguousUsername, this.roles, this.configRepository);
    }

    public final ImmutableAuthentication withAnonymous(boolean value) {
        if (this.anonymous == value) {
            return this;
        }
        return new ImmutableAuthentication(this.central, this.offlineViewer, value, this.ldap, this.caseAmbiguousUsername, this.roles, this.configRepository);
    }

    public final ImmutableAuthentication withLdap(boolean value) {
        if (this.ldap == value) {
            return this;
        }
        return new ImmutableAuthentication(this.central, this.offlineViewer, this.anonymous, value, this.caseAmbiguousUsername, this.roles, this.configRepository);
    }

    public final ImmutableAuthentication withCaseAmbiguousUsername(String value) {
        String newValue = Objects.requireNonNull(value, "caseAmbiguousUsername");
        if (this.caseAmbiguousUsername.equals(newValue)) {
            return this;
        }
        return new ImmutableAuthentication(this.central, this.offlineViewer, this.anonymous, this.ldap, newValue, this.roles, this.configRepository);
    }

    public final ImmutableAuthentication withRoles(String ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new ImmutableAuthentication(this.central, this.offlineViewer, this.anonymous, this.ldap, this.caseAmbiguousUsername, (ImmutableSet<String>)newValue, this.configRepository);
    }

    public final ImmutableAuthentication withRoles(Iterable<String> elements) {
        if (this.roles == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ImmutableAuthentication(this.central, this.offlineViewer, this.anonymous, this.ldap, this.caseAmbiguousUsername, (ImmutableSet<String>)newValue, this.configRepository);
    }

    public final ImmutableAuthentication withConfigRepository(ConfigRepository value) {
        if (this.configRepository == value) {
            return this;
        }
        ConfigRepository newValue = Objects.requireNonNull(value, "configRepository");
        return new ImmutableAuthentication(this.central, this.offlineViewer, this.anonymous, this.ldap, this.caseAmbiguousUsername, this.roles, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAuthentication && this.equalTo(0, (ImmutableAuthentication)another);
    }

    private boolean equalTo(int synthetic, ImmutableAuthentication another) {
        return this.central == another.central && this.offlineViewer == another.offlineViewer && this.anonymous == another.anonymous && this.ldap == another.ldap && this.caseAmbiguousUsername.equals(another.caseAmbiguousUsername) && this.roles.equals(another.roles) && this.configRepository.equals(another.configRepository);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Booleans.hashCode((boolean)this.central);
        h += (h << 5) + Booleans.hashCode((boolean)this.offlineViewer);
        h += (h << 5) + Booleans.hashCode((boolean)this.anonymous);
        h += (h << 5) + Booleans.hashCode((boolean)this.ldap);
        h += (h << 5) + this.caseAmbiguousUsername.hashCode();
        h += (h << 5) + this.roles.hashCode();
        h += (h << 5) + this.configRepository.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Authentication").omitNullValues().add("central", this.central).add("offlineViewer", this.offlineViewer).add("anonymous", this.anonymous).add("ldap", this.ldap).add("caseAmbiguousUsername", (Object)this.caseAmbiguousUsername).add("roles", this.roles).add("configRepository", (Object)this.configRepository).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAuthentication fromJson(Json json) {
        Builder builder = ImmutableAuthentication.builder();
        if (json.centralIsSet) {
            builder.central(json.central);
        }
        if (json.offlineViewerIsSet) {
            builder.offlineViewer(json.offlineViewer);
        }
        if (json.anonymousIsSet) {
            builder.anonymous(json.anonymous);
        }
        if (json.ldapIsSet) {
            builder.ldap(json.ldap);
        }
        if (json.caseAmbiguousUsername != null) {
            builder.caseAmbiguousUsername(json.caseAmbiguousUsername);
        }
        if (json.roles != null) {
            builder.addAllRoles(json.roles);
        }
        if (json.configRepository != null) {
            builder.configRepository(json.configRepository);
        }
        return builder.build();
    }

    public static ImmutableAuthentication copyOf(HttpSessionManager.Authentication instance) {
        if (instance instanceof ImmutableAuthentication) {
            return (ImmutableAuthentication)instance;
        }
        return ImmutableAuthentication.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="HttpSessionManager.Authentication", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CENTRAL = 1L;
        private static final long INIT_BIT_OFFLINE_VIEWER = 2L;
        private static final long INIT_BIT_ANONYMOUS = 4L;
        private static final long INIT_BIT_LDAP = 8L;
        private static final long INIT_BIT_CASE_AMBIGUOUS_USERNAME = 16L;
        private static final long INIT_BIT_CONFIG_REPOSITORY = 32L;
        private long initBits = 63L;
        private boolean central;
        private boolean offlineViewer;
        private boolean anonymous;
        private boolean ldap;
        @Nullable
        private String caseAmbiguousUsername;
        private ImmutableSet.Builder<String> roles = ImmutableSet.builder();
        @Nullable
        private ConfigRepository configRepository;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(HttpSessionManager.Authentication instance) {
            Objects.requireNonNull(instance, "instance");
            this.central(instance.central());
            this.offlineViewer(instance.offlineViewer());
            this.anonymous(instance.anonymous());
            this.ldap(instance.ldap());
            this.caseAmbiguousUsername(instance.caseAmbiguousUsername());
            this.addAllRoles(instance.roles());
            this.configRepository(instance.configRepository());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder central(boolean central) {
            this.central = central;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder offlineViewer(boolean offlineViewer) {
            this.offlineViewer = offlineViewer;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder anonymous(boolean anonymous) {
            this.anonymous = anonymous;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ldap(boolean ldap) {
            this.ldap = ldap;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder caseAmbiguousUsername(String caseAmbiguousUsername) {
            this.caseAmbiguousUsername = Objects.requireNonNull(caseAmbiguousUsername, "caseAmbiguousUsername");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRoles(String element) {
            this.roles.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRoles(String ... elements) {
            this.roles.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder roles(Iterable<String> elements) {
            this.roles = ImmutableSet.builder();
            return this.addAllRoles(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllRoles(Iterable<String> elements) {
            this.roles.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder configRepository(ConfigRepository configRepository) {
            this.configRepository = Objects.requireNonNull(configRepository, "configRepository");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public ImmutableAuthentication build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAuthentication(this.central, this.offlineViewer, this.anonymous, this.ldap, this.caseAmbiguousUsername, this.roles.build(), this.configRepository);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("central");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("offlineViewer");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("anonymous");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("ldap");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("caseAmbiguousUsername");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("configRepository");
            }
            return "Cannot build Authentication, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="HttpSessionManager.Authentication", generator="Immutables")
    static final class Json
    extends HttpSessionManager.Authentication {
        boolean central;
        boolean centralIsSet;
        boolean offlineViewer;
        boolean offlineViewerIsSet;
        boolean anonymous;
        boolean anonymousIsSet;
        boolean ldap;
        boolean ldapIsSet;
        @Nullable
        String caseAmbiguousUsername;
        @Nullable
        Set<String> roles = ImmutableSet.of();
        @Nullable
        ConfigRepository configRepository;

        Json() {
        }

        @JsonProperty(value="central")
        public void setCentral(boolean central) {
            this.central = central;
            this.centralIsSet = true;
        }

        @JsonProperty(value="offlineViewer")
        public void setOfflineViewer(boolean offlineViewer) {
            this.offlineViewer = offlineViewer;
            this.offlineViewerIsSet = true;
        }

        @JsonProperty(value="anonymous")
        public void setAnonymous(boolean anonymous) {
            this.anonymous = anonymous;
            this.anonymousIsSet = true;
        }

        @JsonProperty(value="ldap")
        public void setLdap(boolean ldap) {
            this.ldap = ldap;
            this.ldapIsSet = true;
        }

        @JsonProperty(value="caseAmbiguousUsername")
        public void setCaseAmbiguousUsername(String caseAmbiguousUsername) {
            this.caseAmbiguousUsername = caseAmbiguousUsername;
        }

        @JsonProperty(value="roles")
        public void setRoles(Set<String> roles) {
            this.roles = roles;
        }

        @JsonProperty(value="configRepository")
        public void setConfigRepository(ConfigRepository configRepository) {
            this.configRepository = configRepository;
        }

        @Override
        boolean central() {
            throw new UnsupportedOperationException();
        }

        @Override
        boolean offlineViewer() {
            throw new UnsupportedOperationException();
        }

        @Override
        boolean anonymous() {
            throw new UnsupportedOperationException();
        }

        @Override
        boolean ldap() {
            throw new UnsupportedOperationException();
        }

        @Override
        String caseAmbiguousUsername() {
            throw new UnsupportedOperationException();
        }

        @Override
        Set<String> roles() {
            throw new UnsupportedOperationException();
        }

        @Override
        ConfigRepository configRepository() {
            throw new UnsupportedOperationException();
        }
    }
}

