/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.AllConfigDto;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutablePluginConfig;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.org.glowroot.common.config.ImmutableAdvancedConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.ImmutableAlertConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.ImmutableGaugeConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.ImmutableInstrumentationConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.ImmutableJvmConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.ImmutableSyntheticMonitorConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.ImmutableTransactionConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.ImmutableUiDefaultsConfig;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AllConfigDto", generator="Immutables")
@Immutable
final class ImmutableAllConfigDto
extends AllConfigDto {
    private final ImmutableTransactionConfig transactions;
    private final ImmutableJvmConfig jvm;
    private final ImmutableUiDefaultsConfig uiDefaults;
    private final ImmutableAdvancedConfig advanced;
    private final ImmutableList<ImmutableGaugeConfig> gauges;
    private final ImmutableList<ImmutableSyntheticMonitorConfig> syntheticMonitors;
    private final ImmutableList<ImmutableAlertConfig> alerts;
    private final ImmutableList<ImmutablePluginConfig> plugins;
    private final ImmutableList<ImmutableInstrumentationConfig> instrumentation;
    @Nullable
    private final String version;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableAllConfigDto(Builder builder) {
        this.gauges = builder.gauges.build();
        this.syntheticMonitors = builder.syntheticMonitors.build();
        this.alerts = builder.alerts.build();
        this.plugins = builder.plugins.build();
        this.instrumentation = builder.instrumentation.build();
        this.version = builder.version;
        if (builder.transactions != null) {
            this.initShim.transactions(builder.transactions);
        }
        if (builder.jvm != null) {
            this.initShim.jvm(builder.jvm);
        }
        if (builder.uiDefaults != null) {
            this.initShim.uiDefaults(builder.uiDefaults);
        }
        if (builder.advanced != null) {
            this.initShim.advanced(builder.advanced);
        }
        this.transactions = this.initShim.transactions();
        this.jvm = this.initShim.jvm();
        this.uiDefaults = this.initShim.uiDefaults();
        this.advanced = this.initShim.advanced();
        this.initShim = null;
    }

    private ImmutableAllConfigDto(ImmutableTransactionConfig transactions, ImmutableJvmConfig jvm, ImmutableUiDefaultsConfig uiDefaults, ImmutableAdvancedConfig advanced, ImmutableList<ImmutableGaugeConfig> gauges, ImmutableList<ImmutableSyntheticMonitorConfig> syntheticMonitors, ImmutableList<ImmutableAlertConfig> alerts, ImmutableList<ImmutablePluginConfig> plugins, ImmutableList<ImmutableInstrumentationConfig> instrumentation, @Nullable String version) {
        this.transactions = transactions;
        this.jvm = jvm;
        this.uiDefaults = uiDefaults;
        this.advanced = advanced;
        this.gauges = gauges;
        this.syntheticMonitors = syntheticMonitors;
        this.alerts = alerts;
        this.plugins = plugins;
        this.instrumentation = instrumentation;
        this.version = version;
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="transactions")
    ImmutableTransactionConfig transactions() {
        InitShim shim = this.initShim;
        return shim != null ? shim.transactions() : this.transactions;
    }

    @Override
    @JsonProperty(value="jvm")
    ImmutableJvmConfig jvm() {
        InitShim shim = this.initShim;
        return shim != null ? shim.jvm() : this.jvm;
    }

    @Override
    @JsonProperty(value="uiDefaults")
    ImmutableUiDefaultsConfig uiDefaults() {
        InitShim shim = this.initShim;
        return shim != null ? shim.uiDefaults() : this.uiDefaults;
    }

    @Override
    @JsonProperty(value="advanced")
    ImmutableAdvancedConfig advanced() {
        InitShim shim = this.initShim;
        return shim != null ? shim.advanced() : this.advanced;
    }

    @JsonProperty(value="gauges")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    ImmutableList<ImmutableGaugeConfig> gauges() {
        return this.gauges;
    }

    @JsonProperty(value="syntheticMonitors")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    ImmutableList<ImmutableSyntheticMonitorConfig> syntheticMonitors() {
        return this.syntheticMonitors;
    }

    @JsonProperty(value="alerts")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    ImmutableList<ImmutableAlertConfig> alerts() {
        return this.alerts;
    }

    @JsonProperty(value="plugins")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    ImmutableList<ImmutablePluginConfig> plugins() {
        return this.plugins;
    }

    @JsonProperty(value="instrumentation")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    ImmutableList<ImmutableInstrumentationConfig> instrumentation() {
        return this.instrumentation;
    }

    @Override
    @JsonProperty(value="version")
    @Nullable
    String version() {
        return this.version;
    }

    public final ImmutableAllConfigDto withTransactions(ImmutableTransactionConfig value) {
        if (this.transactions == value) {
            return this;
        }
        ImmutableTransactionConfig newValue = Objects.requireNonNull(value, "transactions");
        return new ImmutableAllConfigDto(newValue, this.jvm, this.uiDefaults, this.advanced, this.gauges, this.syntheticMonitors, this.alerts, this.plugins, this.instrumentation, this.version);
    }

    public final ImmutableAllConfigDto withJvm(ImmutableJvmConfig value) {
        if (this.jvm == value) {
            return this;
        }
        ImmutableJvmConfig newValue = Objects.requireNonNull(value, "jvm");
        return new ImmutableAllConfigDto(this.transactions, newValue, this.uiDefaults, this.advanced, this.gauges, this.syntheticMonitors, this.alerts, this.plugins, this.instrumentation, this.version);
    }

    public final ImmutableAllConfigDto withUiDefaults(ImmutableUiDefaultsConfig value) {
        if (this.uiDefaults == value) {
            return this;
        }
        ImmutableUiDefaultsConfig newValue = Objects.requireNonNull(value, "uiDefaults");
        return new ImmutableAllConfigDto(this.transactions, this.jvm, newValue, this.advanced, this.gauges, this.syntheticMonitors, this.alerts, this.plugins, this.instrumentation, this.version);
    }

    public final ImmutableAllConfigDto withAdvanced(ImmutableAdvancedConfig value) {
        if (this.advanced == value) {
            return this;
        }
        ImmutableAdvancedConfig newValue = Objects.requireNonNull(value, "advanced");
        return new ImmutableAllConfigDto(this.transactions, this.jvm, this.uiDefaults, newValue, this.gauges, this.syntheticMonitors, this.alerts, this.plugins, this.instrumentation, this.version);
    }

    public final ImmutableAllConfigDto withGauges(ImmutableGaugeConfig ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableAllConfigDto(this.transactions, this.jvm, this.uiDefaults, this.advanced, (ImmutableList<ImmutableGaugeConfig>)newValue, this.syntheticMonitors, this.alerts, this.plugins, this.instrumentation, this.version);
    }

    public final ImmutableAllConfigDto withGauges(Iterable<? extends ImmutableGaugeConfig> elements) {
        if (this.gauges == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableAllConfigDto(this.transactions, this.jvm, this.uiDefaults, this.advanced, (ImmutableList<ImmutableGaugeConfig>)newValue, this.syntheticMonitors, this.alerts, this.plugins, this.instrumentation, this.version);
    }

    public final ImmutableAllConfigDto withSyntheticMonitors(ImmutableSyntheticMonitorConfig ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableAllConfigDto(this.transactions, this.jvm, this.uiDefaults, this.advanced, this.gauges, (ImmutableList<ImmutableSyntheticMonitorConfig>)newValue, this.alerts, this.plugins, this.instrumentation, this.version);
    }

    public final ImmutableAllConfigDto withSyntheticMonitors(Iterable<? extends ImmutableSyntheticMonitorConfig> elements) {
        if (this.syntheticMonitors == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableAllConfigDto(this.transactions, this.jvm, this.uiDefaults, this.advanced, this.gauges, (ImmutableList<ImmutableSyntheticMonitorConfig>)newValue, this.alerts, this.plugins, this.instrumentation, this.version);
    }

    public final ImmutableAllConfigDto withAlerts(ImmutableAlertConfig ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableAllConfigDto(this.transactions, this.jvm, this.uiDefaults, this.advanced, this.gauges, this.syntheticMonitors, (ImmutableList<ImmutableAlertConfig>)newValue, this.plugins, this.instrumentation, this.version);
    }

    public final ImmutableAllConfigDto withAlerts(Iterable<? extends ImmutableAlertConfig> elements) {
        if (this.alerts == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableAllConfigDto(this.transactions, this.jvm, this.uiDefaults, this.advanced, this.gauges, this.syntheticMonitors, (ImmutableList<ImmutableAlertConfig>)newValue, this.plugins, this.instrumentation, this.version);
    }

    public final ImmutableAllConfigDto withPlugins(ImmutablePluginConfig ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableAllConfigDto(this.transactions, this.jvm, this.uiDefaults, this.advanced, this.gauges, this.syntheticMonitors, this.alerts, (ImmutableList<ImmutablePluginConfig>)newValue, this.instrumentation, this.version);
    }

    public final ImmutableAllConfigDto withPlugins(Iterable<? extends ImmutablePluginConfig> elements) {
        if (this.plugins == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableAllConfigDto(this.transactions, this.jvm, this.uiDefaults, this.advanced, this.gauges, this.syntheticMonitors, this.alerts, (ImmutableList<ImmutablePluginConfig>)newValue, this.instrumentation, this.version);
    }

    public final ImmutableAllConfigDto withInstrumentation(ImmutableInstrumentationConfig ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableAllConfigDto(this.transactions, this.jvm, this.uiDefaults, this.advanced, this.gauges, this.syntheticMonitors, this.alerts, this.plugins, (ImmutableList<ImmutableInstrumentationConfig>)newValue, this.version);
    }

    public final ImmutableAllConfigDto withInstrumentation(Iterable<? extends ImmutableInstrumentationConfig> elements) {
        if (this.instrumentation == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableAllConfigDto(this.transactions, this.jvm, this.uiDefaults, this.advanced, this.gauges, this.syntheticMonitors, this.alerts, this.plugins, (ImmutableList<ImmutableInstrumentationConfig>)newValue, this.version);
    }

    public final ImmutableAllConfigDto withVersion(@Nullable String value) {
        if (Objects.equals(this.version, value)) {
            return this;
        }
        return new ImmutableAllConfigDto(this.transactions, this.jvm, this.uiDefaults, this.advanced, this.gauges, this.syntheticMonitors, this.alerts, this.plugins, this.instrumentation, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAllConfigDto && this.equalTo(0, (ImmutableAllConfigDto)another);
    }

    private boolean equalTo(int synthetic, ImmutableAllConfigDto another) {
        return this.transactions.equals((Object)another.transactions) && this.jvm.equals((Object)another.jvm) && this.uiDefaults.equals((Object)another.uiDefaults) && this.advanced.equals((Object)another.advanced) && this.gauges.equals(another.gauges) && this.syntheticMonitors.equals(another.syntheticMonitors) && this.alerts.equals(another.alerts) && this.plugins.equals(another.plugins) && this.instrumentation.equals(another.instrumentation) && Objects.equals(this.version, another.version);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.transactions.hashCode();
        h += (h << 5) + this.jvm.hashCode();
        h += (h << 5) + this.uiDefaults.hashCode();
        h += (h << 5) + this.advanced.hashCode();
        h += (h << 5) + this.gauges.hashCode();
        h += (h << 5) + this.syntheticMonitors.hashCode();
        h += (h << 5) + this.alerts.hashCode();
        h += (h << 5) + this.plugins.hashCode();
        h += (h << 5) + this.instrumentation.hashCode();
        h += (h << 5) + Objects.hashCode(this.version);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AllConfigDto").omitNullValues().add("transactions", (Object)this.transactions).add("jvm", (Object)this.jvm).add("uiDefaults", (Object)this.uiDefaults).add("advanced", (Object)this.advanced).add("gauges", this.gauges).add("syntheticMonitors", this.syntheticMonitors).add("alerts", this.alerts).add("plugins", this.plugins).add("instrumentation", this.instrumentation).add("version", (Object)this.version).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAllConfigDto fromJson(Json json) {
        Builder builder = ImmutableAllConfigDto.builder();
        if (json.transactions != null) {
            builder.transactions(json.transactions);
        }
        if (json.jvm != null) {
            builder.jvm(json.jvm);
        }
        if (json.uiDefaults != null) {
            builder.uiDefaults(json.uiDefaults);
        }
        if (json.advanced != null) {
            builder.advanced(json.advanced);
        }
        if (json.gauges != null) {
            builder.addAllGauges(json.gauges);
        }
        if (json.syntheticMonitors != null) {
            builder.addAllSyntheticMonitors(json.syntheticMonitors);
        }
        if (json.alerts != null) {
            builder.addAllAlerts(json.alerts);
        }
        if (json.plugins != null) {
            builder.addAllPlugins(json.plugins);
        }
        if (json.instrumentation != null) {
            builder.addAllInstrumentation(json.instrumentation);
        }
        if (json.version != null) {
            builder.version(json.version);
        }
        return builder.build();
    }

    public static ImmutableAllConfigDto copyOf(AllConfigDto instance) {
        if (instance instanceof ImmutableAllConfigDto) {
            return (ImmutableAllConfigDto)instance;
        }
        return ImmutableAllConfigDto.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AllConfigDto", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private ImmutableTransactionConfig transactions;
        @Nullable
        private ImmutableJvmConfig jvm;
        @Nullable
        private ImmutableUiDefaultsConfig uiDefaults;
        @Nullable
        private ImmutableAdvancedConfig advanced;
        private ImmutableList.Builder<ImmutableGaugeConfig> gauges = ImmutableList.builder();
        private ImmutableList.Builder<ImmutableSyntheticMonitorConfig> syntheticMonitors = ImmutableList.builder();
        private ImmutableList.Builder<ImmutableAlertConfig> alerts = ImmutableList.builder();
        private ImmutableList.Builder<ImmutablePluginConfig> plugins = ImmutableList.builder();
        private ImmutableList.Builder<ImmutableInstrumentationConfig> instrumentation = ImmutableList.builder();
        @Nullable
        private String version;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(AllConfigDto instance) {
            Objects.requireNonNull(instance, "instance");
            this.transactions(instance.transactions());
            this.jvm(instance.jvm());
            this.uiDefaults(instance.uiDefaults());
            this.advanced(instance.advanced());
            this.addAllGauges(instance.gauges());
            this.addAllSyntheticMonitors(instance.syntheticMonitors());
            this.addAllAlerts(instance.alerts());
            this.addAllPlugins(instance.plugins());
            this.addAllInstrumentation(instance.instrumentation());
            String versionValue = instance.version();
            if (versionValue != null) {
                this.version(versionValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder transactions(ImmutableTransactionConfig transactions) {
            this.transactions = Objects.requireNonNull(transactions, "transactions");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder jvm(ImmutableJvmConfig jvm) {
            this.jvm = Objects.requireNonNull(jvm, "jvm");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder uiDefaults(ImmutableUiDefaultsConfig uiDefaults) {
            this.uiDefaults = Objects.requireNonNull(uiDefaults, "uiDefaults");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder advanced(ImmutableAdvancedConfig advanced) {
            this.advanced = Objects.requireNonNull(advanced, "advanced");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addGauges(ImmutableGaugeConfig element) {
            this.gauges.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addGauges(ImmutableGaugeConfig ... elements) {
            this.gauges.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder gauges(Iterable<? extends ImmutableGaugeConfig> elements) {
            this.gauges = ImmutableList.builder();
            return this.addAllGauges(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllGauges(Iterable<? extends ImmutableGaugeConfig> elements) {
            this.gauges.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSyntheticMonitors(ImmutableSyntheticMonitorConfig element) {
            this.syntheticMonitors.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSyntheticMonitors(ImmutableSyntheticMonitorConfig ... elements) {
            this.syntheticMonitors.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder syntheticMonitors(Iterable<? extends ImmutableSyntheticMonitorConfig> elements) {
            this.syntheticMonitors = ImmutableList.builder();
            return this.addAllSyntheticMonitors(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSyntheticMonitors(Iterable<? extends ImmutableSyntheticMonitorConfig> elements) {
            this.syntheticMonitors.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAlerts(ImmutableAlertConfig element) {
            this.alerts.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAlerts(ImmutableAlertConfig ... elements) {
            this.alerts.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder alerts(Iterable<? extends ImmutableAlertConfig> elements) {
            this.alerts = ImmutableList.builder();
            return this.addAllAlerts(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllAlerts(Iterable<? extends ImmutableAlertConfig> elements) {
            this.alerts.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPlugins(ImmutablePluginConfig element) {
            this.plugins.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPlugins(ImmutablePluginConfig ... elements) {
            this.plugins.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder plugins(Iterable<? extends ImmutablePluginConfig> elements) {
            this.plugins = ImmutableList.builder();
            return this.addAllPlugins(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllPlugins(Iterable<? extends ImmutablePluginConfig> elements) {
            this.plugins.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addInstrumentation(ImmutableInstrumentationConfig element) {
            this.instrumentation.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addInstrumentation(ImmutableInstrumentationConfig ... elements) {
            this.instrumentation.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder instrumentation(Iterable<? extends ImmutableInstrumentationConfig> elements) {
            this.instrumentation = ImmutableList.builder();
            return this.addAllInstrumentation(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllInstrumentation(Iterable<? extends ImmutableInstrumentationConfig> elements) {
            this.instrumentation.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder version(@Nullable String version) {
            this.version = version;
            return this;
        }

        public ImmutableAllConfigDto build() {
            return new ImmutableAllConfigDto(this);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AllConfigDto", generator="Immutables")
    static final class Json
    extends AllConfigDto {
        @Nullable
        ImmutableTransactionConfig transactions;
        @Nullable
        ImmutableJvmConfig jvm;
        @Nullable
        ImmutableUiDefaultsConfig uiDefaults;
        @Nullable
        ImmutableAdvancedConfig advanced;
        @Nullable
        List<ImmutableGaugeConfig> gauges = ImmutableList.of();
        @Nullable
        List<ImmutableSyntheticMonitorConfig> syntheticMonitors = ImmutableList.of();
        @Nullable
        List<ImmutableAlertConfig> alerts = ImmutableList.of();
        @Nullable
        List<ImmutablePluginConfig> plugins = ImmutableList.of();
        @Nullable
        List<ImmutableInstrumentationConfig> instrumentation = ImmutableList.of();
        @Nullable
        String version;

        Json() {
        }

        @JsonProperty(value="transactions")
        public void setTransactions(ImmutableTransactionConfig transactions) {
            this.transactions = transactions;
        }

        @JsonProperty(value="jvm")
        public void setJvm(ImmutableJvmConfig jvm) {
            this.jvm = jvm;
        }

        @JsonProperty(value="uiDefaults")
        public void setUiDefaults(ImmutableUiDefaultsConfig uiDefaults) {
            this.uiDefaults = uiDefaults;
        }

        @JsonProperty(value="advanced")
        public void setAdvanced(ImmutableAdvancedConfig advanced) {
            this.advanced = advanced;
        }

        @JsonProperty(value="gauges")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setGauges(List<ImmutableGaugeConfig> gauges) {
            this.gauges = gauges;
        }

        @JsonProperty(value="syntheticMonitors")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setSyntheticMonitors(List<ImmutableSyntheticMonitorConfig> syntheticMonitors) {
            this.syntheticMonitors = syntheticMonitors;
        }

        @JsonProperty(value="alerts")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setAlerts(List<ImmutableAlertConfig> alerts) {
            this.alerts = alerts;
        }

        @JsonProperty(value="plugins")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setPlugins(List<ImmutablePluginConfig> plugins) {
            this.plugins = plugins;
        }

        @JsonProperty(value="instrumentation")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setInstrumentation(List<ImmutableInstrumentationConfig> instrumentation) {
            this.instrumentation = instrumentation;
        }

        @JsonProperty(value="version")
        public void setVersion(@Nullable String version) {
            this.version = version;
        }

        @Override
        ImmutableTransactionConfig transactions() {
            throw new UnsupportedOperationException();
        }

        @Override
        ImmutableJvmConfig jvm() {
            throw new UnsupportedOperationException();
        }

        @Override
        ImmutableUiDefaultsConfig uiDefaults() {
            throw new UnsupportedOperationException();
        }

        @Override
        ImmutableAdvancedConfig advanced() {
            throw new UnsupportedOperationException();
        }

        @Override
        List<ImmutableGaugeConfig> gauges() {
            throw new UnsupportedOperationException();
        }

        @Override
        List<ImmutableSyntheticMonitorConfig> syntheticMonitors() {
            throw new UnsupportedOperationException();
        }

        @Override
        List<ImmutableAlertConfig> alerts() {
            throw new UnsupportedOperationException();
        }

        @Override
        List<ImmutablePluginConfig> plugins() {
            throw new UnsupportedOperationException();
        }

        @Override
        List<ImmutableInstrumentationConfig> instrumentation() {
            throw new UnsupportedOperationException();
        }

        @Override
        String version() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="AllConfigDto", generator="Immutables")
    private final class InitShim {
        private byte transactionsBuildStage = 0;
        private ImmutableTransactionConfig transactions;
        private byte jvmBuildStage = 0;
        private ImmutableJvmConfig jvm;
        private byte uiDefaultsBuildStage = 0;
        private ImmutableUiDefaultsConfig uiDefaults;
        private byte advancedBuildStage = 0;
        private ImmutableAdvancedConfig advanced;

        private InitShim() {
        }

        ImmutableTransactionConfig transactions() {
            if (this.transactionsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.transactionsBuildStage == 0) {
                this.transactionsBuildStage = (byte)-1;
                this.transactions = Objects.requireNonNull(ImmutableAllConfigDto.super.transactions(), "transactions");
                this.transactionsBuildStage = 1;
            }
            return this.transactions;
        }

        void transactions(ImmutableTransactionConfig transactions) {
            this.transactions = transactions;
            this.transactionsBuildStage = 1;
        }

        ImmutableJvmConfig jvm() {
            if (this.jvmBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.jvmBuildStage == 0) {
                this.jvmBuildStage = (byte)-1;
                this.jvm = Objects.requireNonNull(ImmutableAllConfigDto.super.jvm(), "jvm");
                this.jvmBuildStage = 1;
            }
            return this.jvm;
        }

        void jvm(ImmutableJvmConfig jvm) {
            this.jvm = jvm;
            this.jvmBuildStage = 1;
        }

        ImmutableUiDefaultsConfig uiDefaults() {
            if (this.uiDefaultsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.uiDefaultsBuildStage == 0) {
                this.uiDefaultsBuildStage = (byte)-1;
                this.uiDefaults = Objects.requireNonNull(ImmutableAllConfigDto.super.uiDefaults(), "uiDefaults");
                this.uiDefaultsBuildStage = 1;
            }
            return this.uiDefaults;
        }

        void uiDefaults(ImmutableUiDefaultsConfig uiDefaults) {
            this.uiDefaults = uiDefaults;
            this.uiDefaultsBuildStage = 1;
        }

        ImmutableAdvancedConfig advanced() {
            if (this.advancedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.advancedBuildStage == 0) {
                this.advancedBuildStage = (byte)-1;
                this.advanced = Objects.requireNonNull(ImmutableAllConfigDto.super.advanced(), "advanced");
                this.advancedBuildStage = 1;
            }
            return this.advanced;
        }

        void advanced(ImmutableAdvancedConfig advanced) {
            this.advanced = advanced;
            this.advancedBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.transactionsBuildStage == -1) {
                attributes.add("transactions");
            }
            if (this.jvmBuildStage == -1) {
                attributes.add("jvm");
            }
            if (this.uiDefaultsBuildStage == -1) {
                attributes.add("uiDefaults");
            }
            if (this.advancedBuildStage == -1) {
                attributes.add("advanced");
            }
            return "Cannot build AllConfigDto, attribute initializers form cycle " + attributes;
        }
    }
}

