/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ChunkSource;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ChunkedInputs;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.CommonHandler;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.HttpServices;
import org.glowroot.agent.shaded.com.google.common.annotations.VisibleForTesting;
import org.glowroot.agent.shaded.com.google.common.base.Charsets;
import org.glowroot.agent.shaded.com.google.common.base.Strings;
import org.glowroot.agent.shaded.com.google.common.base.Supplier;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.net.MediaType;
import org.glowroot.agent.shaded.io.netty.buffer.ByteBuf;
import org.glowroot.agent.shaded.io.netty.buffer.Unpooled;
import org.glowroot.agent.shaded.io.netty.channel.Channel;
import org.glowroot.agent.shaded.io.netty.channel.ChannelFuture;
import org.glowroot.agent.shaded.io.netty.channel.ChannelFutureListener;
import org.glowroot.agent.shaded.io.netty.channel.ChannelHandler;
import org.glowroot.agent.shaded.io.netty.channel.ChannelHandlerContext;
import org.glowroot.agent.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import org.glowroot.agent.shaded.io.netty.channel.group.ChannelGroup;
import org.glowroot.agent.shaded.io.netty.channel.group.DefaultChannelGroup;
import org.glowroot.agent.shaded.io.netty.handler.codec.http.DefaultFullHttpResponse;
import org.glowroot.agent.shaded.io.netty.handler.codec.http.DefaultHttpResponse;
import org.glowroot.agent.shaded.io.netty.handler.codec.http.EmptyHttpHeaders;
import org.glowroot.agent.shaded.io.netty.handler.codec.http.FullHttpRequest;
import org.glowroot.agent.shaded.io.netty.handler.codec.http.FullHttpResponse;
import org.glowroot.agent.shaded.io.netty.handler.codec.http.HttpContent;
import org.glowroot.agent.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import org.glowroot.agent.shaded.io.netty.handler.codec.http.HttpHeaderValues;
import org.glowroot.agent.shaded.io.netty.handler.codec.http.HttpHeaders;
import org.glowroot.agent.shaded.io.netty.handler.codec.http.HttpMessage;
import org.glowroot.agent.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import org.glowroot.agent.shaded.io.netty.handler.codec.http.HttpUtil;
import org.glowroot.agent.shaded.io.netty.handler.codec.http.HttpVersion;
import org.glowroot.agent.shaded.io.netty.handler.codec.http.QueryStringDecoder;
import org.glowroot.agent.shaded.io.netty.handler.stream.ChunkedInput;
import org.glowroot.agent.shaded.io.netty.util.concurrent.EventExecutor;
import org.glowroot.agent.shaded.io.netty.util.concurrent.GenericFutureListener;
import org.glowroot.agent.shaded.io.netty.util.concurrent.GlobalEventExecutor;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
class HttpServerHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(HttpServerHandler.class);
    private static final ThreadLocal<Channel> currentChannel = new ThreadLocal();
    private final ChannelGroup allChannels;
    private final Supplier<String> contextPathSupplier;
    private final CommonHandler commonHandler;

    HttpServerHandler(Supplier<String> contextPathSupplier, CommonHandler commonHandler) {
        this.contextPathSupplier = contextPathSupplier;
        this.commonHandler = commonHandler;
        this.allChannels = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.allChannels.add((Object)ctx.channel());
        super.channelActive(ctx);
    }

    void closeAllButCurrent() throws Exception {
        Channel current = currentChannel.get();
        for (Channel channel : this.allChannels) {
            if (channel == current) continue;
            channel.close().await().get();
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        FullHttpRequest request = (FullHttpRequest)msg;
        if (request.decoderResult().isFailure()) {
            CommonHandler.CommonResponse response = new CommonHandler.CommonResponse(HttpResponseStatus.BAD_REQUEST, MediaType.PLAIN_TEXT_UTF_8, Strings.nullToEmpty((String)request.decoderResult().cause().getMessage()));
            HttpServerHandler.sendResponse(ctx, request, response, false);
            return;
        }
        String uri = request.uri();
        logger.debug("channelRead(): request.uri={}", (Object)uri);
        Channel channel = ctx.channel();
        currentChannel.set(channel);
        try {
            String contextPath = (String)this.contextPathSupplier.get();
            boolean keepAlive = HttpUtil.isKeepAlive((HttpMessage)request);
            if (!uri.startsWith(contextPath)) {
                DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FOUND);
                response.headers().set((CharSequence)HttpHeaderNames.LOCATION, (Object)contextPath);
                HttpServerHandler.sendFullResponse(ctx, request, (FullHttpResponse)response, keepAlive);
                return;
            }
            QueryStringDecoder decoder = new QueryStringDecoder(HttpServerHandler.stripContextPath(uri, contextPath));
            NettyRequest commonRequest = new NettyRequest(request, contextPath, decoder);
            CommonHandler.CommonResponse response = this.commonHandler.handle(commonRequest);
            if (response.isCloseConnectionAfterPortChange()) {
                response.setHeader("Connection", "close");
                keepAlive = false;
            }
            HttpServerHandler.sendResponse(ctx, request, response, keepAlive);
        }
        catch (Exception e) {
            logger.error("error handling request {}: {}", new Object[]{uri, e.getMessage(), e});
            CommonHandler.CommonResponse response = CommonHandler.newHttpResponseWithStackTrace(e, HttpResponseStatus.INTERNAL_SERVER_ERROR, null);
            HttpServerHandler.sendResponse(ctx, request, response, false);
        }
        finally {
            currentChannel.remove();
            request.release();
        }
    }

    private static void sendResponse(ChannelHandlerContext ctx, FullHttpRequest request, CommonHandler.CommonResponse response, boolean keepAlive) throws IOException {
        Object content = response.getContent();
        if (content instanceof String) {
            DefaultFullHttpResponse resp = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, response.getStatus(), Unpooled.copiedBuffer((CharSequence)((String)content), (Charset)Charsets.UTF_8), response.getHeaders(), (HttpHeaders)EmptyHttpHeaders.INSTANCE);
            HttpServerHandler.sendFullResponse(ctx, request, (FullHttpResponse)resp, keepAlive);
        } else if (content instanceof ByteBuf) {
            DefaultFullHttpResponse resp = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, response.getStatus(), (ByteBuf)content, response.getHeaders(), (HttpHeaders)EmptyHttpHeaders.INSTANCE);
            HttpServerHandler.sendFullResponse(ctx, request, (FullHttpResponse)resp, keepAlive);
        } else if (content instanceof ChunkSource) {
            DefaultHttpResponse resp = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, response.getHeaders());
            resp.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
            ChannelFuture future = ctx.write((Object)resp);
            HttpServices.addErrorListener(future);
            ChunkSource chunkSource = (ChunkSource)content;
            String zipFileName = response.getZipFileName();
            ChunkedInput<HttpContent> chunkedInput = zipFileName == null ? ChunkedInputs.create(chunkSource) : ChunkedInputs.createZipFileDownload(chunkSource, zipFileName);
            future = ctx.write(chunkedInput);
            HttpServices.addErrorListener(future);
            if (!keepAlive) {
                HttpServices.addCloseListener(future);
            }
        } else {
            throw new IllegalStateException("Unexpected content: " + content.getClass().getName());
        }
    }

    private static void sendFullResponse(ChannelHandlerContext ctx, FullHttpRequest request, FullHttpResponse response, boolean keepAlive) {
        response.headers().add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)response.content().readableBytes());
        if (keepAlive && !request.protocolVersion().isKeepAliveDefault()) {
            response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        }
        ChannelFuture future = ctx.write((Object)response);
        HttpServices.addErrorListener(future);
        if (!keepAlive) {
            future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (HttpServices.shouldLogException(cause)) {
            logger.warn(cause.getMessage(), cause);
        }
        ctx.close();
    }

    @VisibleForTesting
    static String stripContextPath(String path, String contextPath) {
        if (contextPath.equals("/")) {
            return path;
        }
        if (path.equals(contextPath)) {
            return "/";
        }
        return path.substring(contextPath.length());
    }

    private static class NettyRequest
    implements CommonHandler.CommonRequest {
        private final FullHttpRequest request;
        private final String contextPath;
        private final QueryStringDecoder decoder;

        NettyRequest(FullHttpRequest request, String contextPath, QueryStringDecoder decoder) {
            this.request = request;
            this.contextPath = contextPath;
            this.decoder = decoder;
        }

        @Override
        public String getMethod() {
            return this.request.method().name();
        }

        @Override
        public String getUri() {
            return this.request.uri();
        }

        @Override
        public String getContextPath() {
            return this.contextPath;
        }

        @Override
        public String getPath() {
            return this.decoder.path();
        }

        @Override
        public @Nullable String getHeader(CharSequence name) {
            return this.request.headers().getAsString(name);
        }

        @Override
        public Map<String, List<String>> getParameters() {
            return this.decoder.parameters();
        }

        @Override
        public List<String> getParameters(String name) {
            List params = (List)this.decoder.parameters().get(name);
            if (params == null) {
                return ImmutableList.of();
            }
            return params;
        }

        @Override
        public String getContent() {
            return this.request.content().toString(Charsets.UTF_8);
        }
    }
}

