/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo;

import java.util.List;
import java.util.concurrent.CompletionStage;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.CassandraProfile;
import org.glowroot.agent.shaded.org.glowroot.common.live.LiveTraceRepository;
import org.glowroot.agent.shaded.org.glowroot.common.model.Result;
import org.glowroot.agent.shaded.org.glowroot.common.util.Styles;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.ProfileOuterClass;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.TraceOuterClass;
import org.immutables.value.Value;

public interface TraceRepository {
    public CompletionStage<Long> readSlowCount(String var1, TraceQuery var2) throws Exception;

    public CompletionStage<Result<LiveTraceRepository.TracePoint>> readSlowPoints(String var1, TraceQuery var2, LiveTraceRepository.TracePointFilter var3, int var4) throws Exception;

    public CompletionStage<Long> readErrorCount(String var1, TraceQuery var2) throws Exception;

    public CompletionStage<Result<LiveTraceRepository.TracePoint>> readErrorPoints(String var1, TraceQuery var2, LiveTraceRepository.TracePointFilter var3, int var4) throws Exception;

    public CompletionStage<ErrorMessageResult> readErrorMessages(String var1, TraceQuery var2, ErrorMessageFilter var3, long var4, int var6);

    public CompletionStage<Long> readErrorMessageCount(String var1, TraceQuery var2, String var3, CassandraProfile var4);

    public CompletionStage<HeaderPlus> readHeaderPlus(String var1, String var2);

    public CompletionStage<LiveTraceRepository.Entries> readEntries(String var1, String var2, CassandraProfile var3) throws Exception;

    public CompletionStage<LiveTraceRepository.Queries> readQueries(String var1, String var2, CassandraProfile var3) throws Exception;

    public CompletionStage<LiveTraceRepository.EntriesAndQueries> readEntriesAndQueriesForExport(String var1, String var2, CassandraProfile var3) throws Exception;

    public CompletionStage<ProfileOuterClass.Profile> readMainThreadProfile(String var1, String var2) throws Exception;

    public CompletionStage<ProfileOuterClass.Profile> readAuxThreadProfile(String var1, String var2) throws Exception;

    @Value.Immutable
    public static interface HeaderPlus {
        public TraceOuterClass.Trace.Header header();

        public LiveTraceRepository.Existence entriesExistence();

        public LiveTraceRepository.Existence queriesExistence();

        public LiveTraceRepository.Existence profileExistence();
    }

    @Value.Immutable
    @Styles.AllParameters
    public static interface ErrorMessageCount {
        public String message();

        public long count();
    }

    @Value.Immutable
    @Styles.AllParameters
    public static interface ErrorMessagePoint {
        public long captureTime();

        public long errorCount();
    }

    @Value.Immutable
    public static interface ErrorMessageResult {
        public List<ErrorMessagePoint> points();

        public Result<ErrorMessageCount> counts();
    }

    @Value.Immutable
    public static interface ErrorMessageFilter {
        public List<String> includes();

        public List<String> excludes();
    }

    @Value.Immutable
    public static interface TraceQuery {
        public String transactionType();

        public @Nullable String transactionName();

        public long from();

        public long to();
    }
}

