/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.RepoAdmin;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.primitives.Longs;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="RepoAdmin.TraceCount", generator="Immutables")
@Immutable
public final class ImmutableTraceCount
implements RepoAdmin.TraceCount {
    private final String transactionType;
    private final String transactionName;
    private final long count;
    private final long errorCount;

    private ImmutableTraceCount(String transactionType, String transactionName, long count, long errorCount) {
        this.transactionType = transactionType;
        this.transactionName = transactionName;
        this.count = count;
        this.errorCount = errorCount;
    }

    @Override
    @JsonProperty(value="transactionType")
    public String transactionType() {
        return this.transactionType;
    }

    @Override
    @JsonProperty(value="transactionName")
    public String transactionName() {
        return this.transactionName;
    }

    @Override
    @JsonProperty(value="count")
    public long count() {
        return this.count;
    }

    @Override
    @JsonProperty(value="errorCount")
    public long errorCount() {
        return this.errorCount;
    }

    public final ImmutableTraceCount withTransactionType(String value) {
        String newValue = Objects.requireNonNull(value, "transactionType");
        if (this.transactionType.equals(newValue)) {
            return this;
        }
        return new ImmutableTraceCount(newValue, this.transactionName, this.count, this.errorCount);
    }

    public final ImmutableTraceCount withTransactionName(String value) {
        String newValue = Objects.requireNonNull(value, "transactionName");
        if (this.transactionName.equals(newValue)) {
            return this;
        }
        return new ImmutableTraceCount(this.transactionType, newValue, this.count, this.errorCount);
    }

    public final ImmutableTraceCount withCount(long value) {
        if (this.count == value) {
            return this;
        }
        return new ImmutableTraceCount(this.transactionType, this.transactionName, value, this.errorCount);
    }

    public final ImmutableTraceCount withErrorCount(long value) {
        if (this.errorCount == value) {
            return this;
        }
        return new ImmutableTraceCount(this.transactionType, this.transactionName, this.count, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTraceCount && this.equalTo(0, (ImmutableTraceCount)another);
    }

    private boolean equalTo(int synthetic, ImmutableTraceCount another) {
        return this.transactionType.equals(another.transactionType) && this.transactionName.equals(another.transactionName) && this.count == another.count && this.errorCount == another.errorCount;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.transactionType.hashCode();
        h += (h << 5) + this.transactionName.hashCode();
        h += (h << 5) + Longs.hashCode((long)this.count);
        h += (h << 5) + Longs.hashCode((long)this.errorCount);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TraceCount").omitNullValues().add("transactionType", (Object)this.transactionType).add("transactionName", (Object)this.transactionName).add("count", this.count).add("errorCount", this.errorCount).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTraceCount fromJson(Json json) {
        Builder builder = ImmutableTraceCount.builder();
        if (json.transactionType != null) {
            builder.transactionType(json.transactionType);
        }
        if (json.transactionName != null) {
            builder.transactionName(json.transactionName);
        }
        if (json.countIsSet) {
            builder.count(json.count);
        }
        if (json.errorCountIsSet) {
            builder.errorCount(json.errorCount);
        }
        return builder.build();
    }

    public static ImmutableTraceCount copyOf(RepoAdmin.TraceCount instance) {
        if (instance instanceof ImmutableTraceCount) {
            return (ImmutableTraceCount)instance;
        }
        return ImmutableTraceCount.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RepoAdmin.TraceCount", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TRANSACTION_TYPE = 1L;
        private static final long INIT_BIT_TRANSACTION_NAME = 2L;
        private static final long INIT_BIT_COUNT = 4L;
        private static final long INIT_BIT_ERROR_COUNT = 8L;
        private long initBits = 15L;
        @Nullable
        private String transactionType;
        @Nullable
        private String transactionName;
        private long count;
        private long errorCount;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(RepoAdmin.TraceCount instance) {
            Objects.requireNonNull(instance, "instance");
            this.transactionType(instance.transactionType());
            this.transactionName(instance.transactionName());
            this.count(instance.count());
            this.errorCount(instance.errorCount());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder transactionType(String transactionType) {
            this.transactionType = Objects.requireNonNull(transactionType, "transactionType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder transactionName(String transactionName) {
            this.transactionName = Objects.requireNonNull(transactionName, "transactionName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder count(long count) {
            this.count = count;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder errorCount(long errorCount) {
            this.errorCount = errorCount;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableTraceCount build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTraceCount(this.transactionType, this.transactionName, this.count, this.errorCount);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("transactionType");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("transactionName");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("count");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("errorCount");
            }
            return "Cannot build TraceCount, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="RepoAdmin.TraceCount", generator="Immutables")
    static final class Json
    implements RepoAdmin.TraceCount {
        @Nullable
        String transactionType;
        @Nullable
        String transactionName;
        long count;
        boolean countIsSet;
        long errorCount;
        boolean errorCountIsSet;

        Json() {
        }

        @JsonProperty(value="transactionType")
        public void setTransactionType(String transactionType) {
            this.transactionType = transactionType;
        }

        @JsonProperty(value="transactionName")
        public void setTransactionName(String transactionName) {
            this.transactionName = transactionName;
        }

        @JsonProperty(value="count")
        public void setCount(long count) {
            this.count = count;
            this.countIsSet = true;
        }

        @JsonProperty(value="errorCount")
        public void setErrorCount(long errorCount) {
            this.errorCount = errorCount;
            this.errorCountIsSet = true;
        }

        @Override
        public String transactionType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String transactionName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long count() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long errorCount() {
            throw new UnsupportedOperationException();
        }
    }
}

