/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.common2.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.LdapConfig;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableMap;
import org.glowroot.agent.shaded.com.google.common.primitives.Booleans;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="LdapConfig", generator="Immutables")
@Immutable
public final class ImmutableLdapConfig
extends LdapConfig {
    private final String host;
    private final @org.checkerframework.checker.nullness.qual.Nullable Integer port;
    private final boolean ssl;
    private final String username;
    private final String encryptedPassword;
    private final String userBaseDn;
    private final String userSearchFilter;
    private final String groupBaseDn;
    private final String groupSearchFilter;
    private final ImmutableMap<String, List<String>> roleMappings;
    private final transient String version;
    private final transient String url;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableLdapConfig(Builder builder) {
        this.port = builder.port;
        this.roleMappings = builder.roleMappings.build();
        if (builder.host != null) {
            this.initShim.host(builder.host);
        }
        if (builder.sslIsSet()) {
            this.initShim.ssl(builder.ssl);
        }
        if (builder.username != null) {
            this.initShim.username(builder.username);
        }
        if (builder.encryptedPassword != null) {
            this.initShim.encryptedPassword(builder.encryptedPassword);
        }
        if (builder.userBaseDn != null) {
            this.initShim.userBaseDn(builder.userBaseDn);
        }
        if (builder.userSearchFilter != null) {
            this.initShim.userSearchFilter(builder.userSearchFilter);
        }
        if (builder.groupBaseDn != null) {
            this.initShim.groupBaseDn(builder.groupBaseDn);
        }
        if (builder.groupSearchFilter != null) {
            this.initShim.groupSearchFilter(builder.groupSearchFilter);
        }
        this.host = this.initShim.host();
        this.ssl = this.initShim.ssl();
        this.username = this.initShim.username();
        this.encryptedPassword = this.initShim.encryptedPassword();
        this.userBaseDn = this.initShim.userBaseDn();
        this.userSearchFilter = this.initShim.userSearchFilter();
        this.groupBaseDn = this.initShim.groupBaseDn();
        this.groupSearchFilter = this.initShim.groupSearchFilter();
        this.version = this.initShim.version();
        this.url = this.initShim.url();
        this.initShim = null;
    }

    private ImmutableLdapConfig(String host, @org.checkerframework.checker.nullness.qual.Nullable Integer port, boolean ssl, String username, String encryptedPassword, String userBaseDn, String userSearchFilter, String groupBaseDn, String groupSearchFilter, ImmutableMap<String, List<String>> roleMappings) {
        this.initShim.host(host);
        this.port = port;
        this.initShim.ssl(ssl);
        this.initShim.username(username);
        this.initShim.encryptedPassword(encryptedPassword);
        this.initShim.userBaseDn(userBaseDn);
        this.initShim.userSearchFilter(userSearchFilter);
        this.initShim.groupBaseDn(groupBaseDn);
        this.initShim.groupSearchFilter(groupSearchFilter);
        this.roleMappings = roleMappings;
        this.host = this.initShim.host();
        this.ssl = this.initShim.ssl();
        this.username = this.initShim.username();
        this.encryptedPassword = this.initShim.encryptedPassword();
        this.userBaseDn = this.initShim.userBaseDn();
        this.userSearchFilter = this.initShim.userSearchFilter();
        this.groupBaseDn = this.initShim.groupBaseDn();
        this.groupSearchFilter = this.initShim.groupSearchFilter();
        this.version = this.initShim.version();
        this.url = this.initShim.url();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="host")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public String host() {
        InitShim shim = this.initShim;
        return shim != null ? shim.host() : this.host;
    }

    @Override
    @JsonProperty(value="port")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public @org.checkerframework.checker.nullness.qual.Nullable Integer port() {
        return this.port;
    }

    @Override
    @JsonProperty(value="ssl")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public boolean ssl() {
        InitShim shim = this.initShim;
        return shim != null ? shim.ssl() : this.ssl;
    }

    @Override
    @JsonProperty(value="username")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public String username() {
        InitShim shim = this.initShim;
        return shim != null ? shim.username() : this.username;
    }

    @Override
    @JsonProperty(value="encryptedPassword")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public String encryptedPassword() {
        InitShim shim = this.initShim;
        return shim != null ? shim.encryptedPassword() : this.encryptedPassword;
    }

    @Override
    @JsonProperty(value="userBaseDn")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public String userBaseDn() {
        InitShim shim = this.initShim;
        return shim != null ? shim.userBaseDn() : this.userBaseDn;
    }

    @Override
    @JsonProperty(value="userSearchFilter")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public String userSearchFilter() {
        InitShim shim = this.initShim;
        return shim != null ? shim.userSearchFilter() : this.userSearchFilter;
    }

    @Override
    @JsonProperty(value="groupBaseDn")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public String groupBaseDn() {
        InitShim shim = this.initShim;
        return shim != null ? shim.groupBaseDn() : this.groupBaseDn;
    }

    @Override
    @JsonProperty(value="groupSearchFilter")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public String groupSearchFilter() {
        InitShim shim = this.initShim;
        return shim != null ? shim.groupSearchFilter() : this.groupSearchFilter;
    }

    @JsonProperty(value="roleMappings")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public ImmutableMap<String, List<String>> roleMappings() {
        return this.roleMappings;
    }

    @Override
    @JsonProperty(value="version")
    @JsonIgnore
    public String version() {
        InitShim shim = this.initShim;
        return shim != null ? shim.version() : this.version;
    }

    @Override
    @JsonProperty(value="url")
    @JsonIgnore
    public String url() {
        InitShim shim = this.initShim;
        return shim != null ? shim.url() : this.url;
    }

    public final ImmutableLdapConfig withHost(String value) {
        String newValue = Objects.requireNonNull(value, "host");
        if (this.host.equals(newValue)) {
            return this;
        }
        return new ImmutableLdapConfig(newValue, this.port, this.ssl, this.username, this.encryptedPassword, this.userBaseDn, this.userSearchFilter, this.groupBaseDn, this.groupSearchFilter, this.roleMappings);
    }

    public final ImmutableLdapConfig withPort(@org.checkerframework.checker.nullness.qual.Nullable Integer value) {
        if (Objects.equals(this.port, value)) {
            return this;
        }
        return new ImmutableLdapConfig(this.host, value, this.ssl, this.username, this.encryptedPassword, this.userBaseDn, this.userSearchFilter, this.groupBaseDn, this.groupSearchFilter, this.roleMappings);
    }

    public final ImmutableLdapConfig withSsl(boolean value) {
        if (this.ssl == value) {
            return this;
        }
        return new ImmutableLdapConfig(this.host, this.port, value, this.username, this.encryptedPassword, this.userBaseDn, this.userSearchFilter, this.groupBaseDn, this.groupSearchFilter, this.roleMappings);
    }

    public final ImmutableLdapConfig withUsername(String value) {
        String newValue = Objects.requireNonNull(value, "username");
        if (this.username.equals(newValue)) {
            return this;
        }
        return new ImmutableLdapConfig(this.host, this.port, this.ssl, newValue, this.encryptedPassword, this.userBaseDn, this.userSearchFilter, this.groupBaseDn, this.groupSearchFilter, this.roleMappings);
    }

    public final ImmutableLdapConfig withEncryptedPassword(String value) {
        String newValue = Objects.requireNonNull(value, "encryptedPassword");
        if (this.encryptedPassword.equals(newValue)) {
            return this;
        }
        return new ImmutableLdapConfig(this.host, this.port, this.ssl, this.username, newValue, this.userBaseDn, this.userSearchFilter, this.groupBaseDn, this.groupSearchFilter, this.roleMappings);
    }

    public final ImmutableLdapConfig withUserBaseDn(String value) {
        String newValue = Objects.requireNonNull(value, "userBaseDn");
        if (this.userBaseDn.equals(newValue)) {
            return this;
        }
        return new ImmutableLdapConfig(this.host, this.port, this.ssl, this.username, this.encryptedPassword, newValue, this.userSearchFilter, this.groupBaseDn, this.groupSearchFilter, this.roleMappings);
    }

    public final ImmutableLdapConfig withUserSearchFilter(String value) {
        String newValue = Objects.requireNonNull(value, "userSearchFilter");
        if (this.userSearchFilter.equals(newValue)) {
            return this;
        }
        return new ImmutableLdapConfig(this.host, this.port, this.ssl, this.username, this.encryptedPassword, this.userBaseDn, newValue, this.groupBaseDn, this.groupSearchFilter, this.roleMappings);
    }

    public final ImmutableLdapConfig withGroupBaseDn(String value) {
        String newValue = Objects.requireNonNull(value, "groupBaseDn");
        if (this.groupBaseDn.equals(newValue)) {
            return this;
        }
        return new ImmutableLdapConfig(this.host, this.port, this.ssl, this.username, this.encryptedPassword, this.userBaseDn, this.userSearchFilter, newValue, this.groupSearchFilter, this.roleMappings);
    }

    public final ImmutableLdapConfig withGroupSearchFilter(String value) {
        String newValue = Objects.requireNonNull(value, "groupSearchFilter");
        if (this.groupSearchFilter.equals(newValue)) {
            return this;
        }
        return new ImmutableLdapConfig(this.host, this.port, this.ssl, this.username, this.encryptedPassword, this.userBaseDn, this.userSearchFilter, this.groupBaseDn, newValue, this.roleMappings);
    }

    public final ImmutableLdapConfig withRoleMappings(Map<String, ? extends List<String>> entries) {
        if (this.roleMappings == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableLdapConfig(this.host, this.port, this.ssl, this.username, this.encryptedPassword, this.userBaseDn, this.userSearchFilter, this.groupBaseDn, this.groupSearchFilter, (ImmutableMap<String, List<String>>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLdapConfig && this.equalTo(0, (ImmutableLdapConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableLdapConfig another) {
        return this.host.equals(another.host) && Objects.equals(this.port, another.port) && this.ssl == another.ssl && this.username.equals(another.username) && this.encryptedPassword.equals(another.encryptedPassword) && this.userBaseDn.equals(another.userBaseDn) && this.userSearchFilter.equals(another.userSearchFilter) && this.groupBaseDn.equals(another.groupBaseDn) && this.groupSearchFilter.equals(another.groupSearchFilter) && this.roleMappings.equals(another.roleMappings) && this.version.equals(another.version) && this.url.equals(another.url);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.host.hashCode();
        h += (h << 5) + Objects.hashCode(this.port);
        h += (h << 5) + Booleans.hashCode((boolean)this.ssl);
        h += (h << 5) + this.username.hashCode();
        h += (h << 5) + this.encryptedPassword.hashCode();
        h += (h << 5) + this.userBaseDn.hashCode();
        h += (h << 5) + this.userSearchFilter.hashCode();
        h += (h << 5) + this.groupBaseDn.hashCode();
        h += (h << 5) + this.groupSearchFilter.hashCode();
        h += (h << 5) + this.roleMappings.hashCode();
        h += (h << 5) + this.version.hashCode();
        h += (h << 5) + this.url.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"LdapConfig").omitNullValues().add("host", (Object)this.host).add("port", (Object)this.port).add("ssl", this.ssl).add("username", (Object)this.username).add("encryptedPassword", (Object)this.encryptedPassword).add("userBaseDn", (Object)this.userBaseDn).add("userSearchFilter", (Object)this.userSearchFilter).add("groupBaseDn", (Object)this.groupBaseDn).add("groupSearchFilter", (Object)this.groupSearchFilter).add("roleMappings", this.roleMappings).add("version", (Object)this.version).add("url", (Object)this.url).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableLdapConfig fromJson(Json json) {
        Builder builder = ImmutableLdapConfig.builder();
        if (json.host != null) {
            builder.host(json.host);
        }
        if (json.port != null) {
            builder.port(json.port);
        }
        if (json.sslIsSet) {
            builder.ssl(json.ssl);
        }
        if (json.username != null) {
            builder.username(json.username);
        }
        if (json.encryptedPassword != null) {
            builder.encryptedPassword(json.encryptedPassword);
        }
        if (json.userBaseDn != null) {
            builder.userBaseDn(json.userBaseDn);
        }
        if (json.userSearchFilter != null) {
            builder.userSearchFilter(json.userSearchFilter);
        }
        if (json.groupBaseDn != null) {
            builder.groupBaseDn(json.groupBaseDn);
        }
        if (json.groupSearchFilter != null) {
            builder.groupSearchFilter(json.groupSearchFilter);
        }
        if (json.roleMappings != null) {
            builder.putAllRoleMappings(json.roleMappings);
        }
        return builder.build();
    }

    public static ImmutableLdapConfig copyOf(LdapConfig instance) {
        if (instance instanceof ImmutableLdapConfig) {
            return (ImmutableLdapConfig)instance;
        }
        return ImmutableLdapConfig.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="LdapConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_SSL = 1L;
        private long optBits;
        @Nullable
        private String host;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable Integer port;
        private boolean ssl;
        @Nullable
        private String username;
        @Nullable
        private String encryptedPassword;
        @Nullable
        private String userBaseDn;
        @Nullable
        private String userSearchFilter;
        @Nullable
        private String groupBaseDn;
        @Nullable
        private String groupSearchFilter;
        private ImmutableMap.Builder<String, List<String>> roleMappings = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(LdapConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.host(instance.host());
            @org.checkerframework.checker.nullness.qual.Nullable Integer portValue = instance.port();
            if (portValue != null) {
                this.port(portValue);
            }
            this.ssl(instance.ssl());
            this.username(instance.username());
            this.encryptedPassword(instance.encryptedPassword());
            this.userBaseDn(instance.userBaseDn());
            this.userSearchFilter(instance.userSearchFilter());
            this.groupBaseDn(instance.groupBaseDn());
            this.groupSearchFilter(instance.groupSearchFilter());
            this.putAllRoleMappings(instance.roleMappings());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder host(String host) {
            this.host = Objects.requireNonNull(host, "host");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder port(@org.checkerframework.checker.nullness.qual.Nullable Integer port) {
            this.port = port;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ssl(boolean ssl) {
            this.ssl = ssl;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder username(String username) {
            this.username = Objects.requireNonNull(username, "username");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder encryptedPassword(String encryptedPassword) {
            this.encryptedPassword = Objects.requireNonNull(encryptedPassword, "encryptedPassword");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder userBaseDn(String userBaseDn) {
            this.userBaseDn = Objects.requireNonNull(userBaseDn, "userBaseDn");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder userSearchFilter(String userSearchFilter) {
            this.userSearchFilter = Objects.requireNonNull(userSearchFilter, "userSearchFilter");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder groupBaseDn(String groupBaseDn) {
            this.groupBaseDn = Objects.requireNonNull(groupBaseDn, "groupBaseDn");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder groupSearchFilter(String groupSearchFilter) {
            this.groupSearchFilter = Objects.requireNonNull(groupSearchFilter, "groupSearchFilter");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putRoleMappings(String key, List<String> value) {
            this.roleMappings.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putRoleMappings(Map.Entry<String, ? extends List<String>> entry) {
            this.roleMappings.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder roleMappings(Map<String, ? extends List<String>> entries) {
            this.roleMappings = ImmutableMap.builder();
            return this.putAllRoleMappings(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllRoleMappings(Map<String, ? extends List<String>> entries) {
            this.roleMappings.putAll(entries);
            return this;
        }

        public ImmutableLdapConfig build() {
            return new ImmutableLdapConfig(this);
        }

        private boolean sslIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="LdapConfig", generator="Immutables")
    static final class Json
    extends LdapConfig {
        @Nullable
        String host;
        @Nullable
        @org.checkerframework.checker.nullness.qual.Nullable Integer port;
        boolean ssl;
        boolean sslIsSet;
        @Nullable
        String username;
        @Nullable
        String encryptedPassword;
        @Nullable
        String userBaseDn;
        @Nullable
        String userSearchFilter;
        @Nullable
        String groupBaseDn;
        @Nullable
        String groupSearchFilter;
        @Nullable
        Map<String, List<String>> roleMappings = ImmutableMap.of();

        Json() {
        }

        @JsonProperty(value="host")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setHost(String host) {
            this.host = host;
        }

        @JsonProperty(value="port")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public void setPort(@org.checkerframework.checker.nullness.qual.Nullable Integer port) {
            this.port = port;
        }

        @JsonProperty(value="ssl")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setSsl(boolean ssl) {
            this.ssl = ssl;
            this.sslIsSet = true;
        }

        @JsonProperty(value="username")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setUsername(String username) {
            this.username = username;
        }

        @JsonProperty(value="encryptedPassword")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setEncryptedPassword(String encryptedPassword) {
            this.encryptedPassword = encryptedPassword;
        }

        @JsonProperty(value="userBaseDn")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setUserBaseDn(String userBaseDn) {
            this.userBaseDn = userBaseDn;
        }

        @JsonProperty(value="userSearchFilter")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setUserSearchFilter(String userSearchFilter) {
            this.userSearchFilter = userSearchFilter;
        }

        @JsonProperty(value="groupBaseDn")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setGroupBaseDn(String groupBaseDn) {
            this.groupBaseDn = groupBaseDn;
        }

        @JsonProperty(value="groupSearchFilter")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setGroupSearchFilter(String groupSearchFilter) {
            this.groupSearchFilter = groupSearchFilter;
        }

        @JsonProperty(value="roleMappings")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setRoleMappings(Map<String, List<String>> roleMappings) {
            this.roleMappings = roleMappings;
        }

        @Override
        public String host() {
            throw new UnsupportedOperationException();
        }

        @Override
        public @org.checkerframework.checker.nullness.qual.Nullable Integer port() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean ssl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String username() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String encryptedPassword() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String userBaseDn() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String userSearchFilter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String groupBaseDn() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String groupSearchFilter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, List<String>> roleMappings() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public String version() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public String url() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="LdapConfig", generator="Immutables")
    private final class InitShim {
        private byte hostBuildStage = 0;
        private String host;
        private byte sslBuildStage = 0;
        private boolean ssl;
        private byte usernameBuildStage = 0;
        private String username;
        private byte encryptedPasswordBuildStage = 0;
        private String encryptedPassword;
        private byte userBaseDnBuildStage = 0;
        private String userBaseDn;
        private byte userSearchFilterBuildStage = 0;
        private String userSearchFilter;
        private byte groupBaseDnBuildStage = 0;
        private String groupBaseDn;
        private byte groupSearchFilterBuildStage = 0;
        private String groupSearchFilter;
        private byte versionBuildStage = 0;
        private String version;
        private byte urlBuildStage = 0;
        private String url;

        private InitShim() {
        }

        String host() {
            if (this.hostBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hostBuildStage == 0) {
                this.hostBuildStage = (byte)-1;
                this.host = Objects.requireNonNull(ImmutableLdapConfig.super.host(), "host");
                this.hostBuildStage = 1;
            }
            return this.host;
        }

        void host(String host) {
            this.host = host;
            this.hostBuildStage = 1;
        }

        boolean ssl() {
            if (this.sslBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sslBuildStage == 0) {
                this.sslBuildStage = (byte)-1;
                this.ssl = ImmutableLdapConfig.super.ssl();
                this.sslBuildStage = 1;
            }
            return this.ssl;
        }

        void ssl(boolean ssl) {
            this.ssl = ssl;
            this.sslBuildStage = 1;
        }

        String username() {
            if (this.usernameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.usernameBuildStage == 0) {
                this.usernameBuildStage = (byte)-1;
                this.username = Objects.requireNonNull(ImmutableLdapConfig.super.username(), "username");
                this.usernameBuildStage = 1;
            }
            return this.username;
        }

        void username(String username) {
            this.username = username;
            this.usernameBuildStage = 1;
        }

        String encryptedPassword() {
            if (this.encryptedPasswordBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.encryptedPasswordBuildStage == 0) {
                this.encryptedPasswordBuildStage = (byte)-1;
                this.encryptedPassword = Objects.requireNonNull(ImmutableLdapConfig.super.encryptedPassword(), "encryptedPassword");
                this.encryptedPasswordBuildStage = 1;
            }
            return this.encryptedPassword;
        }

        void encryptedPassword(String encryptedPassword) {
            this.encryptedPassword = encryptedPassword;
            this.encryptedPasswordBuildStage = 1;
        }

        String userBaseDn() {
            if (this.userBaseDnBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.userBaseDnBuildStage == 0) {
                this.userBaseDnBuildStage = (byte)-1;
                this.userBaseDn = Objects.requireNonNull(ImmutableLdapConfig.super.userBaseDn(), "userBaseDn");
                this.userBaseDnBuildStage = 1;
            }
            return this.userBaseDn;
        }

        void userBaseDn(String userBaseDn) {
            this.userBaseDn = userBaseDn;
            this.userBaseDnBuildStage = 1;
        }

        String userSearchFilter() {
            if (this.userSearchFilterBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.userSearchFilterBuildStage == 0) {
                this.userSearchFilterBuildStage = (byte)-1;
                this.userSearchFilter = Objects.requireNonNull(ImmutableLdapConfig.super.userSearchFilter(), "userSearchFilter");
                this.userSearchFilterBuildStage = 1;
            }
            return this.userSearchFilter;
        }

        void userSearchFilter(String userSearchFilter) {
            this.userSearchFilter = userSearchFilter;
            this.userSearchFilterBuildStage = 1;
        }

        String groupBaseDn() {
            if (this.groupBaseDnBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.groupBaseDnBuildStage == 0) {
                this.groupBaseDnBuildStage = (byte)-1;
                this.groupBaseDn = Objects.requireNonNull(ImmutableLdapConfig.super.groupBaseDn(), "groupBaseDn");
                this.groupBaseDnBuildStage = 1;
            }
            return this.groupBaseDn;
        }

        void groupBaseDn(String groupBaseDn) {
            this.groupBaseDn = groupBaseDn;
            this.groupBaseDnBuildStage = 1;
        }

        String groupSearchFilter() {
            if (this.groupSearchFilterBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.groupSearchFilterBuildStage == 0) {
                this.groupSearchFilterBuildStage = (byte)-1;
                this.groupSearchFilter = Objects.requireNonNull(ImmutableLdapConfig.super.groupSearchFilter(), "groupSearchFilter");
                this.groupSearchFilterBuildStage = 1;
            }
            return this.groupSearchFilter;
        }

        void groupSearchFilter(String groupSearchFilter) {
            this.groupSearchFilter = groupSearchFilter;
            this.groupSearchFilterBuildStage = 1;
        }

        String version() {
            if (this.versionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.versionBuildStage == 0) {
                this.versionBuildStage = (byte)-1;
                this.version = Objects.requireNonNull(ImmutableLdapConfig.super.version(), "version");
                this.versionBuildStage = 1;
            }
            return this.version;
        }

        String url() {
            if (this.urlBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.urlBuildStage == 0) {
                this.urlBuildStage = (byte)-1;
                this.url = Objects.requireNonNull(ImmutableLdapConfig.super.url(), "url");
                this.urlBuildStage = 1;
            }
            return this.url;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.hostBuildStage == -1) {
                attributes.add("host");
            }
            if (this.sslBuildStage == -1) {
                attributes.add("ssl");
            }
            if (this.usernameBuildStage == -1) {
                attributes.add("username");
            }
            if (this.encryptedPasswordBuildStage == -1) {
                attributes.add("encryptedPassword");
            }
            if (this.userBaseDnBuildStage == -1) {
                attributes.add("userBaseDn");
            }
            if (this.userSearchFilterBuildStage == -1) {
                attributes.add("userSearchFilter");
            }
            if (this.groupBaseDnBuildStage == -1) {
                attributes.add("groupBaseDn");
            }
            if (this.groupSearchFilterBuildStage == -1) {
                attributes.add("groupSearchFilter");
            }
            if (this.versionBuildStage == -1) {
                attributes.add("version");
            }
            if (this.urlBuildStage == -1) {
                attributes.add("url");
            }
            return "Cannot build LdapConfig, attribute initializers form cycle " + attributes;
        }
    }
}

