/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.repo;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.tainting.qual.Untainted;
import org.glowroot.agent.embedded.repo.AlertingDisabledDao;
import org.glowroot.agent.embedded.repo.ConfigRepositoryImpl;
import org.glowroot.agent.embedded.repo.EnvironmentDao;
import org.glowroot.agent.embedded.repo.FullQueryTextDao;
import org.glowroot.agent.embedded.repo.GaugeIdDao;
import org.glowroot.agent.embedded.repo.GaugeNameDao;
import org.glowroot.agent.embedded.repo.GaugeValueDao;
import org.glowroot.agent.embedded.repo.TraceAttributeNameDao;
import org.glowroot.agent.embedded.repo.TransactionTypeDao;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.CassandraProfile;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ImmutableTraceCount;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ImmutableTraceCounts;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ImmutableTraceOverallCount;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.RepoAdmin;
import org.glowroot.agent.embedded.util.CappedDatabase;
import org.glowroot.agent.embedded.util.DataSource;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.base.Stopwatch;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.org.glowroot.common.util.Clock;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.CollectorServiceOuterClass;

class RepoAdminImpl
implements RepoAdmin {
    private final DataSource dataSource;
    private final List<CappedDatabase> rollupCappedDatabases;
    private final CappedDatabase traceCappedDatabase;
    private final ConfigRepositoryImpl configRepository;
    private final AlertingDisabledDao alertingDisabledDao;
    private final EnvironmentDao environmentDao;
    private final GaugeIdDao gaugeIdDao;
    private final GaugeNameDao gaugeNameDao;
    private final GaugeValueDao gaugeValueDao;
    private final TransactionTypeDao transactionTypeDao;
    private final FullQueryTextDao fullQueryTextDao;
    private final TraceAttributeNameDao traceAttributeNameDao;
    private final Clock clock;

    RepoAdminImpl(DataSource dataSource, List<CappedDatabase> rollupCappedDatabases, CappedDatabase traceCappedDatabase, ConfigRepositoryImpl configRepository, AlertingDisabledDao alertingDisabledDao, EnvironmentDao environmentDao, GaugeIdDao gaugeIdDao, GaugeNameDao gaugeNameDao, GaugeValueDao gaugeValueDao, TransactionTypeDao transactionTypeDao, FullQueryTextDao fullQueryTextDao, TraceAttributeNameDao traceAttributeNameDao, Clock clock) {
        this.dataSource = dataSource;
        this.rollupCappedDatabases = rollupCappedDatabases;
        this.traceCappedDatabase = traceCappedDatabase;
        this.configRepository = configRepository;
        this.alertingDisabledDao = alertingDisabledDao;
        this.environmentDao = environmentDao;
        this.gaugeIdDao = gaugeIdDao;
        this.gaugeNameDao = gaugeNameDao;
        this.gaugeValueDao = gaugeValueDao;
        this.transactionTypeDao = transactionTypeDao;
        this.fullQueryTextDao = fullQueryTextDao;
        this.traceAttributeNameDao = traceAttributeNameDao;
        this.clock = clock;
    }

    @Override
    public void runHealthCheck() throws Exception {
        long now = this.clock.currentTimeMillis();
        this.dataSource.queryForLong("select count(*) from aggregate_tt_rollup_0 where capture_time > ? and capture_time < ?", now - TimeUnit.HOURS.toMillis(4L), now);
    }

    @Override
    public void deleteAllData() throws Exception {
        CollectorServiceOuterClass.InitMessage.Environment environment = this.environmentDao.read("", CassandraProfile.web).toCompletableFuture().join();
        this.dataSource.deleteAll();
        this.alertingDisabledDao.reinitAfterDeletingDatabase();
        this.environmentDao.reinitAfterDeletingDatabase();
        this.gaugeIdDao.invalidateCache();
        this.gaugeNameDao.invalidateCache();
        this.gaugeValueDao.reinitAfterDeletingDatabase();
        this.transactionTypeDao.invalidateCache();
        this.fullQueryTextDao.invalidateCache();
        this.traceAttributeNameDao.invalidateCache();
        if (environment != null) {
            this.environmentDao.store(environment);
        }
    }

    @Override
    public void defragH2Data() throws Exception {
        this.dataSource.defrag();
    }

    @Override
    public void compactH2Data() throws Exception {
        this.dataSource.compact();
    }

    @Override
    public long getH2DataFileSize() {
        return this.dataSource.getH2DataFileSize();
    }

    @Override
    public List<RepoAdmin.H2Table> analyzeH2DiskSpace() throws Exception {
        return this.dataSource.analyzeH2DiskSpace();
    }

    @Override
    public RepoAdmin.TraceCounts analyzeTraceCounts() throws Exception {
        return this.dataSource.suppressQueryTimeout(new Callable<RepoAdmin.TraceCounts>(){

            @Override
            public RepoAdmin.TraceCounts call() throws Exception {
                ImmutableTraceCounts.Builder builder = ImmutableTraceCounts.builder();
                Stopwatch stopwatch = Stopwatch.createStarted();
                builder.addAllOverallCounts((Iterable<? extends RepoAdmin.TraceOverallCount>)RepoAdminImpl.this.dataSource.query(new TraceOverallCountQuery()));
                TimeUnit.MILLISECONDS.sleep(stopwatch.elapsed(TimeUnit.MILLISECONDS) / 10L);
                builder.addAllCounts((Iterable<? extends RepoAdmin.TraceCount>)RepoAdminImpl.this.dataSource.query(new TraceCountQuery()));
                return builder.build();
            }
        });
    }

    @Override
    public void resizeIfNeeded() throws Exception {
        for (int i = 0; i < this.rollupCappedDatabases.size(); ++i) {
            this.rollupCappedDatabases.get(i).resize((Integer)this.configRepository.getEmbeddedStorageConfig().rollupCappedDatabaseSizesMb().get(i) * 1024);
        }
        this.traceCappedDatabase.resize(this.configRepository.getEmbeddedStorageConfig().traceCappedDatabaseSizeMb() * 1024);
    }

    @Override
    public int updateCassandraTwcsWindowSizes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<RepoAdmin.CassandraWriteTotals> getCassandraWriteTotalsPerTable(int limit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<RepoAdmin.CassandraWriteTotals> getCassandraWriteTotalsPerAgentRollup(String tableName, int limit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<RepoAdmin.CassandraWriteTotals> getCassandraWriteTotalsPerTransactionType(String tableName, String agentRollupId, int limit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<RepoAdmin.CassandraWriteTotals> getCassandraWriteTotalsPerTransactionName(String tableName, String agentRollupId, String transactionType, int limit) {
        throw new UnsupportedOperationException();
    }

    private static class TraceCountQuery
    implements DataSource.JdbcQuery<List<RepoAdmin.TraceCount>> {
        private TraceCountQuery() {
        }

        @Override
        public @Untainted String getSql() {
            return "select transaction_type, transaction_name, count(*), count(case when error then 1 end) from trace group by transaction_type, transaction_name order by count(*) desc limit 50";
        }

        @Override
        public void bind(PreparedStatement preparedStatement) {
        }

        @Override
        public List<RepoAdmin.TraceCount> processResultSet(ResultSet resultSet) throws Exception {
            ArrayList traceCounts = Lists.newArrayList();
            while (resultSet.next()) {
                int i = 1;
                traceCounts.add(ImmutableTraceCount.builder().transactionType((String)Preconditions.checkNotNull((Object)resultSet.getString(i++))).transactionName((String)Preconditions.checkNotNull((Object)resultSet.getString(i++))).count(resultSet.getLong(i++)).errorCount(resultSet.getLong(i++)).build());
            }
            return traceCounts;
        }

        @Override
        public List<RepoAdmin.TraceCount> valueIfDataSourceClosed() {
            return ImmutableList.of();
        }
    }

    private static class TraceOverallCountQuery
    implements DataSource.JdbcQuery<List<RepoAdmin.TraceOverallCount>> {
        private TraceOverallCountQuery() {
        }

        @Override
        public @Untainted String getSql() {
            return "select transaction_type, count(*), count(case when error then 1 end) from trace group by transaction_type order by count(*) desc";
        }

        @Override
        public void bind(PreparedStatement preparedStatement) {
        }

        @Override
        public List<RepoAdmin.TraceOverallCount> processResultSet(ResultSet resultSet) throws Exception {
            ArrayList traceCounts = Lists.newArrayList();
            while (resultSet.next()) {
                int i = 1;
                traceCounts.add(ImmutableTraceOverallCount.builder().transactionType((String)Preconditions.checkNotNull((Object)resultSet.getString(i++))).count(resultSet.getLong(i++)).errorCount(resultSet.getLong(i++)).build());
            }
            return traceCounts;
        }

        @Override
        public List<RepoAdmin.TraceOverallCount> valueIfDataSourceClosed() {
            return ImmutableList.of();
        }
    }
}

