/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.org.glowroot.common.model;

import java.util.List;
import java.util.Map;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Maps;
import org.glowroot.agent.shaded.com.google.common.collect.Ordering;
import org.glowroot.agent.shaded.com.google.common.primitives.Doubles;
import org.glowroot.agent.shaded.com.google.common.primitives.Longs;
import org.glowroot.agent.shaded.org.glowroot.common.model.ImmutableTransactionNameErrorSummary;
import org.glowroot.agent.shaded.org.glowroot.common.model.Result;
import org.immutables.value.Value;

public class TransactionNameErrorSummaryCollector {
    static final Ordering<TransactionNameErrorSummary> orderingByErrorCountDesc = new Ordering<TransactionNameErrorSummary>(){

        @Override
        public int compare(TransactionNameErrorSummary left, TransactionNameErrorSummary right) {
            return Longs.compare(right.errorCount(), left.errorCount());
        }
    };
    static final Ordering<TransactionNameErrorSummary> orderingByErrorRateDesc = new Ordering<TransactionNameErrorSummary>(){

        @Override
        public int compare(TransactionNameErrorSummary left, TransactionNameErrorSummary right) {
            return Doubles.compare((double)right.errorCount() / (double)right.transactionCount(), (double)left.errorCount() / (double)left.transactionCount());
        }
    };
    private final Map<String, MutableTransactionNameErrorSummary> transactionNameErrorSummaries = Maps.newHashMap();
    private long lastCaptureTime;

    public void collect(String transactionName, long errorCount, long transactionCount, long captureTime) {
        MutableTransactionNameErrorSummary mtes = this.transactionNameErrorSummaries.get(transactionName);
        if (mtes == null) {
            mtes = new MutableTransactionNameErrorSummary();
            this.transactionNameErrorSummaries.put(transactionName, mtes);
        }
        mtes.errorCount += errorCount;
        mtes.transactionCount += transactionCount;
        this.lastCaptureTime = Math.max(this.lastCaptureTime, captureTime);
    }

    public long getLastCaptureTime() {
        return this.lastCaptureTime;
    }

    public Result<TransactionNameErrorSummary> getResult(ErrorSummarySortOrder sortOrder, int limit) {
        List<TransactionNameErrorSummary> summaries = Lists.newArrayList();
        for (Map.Entry<String, MutableTransactionNameErrorSummary> entry : this.transactionNameErrorSummaries.entrySet()) {
            summaries.add(ImmutableTransactionNameErrorSummary.builder().transactionName(entry.getKey()).errorCount(entry.getValue().errorCount).transactionCount(entry.getValue().transactionCount).build());
        }
        if ((summaries = TransactionNameErrorSummaryCollector.sortTransactionNameErrorSummaries(summaries, sortOrder)).size() > limit) {
            return new Result<TransactionNameErrorSummary>(summaries.subList(0, limit), true);
        }
        return new Result<TransactionNameErrorSummary>(summaries, false);
    }

    private static List<TransactionNameErrorSummary> sortTransactionNameErrorSummaries(Iterable<TransactionNameErrorSummary> errorSummaries, ErrorSummarySortOrder sortOrder) {
        switch (sortOrder) {
            case ERROR_COUNT: {
                return orderingByErrorCountDesc.immutableSortedCopy(errorSummaries);
            }
            case ERROR_RATE: {
                return orderingByErrorRateDesc.immutableSortedCopy(errorSummaries);
            }
        }
        throw new AssertionError((Object)("Unexpected sort order: " + (Object)((Object)sortOrder)));
    }

    @Value.Immutable
    public static interface TransactionNameErrorSummary {
        public String transactionName();

        public long errorCount();

        public long transactionCount();
    }

    public static enum ErrorSummarySortOrder {
        ERROR_COUNT,
        ERROR_RATE;

    }

    private static class MutableTransactionNameErrorSummary {
        private long errorCount;
        private long transactionCount;

        private MutableTransactionNameErrorSummary() {
        }
    }
}

