/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.grpc;

import java.util.concurrent.Executor;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.io.grpc.CallCredentials;
import org.glowroot.agent.shaded.io.grpc.Context;

public final class CompositeCallCredentials
extends CallCredentials {
    private final CallCredentials credentials1;
    private final CallCredentials credentials2;

    public CompositeCallCredentials(CallCredentials creds1, CallCredentials creds2) {
        this.credentials1 = Preconditions.checkNotNull(creds1, "creds1");
        this.credentials2 = Preconditions.checkNotNull(creds2, "creds2");
    }

    @Override
    public void applyRequestMetadata(CallCredentials.RequestInfo requestInfo, Executor appExecutor, CallCredentials.MetadataApplier applier) {
        this.credentials1.applyRequestMetadata(requestInfo, appExecutor, new WrappingMetadataApplier(requestInfo, appExecutor, applier, Context.current()));
    }

    private final class WrappingMetadataApplier
    extends CallCredentials.MetadataApplier {
        private final CallCredentials.RequestInfo requestInfo;
        private final Executor appExecutor;
        private final CallCredentials.MetadataApplier delegate;
        private final Context context;

        public WrappingMetadataApplier(CallCredentials.RequestInfo requestInfo, Executor appExecutor, CallCredentials.MetadataApplier delegate, Context context) {
            this.requestInfo = requestInfo;
            this.appExecutor = appExecutor;
            this.delegate = Preconditions.checkNotNull(delegate, "delegate");
            this.context = Preconditions.checkNotNull(context, "context");
        }
    }
}

