/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.jdbc;

import org.glowroot.agent.plugin.api.Agent;
import org.glowroot.agent.plugin.api.Logger;
import org.glowroot.agent.plugin.api.QueryEntry;
import org.glowroot.agent.plugin.api.Timer;
import org.glowroot.agent.plugin.api.config.BooleanProperty;
import org.glowroot.agent.plugin.api.config.ConfigService;
import org.glowroot.agent.plugin.api.weaving.BindReceiver;
import org.glowroot.agent.plugin.api.weaving.BindReturn;
import org.glowroot.agent.plugin.api.weaving.BindTraveler;
import org.glowroot.agent.plugin.api.weaving.IsEnabled;
import org.glowroot.agent.plugin.api.weaving.OnAfter;
import org.glowroot.agent.plugin.api.weaving.OnBefore;
import org.glowroot.agent.plugin.api.weaving.OnReturn;
import org.glowroot.agent.plugin.api.weaving.Pointcut;
import org.glowroot.agent.plugin.api.weaving.Shim;
import org.glowroot.agent.plugin.jdbc.StatementAspect;
import org.glowroot.agent.plugin.jdbc.StatementMirror;

public class ResultSetAspect {
    private static final Logger logger = Logger.getLogger(ResultSetAspect.class);
    private static final ConfigService configService = Agent.getConfigService("jdbc");

    private static boolean isEnabledCommon(StatementAspect.HasStatementMirrorMixin resultSet) {
        StatementMirror mirror = resultSet.glowroot$getStatementMirror();
        return mirror != null && mirror.getLastQueryEntry() != null;
    }

    private static Timer onBeforeCommon(StatementAspect.HasStatementMirrorMixin resultSet) {
        StatementMirror mirror = resultSet.glowroot$getStatementMirror();
        QueryEntry lastQueryEntry = mirror.getLastQueryEntry();
        return lastQueryEntry.extend();
    }

    static /* synthetic */ ConfigService access$000() {
        return configService;
    }

    @Pointcut(className="java.sql.ResultSet", methodName="get*", methodParameterTypes={"java.lang.String", ".."}, nestingGroup="jdbc")
    public static class ValueAdvice2 {
        private static final BooleanProperty timerEnabled = ResultSetAspect.access$000().getBooleanProperty("captureResultSetGet");

        @IsEnabled
        public static boolean isEnabled(@BindReceiver StatementAspect.HasStatementMirrorMixin resultSet) {
            return timerEnabled.value() && ResultSetAspect.isEnabledCommon(resultSet);
        }

        @OnBefore
        public static Timer onBefore(@BindReceiver StatementAspect.HasStatementMirrorMixin resultSet) {
            return ResultSetAspect.onBeforeCommon(resultSet);
        }

        @OnAfter
        public static void onAfter(@BindTraveler Timer timer) {
            timer.stop();
        }
    }

    @Pointcut(className="java.sql.ResultSet", methodName="get*", methodParameterTypes={"int", ".."}, nestingGroup="jdbc")
    public static class ValueAdvice {
        private static final BooleanProperty timerEnabled = ResultSetAspect.access$000().getBooleanProperty("captureResultSetGet");

        @IsEnabled
        public static boolean isEnabled(@BindReceiver StatementAspect.HasStatementMirrorMixin resultSet) {
            return timerEnabled.value() && ResultSetAspect.isEnabledCommon(resultSet);
        }

        @OnBefore
        public static Timer onBefore(@BindReceiver StatementAspect.HasStatementMirrorMixin resultSet) {
            return ResultSetAspect.onBeforeCommon(resultSet);
        }

        @OnAfter
        public static void onAfter(@BindTraveler Timer timer) {
            timer.stop();
        }
    }

    @Pointcut(className="java.sql.ResultSet", methodName="previous|relative|absolute|first|last", methodParameterTypes={".."}, nestingGroup="jdbc")
    public static class NavigateAdvice {
        private static final BooleanProperty timerEnabled = ResultSetAspect.access$000().getBooleanProperty("captureResultSetNavigate");

        @IsEnabled
        public static boolean isEnabled(@BindReceiver StatementAspect.HasStatementMirrorMixin resultSet) {
            return timerEnabled.value() && ResultSetAspect.isEnabledCommon(resultSet);
        }

        @OnBefore
        public static Timer onBefore(@BindReceiver StatementAspect.HasStatementMirrorMixin resultSet) {
            return ResultSetAspect.onBeforeCommon(resultSet);
        }

        @OnReturn
        public static void onReturn(@BindReceiver StatementAspect.HasStatementMirrorMixin resultSet) {
            try {
                StatementMirror mirror = resultSet.glowroot$getStatementMirror();
                if (mirror == null) {
                    return;
                }
                QueryEntry lastQueryEntry = mirror.getLastQueryEntry();
                if (lastQueryEntry == null) {
                    return;
                }
                lastQueryEntry.setCurrRow(((ResultSet)((Object)resultSet)).getRow());
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), e);
            }
        }

        @OnAfter
        public static void onAfter(@BindTraveler Timer timer) {
            timer.stop();
        }
    }

    @Pointcut(className="java.sql.ResultSet", methodName="next", methodParameterTypes={}, nestingGroup="jdbc")
    public static class NextAdvice {
        private static final BooleanProperty timerEnabled = ResultSetAspect.access$000().getBooleanProperty("captureResultSetNavigate");

        @IsEnabled
        public static boolean isEnabled(@BindReceiver StatementAspect.HasStatementMirrorMixin resultSet) {
            return timerEnabled.value() && ResultSetAspect.isEnabledCommon(resultSet);
        }

        @OnBefore
        public static Timer onBefore(@BindReceiver StatementAspect.HasStatementMirrorMixin resultSet) {
            return ResultSetAspect.onBeforeCommon(resultSet);
        }

        @OnReturn
        public static void onReturn(@BindReturn boolean currentRowValid, @BindReceiver StatementAspect.HasStatementMirrorMixin resultSet) {
            StatementMirror mirror = resultSet.glowroot$getStatementMirror();
            if (mirror == null) {
                return;
            }
            QueryEntry lastQueryEntry = mirror.getLastQueryEntry();
            if (lastQueryEntry == null) {
                return;
            }
            if (currentRowValid) {
                lastQueryEntry.incrementCurrRow();
            } else {
                lastQueryEntry.rowNavigationAttempted();
            }
        }

        @OnAfter
        public static void onAfter(@BindTraveler Timer timer) {
            timer.stop();
        }
    }

    @Shim(value={"java.sql.ResultSet"})
    public static interface ResultSet {
        public int getRow();
    }
}

