/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.live;

import java.io.File;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.live.ClasspathCache;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ClasspathCache.Location", generator="Immutables")
@Immutable
final class ImmutableLocation
implements ClasspathCache.Location {
    private final @org.checkerframework.checker.nullness.qual.Nullable File directory;
    private final @org.checkerframework.checker.nullness.qual.Nullable File jarFile;
    private final @org.checkerframework.checker.nullness.qual.Nullable String jarFileInsideJarFile;
    private final @org.checkerframework.checker.nullness.qual.Nullable String directoryInsideJarFile;

    private ImmutableLocation(@org.checkerframework.checker.nullness.qual.Nullable File directory, @org.checkerframework.checker.nullness.qual.Nullable File jarFile, @org.checkerframework.checker.nullness.qual.Nullable String jarFileInsideJarFile, @org.checkerframework.checker.nullness.qual.Nullable String directoryInsideJarFile) {
        this.directory = directory;
        this.jarFile = jarFile;
        this.jarFileInsideJarFile = jarFileInsideJarFile;
        this.directoryInsideJarFile = directoryInsideJarFile;
    }

    @Override
    @JsonProperty(value="directory")
    public @org.checkerframework.checker.nullness.qual.Nullable File directory() {
        return this.directory;
    }

    @Override
    @JsonProperty(value="jarFile")
    public @org.checkerframework.checker.nullness.qual.Nullable File jarFile() {
        return this.jarFile;
    }

    @Override
    @JsonProperty(value="jarFileInsideJarFile")
    public @org.checkerframework.checker.nullness.qual.Nullable String jarFileInsideJarFile() {
        return this.jarFileInsideJarFile;
    }

    @Override
    @JsonProperty(value="directoryInsideJarFile")
    public @org.checkerframework.checker.nullness.qual.Nullable String directoryInsideJarFile() {
        return this.directoryInsideJarFile;
    }

    public final ImmutableLocation withDirectory(@org.checkerframework.checker.nullness.qual.Nullable File value) {
        if (this.directory == value) {
            return this;
        }
        return new ImmutableLocation(value, this.jarFile, this.jarFileInsideJarFile, this.directoryInsideJarFile);
    }

    public final ImmutableLocation withJarFile(@org.checkerframework.checker.nullness.qual.Nullable File value) {
        if (this.jarFile == value) {
            return this;
        }
        return new ImmutableLocation(this.directory, value, this.jarFileInsideJarFile, this.directoryInsideJarFile);
    }

    public final ImmutableLocation withJarFileInsideJarFile(@org.checkerframework.checker.nullness.qual.Nullable String value) {
        if (Objects.equals(this.jarFileInsideJarFile, value)) {
            return this;
        }
        return new ImmutableLocation(this.directory, this.jarFile, value, this.directoryInsideJarFile);
    }

    public final ImmutableLocation withDirectoryInsideJarFile(@org.checkerframework.checker.nullness.qual.Nullable String value) {
        if (Objects.equals(this.directoryInsideJarFile, value)) {
            return this;
        }
        return new ImmutableLocation(this.directory, this.jarFile, this.jarFileInsideJarFile, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLocation && this.equalTo(0, (ImmutableLocation)another);
    }

    private boolean equalTo(int synthetic, ImmutableLocation another) {
        return Objects.equals(this.directory, another.directory) && Objects.equals(this.jarFile, another.jarFile) && Objects.equals(this.jarFileInsideJarFile, another.jarFileInsideJarFile) && Objects.equals(this.directoryInsideJarFile, another.directoryInsideJarFile);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.directory);
        h += (h << 5) + Objects.hashCode(this.jarFile);
        h += (h << 5) + Objects.hashCode(this.jarFileInsideJarFile);
        h += (h << 5) + Objects.hashCode(this.directoryInsideJarFile);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("Location").omitNullValues().add("directory", this.directory).add("jarFile", this.jarFile).add("jarFileInsideJarFile", this.jarFileInsideJarFile).add("directoryInsideJarFile", this.directoryInsideJarFile).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableLocation fromJson(Json json) {
        Builder builder = ImmutableLocation.builder();
        if (json.directory != null) {
            builder.directory(json.directory);
        }
        if (json.jarFile != null) {
            builder.jarFile(json.jarFile);
        }
        if (json.jarFileInsideJarFile != null) {
            builder.jarFileInsideJarFile(json.jarFileInsideJarFile);
        }
        if (json.directoryInsideJarFile != null) {
            builder.directoryInsideJarFile(json.directoryInsideJarFile);
        }
        return builder.build();
    }

    public static ImmutableLocation copyOf(ClasspathCache.Location instance) {
        if (instance instanceof ImmutableLocation) {
            return (ImmutableLocation)instance;
        }
        return ImmutableLocation.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ClasspathCache.Location", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable File directory;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable File jarFile;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable String jarFileInsideJarFile;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable String directoryInsideJarFile;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(ClasspathCache.Location instance) {
            String directoryInsideJarFileValue;
            String jarFileInsideJarFileValue;
            File jarFileValue;
            Objects.requireNonNull(instance, "instance");
            @org.checkerframework.checker.nullness.qual.Nullable File directoryValue = instance.directory();
            if (directoryValue != null) {
                this.directory(directoryValue);
            }
            if ((jarFileValue = instance.jarFile()) != null) {
                this.jarFile(jarFileValue);
            }
            if ((jarFileInsideJarFileValue = instance.jarFileInsideJarFile()) != null) {
                this.jarFileInsideJarFile(jarFileInsideJarFileValue);
            }
            if ((directoryInsideJarFileValue = instance.directoryInsideJarFile()) != null) {
                this.directoryInsideJarFile(directoryInsideJarFileValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder directory(@org.checkerframework.checker.nullness.qual.Nullable File directory) {
            this.directory = directory;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder jarFile(@org.checkerframework.checker.nullness.qual.Nullable File jarFile) {
            this.jarFile = jarFile;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder jarFileInsideJarFile(@org.checkerframework.checker.nullness.qual.Nullable String jarFileInsideJarFile) {
            this.jarFileInsideJarFile = jarFileInsideJarFile;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder directoryInsideJarFile(@org.checkerframework.checker.nullness.qual.Nullable String directoryInsideJarFile) {
            this.directoryInsideJarFile = directoryInsideJarFile;
            return this;
        }

        public ImmutableLocation build() {
            return new ImmutableLocation(this.directory, this.jarFile, this.jarFileInsideJarFile, this.directoryInsideJarFile);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ClasspathCache.Location", generator="Immutables")
    static final class Json
    implements ClasspathCache.Location {
        @Nullable
        @org.checkerframework.checker.nullness.qual.Nullable File directory;
        @Nullable
        @org.checkerframework.checker.nullness.qual.Nullable File jarFile;
        @Nullable
        @org.checkerframework.checker.nullness.qual.Nullable String jarFileInsideJarFile;
        @Nullable
        @org.checkerframework.checker.nullness.qual.Nullable String directoryInsideJarFile;

        Json() {
        }

        @JsonProperty(value="directory")
        public void setDirectory(@org.checkerframework.checker.nullness.qual.Nullable File directory) {
            this.directory = directory;
        }

        @JsonProperty(value="jarFile")
        public void setJarFile(@org.checkerframework.checker.nullness.qual.Nullable File jarFile) {
            this.jarFile = jarFile;
        }

        @JsonProperty(value="jarFileInsideJarFile")
        public void setJarFileInsideJarFile(@org.checkerframework.checker.nullness.qual.Nullable String jarFileInsideJarFile) {
            this.jarFileInsideJarFile = jarFileInsideJarFile;
        }

        @JsonProperty(value="directoryInsideJarFile")
        public void setDirectoryInsideJarFile(@org.checkerframework.checker.nullness.qual.Nullable String directoryInsideJarFile) {
            this.directoryInsideJarFile = directoryInsideJarFile;
        }

        @Override
        public @org.checkerframework.checker.nullness.qual.Nullable File directory() {
            throw new UnsupportedOperationException();
        }

        @Override
        public @org.checkerframework.checker.nullness.qual.Nullable File jarFile() {
            throw new UnsupportedOperationException();
        }

        @Override
        public @org.checkerframework.checker.nullness.qual.Nullable String jarFileInsideJarFile() {
            throw new UnsupportedOperationException();
        }

        @Override
        public @org.checkerframework.checker.nullness.qual.Nullable String directoryInsideJarFile() {
            throw new UnsupportedOperationException();
        }
    }
}

