/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.glowroot.agent.impl.Transaction;
import org.glowroot.agent.model.AggregatedTimer;
import org.glowroot.agent.model.AsyncQueryData;
import org.glowroot.agent.model.AsyncTimer;
import org.glowroot.agent.model.ImmutableTransactionTimerSnapshot;
import org.glowroot.agent.model.QueryCollector;
import org.glowroot.agent.model.ServiceCallCollector;
import org.glowroot.agent.model.TimerNameImpl;
import org.glowroot.agent.model.TransactionTimer;
import org.glowroot.agent.plugin.api.TimerName;
import org.glowroot.agent.shaded.com.google.common.base.Ticker;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Maps;

class AsyncComponents {
    private static final String LIMIT_EXCEEDED_BUCKET = "LIMIT EXCEEDED BUCKET";
    private final Object asyncTimerLock = new Object();
    @GuardedBy(value="asyncTimerLock")
    private @MonotonicNonNull List<AsyncTimer> asyncTimers;
    @GuardedBy(value="asyncTimerLock")
    private @MonotonicNonNull Map<String, MergedAsyncTimer> alreadyMergedAsyncTimers;
    private final int maxQueryAggregates;
    private final int maxServiceCallAggregates;
    private final Ticker ticker;
    private final Map<String, Map<String, AsyncQueryData>> asyncQueries = Maps.newConcurrentMap();
    private final Map<String, Map<String, AsyncQueryData>> asyncServiceCalls = Maps.newConcurrentMap();
    private volatile int queryAggregateCounter;
    private volatile int serviceCallAggregateCounter;

    AsyncComponents(int maxQueryAggregates, int maxServiceCallAggregates, Ticker ticker) {
        this.maxQueryAggregates = maxQueryAggregates;
        this.maxServiceCallAggregates = maxServiceCallAggregates;
        this.ticker = ticker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeAsyncTimersInto(Transaction.RootTimerCollector rootTimers) {
        Object object = this.asyncTimerLock;
        synchronized (object) {
            if (this.asyncTimers == null) {
                return;
            }
            if (this.alreadyMergedAsyncTimers != null) {
                for (MergedAsyncTimer alreadyMergedAsyncTimer : this.alreadyMergedAsyncTimers.values()) {
                    rootTimers.mergeRootTimer(alreadyMergedAsyncTimer);
                }
            }
            for (AsyncTimer asyncTimer : this.asyncTimers) {
                rootTimers.mergeRootTimer(asyncTimer);
            }
        }
    }

    void mergeQueriesInto(QueryCollector collector) {
        for (Map.Entry<String, Map<String, AsyncQueryData>> outerEntry : this.asyncQueries.entrySet()) {
            String queryType = outerEntry.getKey();
            for (Map.Entry<String, AsyncQueryData> innerEntry : outerEntry.getValue().entrySet()) {
                AsyncQueryData queryData = innerEntry.getValue();
                collector.mergeQuery(queryType, queryData.getQueryText(), queryData.getTotalDurationNanos(this.ticker), queryData.getExecutionCount(), queryData.hasTotalRows(), queryData.getTotalRows(), queryData.isActive());
            }
        }
    }

    void mergeServiceCallsInto(ServiceCallCollector collector) {
        for (Map.Entry<String, Map<String, AsyncQueryData>> outerEntry : this.asyncServiceCalls.entrySet()) {
            String serviceCallType = outerEntry.getKey();
            for (Map.Entry<String, AsyncQueryData> innerEntry : outerEntry.getValue().entrySet()) {
                AsyncQueryData queryData = innerEntry.getValue();
                collector.mergeServiceCall(serviceCallType, queryData.getQueryText(), queryData.getTotalDurationNanos(this.ticker), queryData.getExecutionCount());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AsyncTimer startAsyncTimer(TimerName asyncTimerName, long startTick) {
        AsyncTimer asyncTimer = new AsyncTimer((TimerNameImpl)asyncTimerName, startTick);
        Object object = this.asyncTimerLock;
        synchronized (object) {
            if (this.asyncTimers == null) {
                this.asyncTimers = Lists.newArrayList();
            }
            if (this.asyncTimers.size() >= 1000) {
                if (this.alreadyMergedAsyncTimers == null) {
                    this.alreadyMergedAsyncTimers = Maps.newHashMap();
                }
                ArrayList<AsyncTimer> activeAsyncTimers = Lists.newArrayList();
                for (AsyncTimer loopAsyncTimer : this.asyncTimers) {
                    if (loopAsyncTimer.active()) {
                        activeAsyncTimers.add(loopAsyncTimer);
                        continue;
                    }
                    MergedAsyncTimer aggregateAsyncTimer = this.alreadyMergedAsyncTimers.get(loopAsyncTimer.getName());
                    if (aggregateAsyncTimer == null) {
                        aggregateAsyncTimer = new MergedAsyncTimer(loopAsyncTimer.getName());
                        this.alreadyMergedAsyncTimers.put(loopAsyncTimer.getName(), aggregateAsyncTimer);
                    }
                    aggregateAsyncTimer.totalNanos += loopAsyncTimer.getTotalNanos();
                    aggregateAsyncTimer.count += loopAsyncTimer.getCount();
                }
                this.asyncTimers = activeAsyncTimers;
            }
            this.asyncTimers.add(asyncTimer);
        }
        return asyncTimer;
    }

    AsyncQueryData getOrCreateAsyncQueryData(String queryType, String queryText, boolean bypassLimit) {
        AsyncQueryData queryData;
        Map<String, AsyncQueryData> queriesForType = this.asyncQueries.get(queryType);
        if (queriesForType == null) {
            queriesForType = Maps.newConcurrentMap();
            this.asyncQueries.put(queryType, queriesForType);
        }
        if ((queryData = queriesForType.get(queryText)) == null) {
            queryData = this.createQueryData(queriesForType, queryText, bypassLimit);
            queriesForType.put(queryText, queryData);
        }
        return queryData;
    }

    private AsyncQueryData createQueryData(Map<String, AsyncQueryData> queriesForType, String queryText, boolean bypassLimit) {
        if (this.allowAnotherQueryAggregate(bypassLimit)) {
            return AsyncComponents.createQueryData(queriesForType, queryText);
        }
        AsyncQueryData limitExceededBucket = queriesForType.get(LIMIT_EXCEEDED_BUCKET);
        if (limitExceededBucket == null) {
            limitExceededBucket = AsyncComponents.createQueryData(queriesForType, LIMIT_EXCEEDED_BUCKET);
        }
        return new AsyncQueryData(queryText, limitExceededBucket);
    }

    AsyncQueryData getOrCreateAsyncServiceCallData(String serviceCallType, String serviceCallText, boolean bypassLimit) {
        AsyncQueryData serviceCallData;
        Map<String, AsyncQueryData> serviceCallsForType = this.asyncServiceCalls.get(serviceCallType);
        if (serviceCallsForType == null) {
            serviceCallsForType = Maps.newConcurrentMap();
            this.asyncServiceCalls.put(serviceCallType, serviceCallsForType);
        }
        if ((serviceCallData = serviceCallsForType.get(serviceCallText)) == null) {
            serviceCallData = this.createServiceCallData(serviceCallsForType, serviceCallText, bypassLimit);
            serviceCallsForType.put(serviceCallText, serviceCallData);
        }
        return serviceCallData;
    }

    private AsyncQueryData createServiceCallData(Map<String, AsyncQueryData> serviceCallsForType, String serviceCallText, boolean bypassLimit) {
        if (this.allowAnotherServiceCallAggregate(bypassLimit)) {
            return AsyncComponents.createServiceCallData(serviceCallsForType, serviceCallText);
        }
        AsyncQueryData limitExceededBucket = serviceCallsForType.get(LIMIT_EXCEEDED_BUCKET);
        if (limitExceededBucket == null) {
            limitExceededBucket = AsyncComponents.createServiceCallData(serviceCallsForType, LIMIT_EXCEEDED_BUCKET);
        }
        return new AsyncQueryData(serviceCallText, limitExceededBucket);
    }

    private boolean allowAnotherQueryAggregate(boolean bypassLimit) {
        return this.queryAggregateCounter++ < this.maxQueryAggregates * 10 || bypassLimit;
    }

    private boolean allowAnotherServiceCallAggregate(boolean bypassLimit) {
        return this.serviceCallAggregateCounter++ < this.maxServiceCallAggregates * 10 || bypassLimit;
    }

    private static AsyncQueryData createQueryData(Map<String, AsyncQueryData> queriesForType, String queryText) {
        AsyncQueryData queryData = new AsyncQueryData(queryText, null);
        queriesForType.put(queryText, queryData);
        return queryData;
    }

    private static AsyncQueryData createServiceCallData(Map<String, AsyncQueryData> serviceCallsForType, String serviceCallText) {
        AsyncQueryData serviceCallData = new AsyncQueryData(serviceCallText, null);
        serviceCallsForType.put(serviceCallText, serviceCallData);
        return serviceCallData;
    }

    private static class MergedAsyncTimer
    implements TransactionTimer {
        private final String name;
        private long totalNanos;
        private long count;

        private MergedAsyncTimer(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isExtended() {
            return false;
        }

        @Override
        public long getTotalNanos() {
            return this.totalNanos;
        }

        @Override
        public long getCount() {
            return this.count;
        }

        @Override
        public void mergeChildTimersInto(AggregatedTimer timer) {
        }

        @Override
        public TransactionTimer.TransactionTimerSnapshot getSnapshot() {
            return ImmutableTransactionTimerSnapshot.builder().totalNanos(this.totalNanos).count(this.count).active(false).build();
        }
    }
}

