/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.central;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.glowroot.agent.shaded.com.google.common.base.Charsets;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.cache.Cache;
import org.glowroot.agent.shaded.com.google.common.cache.CacheBuilder;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.hash.Hashing;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AggregateOuterClass;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.TraceOuterClass;

class SharedQueryTextLimiter {
    private final Cache<String, Boolean> sentInThePastDay = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.DAYS).maximumSize(10000L).build();

    SharedQueryTextLimiter() {
    }

    AggregateOuterClass.Aggregate.SharedQueryText buildAggregateSharedQueryText(String fullText, List<String> fullTextSha1s) {
        if (fullText.length() > 120) {
            String fullTextSha1 = Hashing.sha1().hashString(fullText, Charsets.UTF_8).toString();
            if (this.sentInThePastDay.getIfPresent(fullTextSha1) == null) {
                fullTextSha1s.add(fullTextSha1);
                return AggregateOuterClass.Aggregate.SharedQueryText.newBuilder().setFullText(fullText).build();
            }
            return AggregateOuterClass.Aggregate.SharedQueryText.newBuilder().setTruncatedText(fullText.substring(0, 120)).setFullTextSha1(fullTextSha1).build();
        }
        return AggregateOuterClass.Aggregate.SharedQueryText.newBuilder().setFullText(fullText).build();
    }

    TraceOuterClass.Trace.SharedQueryText buildTraceSharedQueryText(String fullText, List<String> fullTextSha1s) {
        if (fullText.length() > 240) {
            String fullTextSha1 = Hashing.sha1().hashString(fullText, Charsets.UTF_8).toString();
            if (this.sentInThePastDay.getIfPresent(fullTextSha1) == null) {
                fullTextSha1s.add(fullTextSha1);
                return TraceOuterClass.Trace.SharedQueryText.newBuilder().setFullText(fullText).build();
            }
            return TraceOuterClass.Trace.SharedQueryText.newBuilder().setTruncatedText(fullText.substring(0, 120)).setTruncatedEndText(fullText.substring(fullText.length() - 120, fullText.length())).setFullTextSha1(fullTextSha1).build();
        }
        return TraceOuterClass.Trace.SharedQueryText.newBuilder().setFullText(fullText).build();
    }

    List<TraceOuterClass.Trace.SharedQueryText> reduceTracePayloadWherePossible(List<TraceOuterClass.Trace.SharedQueryText> sharedQueryTexts) {
        ArrayList<TraceOuterClass.Trace.SharedQueryText> updatedSharedQueryTexts = Lists.newArrayList();
        for (TraceOuterClass.Trace.SharedQueryText sharedQueryText : sharedQueryTexts) {
            Preconditions.checkState(sharedQueryText.getTruncatedText().isEmpty());
            Preconditions.checkState(sharedQueryText.getTruncatedEndText().isEmpty());
            Preconditions.checkState(sharedQueryText.getFullTextSha1().isEmpty());
            String fullText = sharedQueryText.getFullText();
            if (fullText.length() > 240) {
                String fullTextSha1 = Hashing.sha1().hashString(fullText, Charsets.UTF_8).toString();
                if (this.sentInThePastDay.getIfPresent(fullTextSha1) == null) {
                    updatedSharedQueryTexts.add(sharedQueryText);
                    continue;
                }
                updatedSharedQueryTexts.add(TraceOuterClass.Trace.SharedQueryText.newBuilder().setTruncatedText(fullText.substring(0, 120)).setTruncatedEndText(fullText.substring(fullText.length() - 120, fullText.length())).setFullTextSha1(fullTextSha1).build());
                continue;
            }
            updatedSharedQueryTexts.add(sharedQueryText);
        }
        return updatedSharedQueryTexts;
    }

    void onSuccessfullySentToCentralCollector(String fullTextSha1) {
        this.sentInThePastDay.put(fullTextSha1, true);
    }
}

