/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.weaving;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.glowroot.agent.bytecode.api.Util;
import org.glowroot.agent.plugin.api.ClassInfo;
import org.glowroot.agent.plugin.api.MethodInfo;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.org.objectweb.asm.Type;
import org.glowroot.agent.weaving.ClassInfoImpl;
import org.glowroot.agent.weaving.MethodInfoImpl;

public class BootstrapMetaHolders {
    private static final Map<String, Integer> classMetaHolderIndexes = new ConcurrentHashMap<String, Integer>();
    private static final Map<String, Integer> methodMetaHolderIndexes = new ConcurrentHashMap<String, Integer>();
    private static final List<ClassMetaHolder> classMetaHolders = Lists.newCopyOnWriteArrayList();
    private static final List<MethodMetaHolder> methodMetaHolders = Lists.newCopyOnWriteArrayList();

    private BootstrapMetaHolders() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int reserveClassMetaHolderIndex(String metaHolderInternalName, String classMetaFieldName) {
        List<ClassMetaHolder> list = classMetaHolders;
        synchronized (list) {
            String key = metaHolderInternalName + '.' + classMetaFieldName;
            Integer index = classMetaHolderIndexes.get(key);
            if (index == null) {
                classMetaHolders.add(null);
                index = classMetaHolders.size() - 1;
                classMetaHolderIndexes.put(key, index);
            }
            return index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int reserveMethodMetaHolderIndex(String metaHolderInternalName, String methodMetaFieldName) {
        List<MethodMetaHolder> list = methodMetaHolders;
        synchronized (list) {
            methodMetaHolders.add(null);
            int index = methodMetaHolders.size() - 1;
            methodMetaHolderIndexes.put(metaHolderInternalName + '.' + methodMetaFieldName, index);
            return index;
        }
    }

    static void createClassMetaHolder(String metaHolderInternalName, String classMetaFieldName, Type classMetaType, Type type) {
        String key = metaHolderInternalName + '.' + classMetaFieldName;
        Integer index = classMetaHolderIndexes.get(key);
        Preconditions.checkNotNull(index, "ClassMetaHolder was not reserved for key: " + key);
        ClassMetaHolder classMetaHolder = new ClassMetaHolder(classMetaType, type);
        classMetaHolders.set(index, classMetaHolder);
    }

    static void createMethodMetaHolder(String metaHolderInternalName, String methodMetaFieldName, Type methodMetaType, Type methodOwnerType, String methodName, Type methodReturnType, List<Type> methodParameterTypes) {
        String key = metaHolderInternalName + '.' + methodMetaFieldName;
        Integer index = methodMetaHolderIndexes.get(key);
        Preconditions.checkNotNull(index, "MethodMetaHolder was not reserved for key: " + key);
        MethodMetaHolder methodMetaHolder = new MethodMetaHolder(methodMetaType, methodOwnerType, methodName, methodReturnType, methodParameterTypes);
        methodMetaHolders.set(index, methodMetaHolder);
    }

    public static Object getClassMeta(int index) throws Exception {
        ClassMetaHolder classMetaHolder = classMetaHolders.get(index);
        Preconditions.checkNotNull(classMetaHolder, "ClassMetaHolder was not instantiated for index: " + index);
        return classMetaHolder.getClassMeta();
    }

    public static Object getMethodMeta(int index) throws Exception {
        MethodMetaHolder methodMetaHolder = methodMetaHolders.get(index);
        Preconditions.checkNotNull(methodMetaHolder, "MethodMetaHolder was not instantiated for index: " + index);
        return methodMetaHolder.getMethodMeta();
    }

    private static Class<?> getType(Type type) throws ClassNotFoundException {
        switch (type.getSort()) {
            case 0: {
                return Void.TYPE;
            }
            case 1: {
                return Boolean.TYPE;
            }
            case 2: {
                return Character.TYPE;
            }
            case 3: {
                return Byte.TYPE;
            }
            case 4: {
                return Short.TYPE;
            }
            case 5: {
                return Integer.TYPE;
            }
            case 6: {
                return Float.TYPE;
            }
            case 7: {
                return Long.TYPE;
            }
            case 8: {
                return Double.TYPE;
            }
            case 9: {
                return Util.getArrayClass(BootstrapMetaHolders.getType(type.getElementType()), type.getDimensions());
            }
        }
        return Class.forName(type.getClassName(), false, null);
    }

    private static class MethodMetaHolder {
        private final Type methodMetaType;
        private final Type methodOwnerType;
        private final String methodName;
        private final Type methodReturnType;
        private final List<Type> methodParameterTypes;
        private volatile @MonotonicNonNull Object methodMeta;

        private MethodMetaHolder(Type methodMetaType, Type methodOwnerType, String methodName, Type methodReturnType, List<Type> methodParameterTypes) {
            this.methodMetaType = methodMetaType;
            this.methodOwnerType = methodOwnerType;
            this.methodName = methodName;
            this.methodReturnType = methodReturnType;
            this.methodParameterTypes = methodParameterTypes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object getMethodMeta() throws Exception {
            Object methodMetaLocal = this.methodMeta;
            if (methodMetaLocal != null) {
                return methodMetaLocal;
            }
            MethodMetaHolder methodMetaHolder = this;
            synchronized (methodMetaHolder) {
                if (this.methodMeta == null) {
                    ArrayList<Class<?>> methodParameterClasses = Lists.newArrayListWithCapacity(this.methodParameterTypes.size());
                    for (Type methodParameterType : this.methodParameterTypes) {
                        methodParameterClasses.add(BootstrapMetaHolders.getType(methodParameterType));
                    }
                    MethodInfoImpl methodInfo = new MethodInfoImpl(this.methodName, BootstrapMetaHolders.getType(this.methodReturnType), methodParameterClasses, this.methodOwnerType.getClassName(), null);
                    this.methodMeta = BootstrapMetaHolders.getType(this.methodMetaType).getConstructor(MethodInfo.class).newInstance(methodInfo);
                }
            }
            return this.methodMeta;
        }
    }

    private static class ClassMetaHolder {
        private final Type classMetaType;
        private final Type type;
        private volatile @MonotonicNonNull Object classMeta;

        private ClassMetaHolder(Type classMetaType, Type type) {
            this.classMetaType = classMetaType;
            this.type = type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object getClassMeta() throws Exception {
            Object classMetaLocal = this.classMeta;
            if (classMetaLocal != null) {
                return classMetaLocal;
            }
            ClassMetaHolder classMetaHolder = this;
            synchronized (classMetaHolder) {
                if (this.classMeta == null) {
                    ClassInfoImpl classInfo = new ClassInfoImpl(this.type.getClassName(), null);
                    this.classMeta = BootstrapMetaHolders.getType(this.classMetaType).getConstructor(ClassInfo.class).newInstance(classInfo);
                }
            }
            return this.classMeta;
        }
    }
}

