/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.weaving;

import java.io.File;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.config.PluginDescriptor;
import org.glowroot.agent.live.LiveWeavingServiceImpl;
import org.glowroot.agent.plugin.api.weaving.Shim;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.base.Supplier;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableCollection;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableMap;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableSet;
import org.glowroot.agent.shaded.com.google.common.collect.Iterables;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Maps;
import org.glowroot.agent.shaded.com.google.common.collect.Sets;
import org.glowroot.agent.shaded.org.glowroot.common.config.InstrumentationConfig;
import org.glowroot.agent.shaded.org.glowroot.common.util.OnlyUsedByTests;
import org.glowroot.agent.shaded.org.glowroot.common.util.Versions;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.glowroot.agent.weaving.Advice;
import org.glowroot.agent.weaving.AdviceBuilder;
import org.glowroot.agent.weaving.AdviceGenerator;
import org.glowroot.agent.weaving.ClassLoaders;
import org.glowroot.agent.weaving.MixinType;
import org.glowroot.agent.weaving.PluginDetail;
import org.glowroot.agent.weaving.PluginDetailBuilder;
import org.glowroot.agent.weaving.ShimType;

public class AdviceCache {
    private static final Logger logger = LoggerFactory.getLogger(AdviceCache.class);
    private static final AtomicInteger jarFileCounter = new AtomicInteger();
    private final ImmutableList<Advice> pluginAdvisors;
    private final ImmutableList<ShimType> shimTypes;
    private final ImmutableList<MixinType> mixinTypes;
    private final @Nullable Instrumentation instrumentation;
    private final File tmpDir;
    private volatile ImmutableList<Advice> reweavableAdvisors;
    private volatile ImmutableSet<String> reweavableConfigVersions;
    private volatile ImmutableList<Advice> allAdvisors;

    public AdviceCache(List<PluginDescriptor> pluginDescriptors, List<InstrumentationConfig> reweavableConfigs, @Nullable Instrumentation instrumentation, File tmpDir) throws Exception {
        ArrayList<Advice> pluginAdvisors = Lists.newArrayList();
        ArrayList<ShimType> shimTypes = Lists.newArrayList();
        ArrayList<MixinType> mixinTypes = Lists.newArrayList();
        HashMap<Advice, ClassLoaders.LazyDefinedClass> lazyAdvisors = Maps.newHashMap();
        for (PluginDescriptor pluginDescriptor : pluginDescriptors) {
            PluginDetailBuilder builder = new PluginDetailBuilder(pluginDescriptor);
            PluginDetail pluginDetail = builder.build();
            pluginAdvisors.addAll(AdviceCache.getAdvisors(pluginDetail.pointcutClasses()));
            mixinTypes.addAll(AdviceCache.getMixinTypes(pluginDetail.mixinClasses()));
            shimTypes.addAll(AdviceCache.getShimTypes(pluginDetail.shimClasses()));
            ImmutableList<InstrumentationConfig> instrumentationConfigs = pluginDescriptor.instrumentationConfigs();
            for (InstrumentationConfig instrumentationConfig : instrumentationConfigs) {
                instrumentationConfig.logValidationErrorsIfAny();
            }
            lazyAdvisors.putAll(AdviceGenerator.createAdvisors(instrumentationConfigs, pluginDescriptor.id(), pluginDescriptor.pluginJar() != null, false));
        }
        for (Map.Entry entry : lazyAdvisors.entrySet()) {
            pluginAdvisors.add((Advice)entry.getKey());
        }
        if (instrumentation == null) {
            ClassLoader isolatedWeavingClassLoader = Thread.currentThread().getContextClassLoader();
            Preconditions.checkNotNull(isolatedWeavingClassLoader);
            ClassLoaders.defineClasses(lazyAdvisors.values(), isolatedWeavingClassLoader);
        } else {
            ClassLoaders.createDirectoryOrCleanPreviousContentsWithPrefix(tmpDir, "plugin-pointcuts.jar");
            if (!lazyAdvisors.isEmpty()) {
                File jarFile = new File(tmpDir, "plugin-pointcuts.jar");
                ClassLoaders.defineClassesInBootstrapClassLoader(lazyAdvisors.values(), instrumentation, jarFile);
            }
        }
        this.pluginAdvisors = ImmutableList.copyOf(pluginAdvisors);
        this.shimTypes = ImmutableList.copyOf(shimTypes);
        this.mixinTypes = ImmutableList.copyOf(mixinTypes);
        this.instrumentation = instrumentation;
        this.tmpDir = tmpDir;
        this.reweavableAdvisors = AdviceCache.createReweavableAdvisors(reweavableConfigs, instrumentation, tmpDir, true);
        this.reweavableConfigVersions = AdviceCache.createReweavableConfigVersions(reweavableConfigs);
        this.allAdvisors = ImmutableList.copyOf(Iterables.concat(pluginAdvisors, this.reweavableAdvisors));
    }

    public Supplier<List<Advice>> getAdvisorsSupplier() {
        return new Supplier<List<Advice>>(){

            @Override
            public List<Advice> get() {
                return AdviceCache.this.allAdvisors;
            }
        };
    }

    public List<ShimType> getShimTypes() {
        return this.shimTypes;
    }

    public List<MixinType> getMixinTypes() {
        return this.mixinTypes;
    }

    public void initialReweave(Class<?>[] initialLoadedClasses) {
        HashSet<LiveWeavingServiceImpl.PointcutClassName> pointcutClassNames = Sets.newHashSet();
        for (Advice advice : this.allAdvisors) {
            LiveWeavingServiceImpl.PointcutClassName pointcutClassName = AdviceCache.getPointcutClassName(advice);
            if (pointcutClassName == null || advice.adviceType().getInternalName().startsWith("org/glowroot/agent/plugin/executor/ExecutorAspect$RunnableAdvice") || advice.adviceType().getInternalName().startsWith("org/glowroot/agent/plugin/executor/ExecutorAspect$CallableAdvice")) continue;
            pointcutClassNames.add(pointcutClassName);
        }
        LiveWeavingServiceImpl.initialReweave(pointcutClassNames, initialLoadedClasses, Preconditions.checkNotNull(this.instrumentation));
    }

    public void updateAdvisors(List<InstrumentationConfig> reweavableConfigs) throws Exception {
        this.reweavableAdvisors = AdviceCache.createReweavableAdvisors(reweavableConfigs, this.instrumentation, this.tmpDir, false);
        this.reweavableConfigVersions = AdviceCache.createReweavableConfigVersions(reweavableConfigs);
        this.allAdvisors = ImmutableList.copyOf(Iterables.concat(this.pluginAdvisors, this.reweavableAdvisors));
    }

    public boolean isOutOfSync(List<InstrumentationConfig> reweavableConfigs) {
        HashSet<String> versions = Sets.newHashSet();
        for (InstrumentationConfig reweavableConfig : reweavableConfigs) {
            versions.add(Versions.getVersion(reweavableConfig.toProto()));
        }
        return !versions.equals(this.reweavableConfigVersions);
    }

    private static List<Advice> getAdvisors(List<PluginDetail.PointcutClass> adviceClasses) {
        ArrayList<Advice> advisors = Lists.newArrayList();
        for (PluginDetail.PointcutClass adviceClass : adviceClasses) {
            try {
                advisors.add(new AdviceBuilder(adviceClass).build());
            }
            catch (Throwable t) {
                logger.error("error creating advice: {}", (Object)adviceClass.type().getClassName(), (Object)t);
            }
        }
        return advisors;
    }

    private static List<MixinType> getMixinTypes(List<PluginDetail.MixinClass> mixinClasses) {
        ArrayList<MixinType> mixinTypes = Lists.newArrayList();
        for (PluginDetail.MixinClass mixinClass : mixinClasses) {
            mixinTypes.add(MixinType.create(mixinClass));
        }
        return mixinTypes;
    }

    private static List<ShimType> getShimTypes(List<PluginDetail.ShimClass> shimClasses) throws ClassNotFoundException {
        ArrayList<ShimType> shimTypes = Lists.newArrayList();
        for (PluginDetail.ShimClass shimClass : shimClasses) {
            Class<?> clazz = Class.forName(shimClass.type().getClassName(), false, AdviceCache.class.getClassLoader());
            Shim shim = clazz.getAnnotation(Shim.class);
            if (shim == null) continue;
            shimTypes.add(ShimType.create(shim, clazz));
        }
        return shimTypes;
    }

    private static ImmutableList<Advice> createReweavableAdvisors(List<InstrumentationConfig> reweavableConfigs, @Nullable Instrumentation instrumentation, File tmpDir, boolean cleanTmpDir) throws Exception {
        ImmutableMap<Advice, ClassLoaders.LazyDefinedClass> advisors = AdviceGenerator.createAdvisors(reweavableConfigs, null, false, true);
        if (instrumentation == null) {
            ClassLoader isolatedWeavingClassLoader = Thread.currentThread().getContextClassLoader();
            Preconditions.checkNotNull(isolatedWeavingClassLoader);
            ClassLoaders.defineClasses(advisors.values(), isolatedWeavingClassLoader);
        } else {
            if (cleanTmpDir) {
                ClassLoaders.createDirectoryOrCleanPreviousContentsWithPrefix(tmpDir, "config-pointcuts");
            }
            if (!advisors.isEmpty()) {
                String suffix = "";
                int count = jarFileCounter.incrementAndGet();
                if (count > 1) {
                    suffix = "-" + count;
                }
                File jarFile = new File(tmpDir, "config-pointcuts" + suffix + ".jar");
                ClassLoaders.defineClassesInBootstrapClassLoader(advisors.values(), instrumentation, jarFile);
            }
        }
        return ((ImmutableCollection)((Object)advisors.keySet())).asList();
    }

    private static ImmutableSet<String> createReweavableConfigVersions(List<InstrumentationConfig> reweavableConfigs) {
        HashSet<String> versions = Sets.newHashSet();
        for (InstrumentationConfig reweavableConfig : reweavableConfigs) {
            versions.add(Versions.getVersion(reweavableConfig.toProto()));
        }
        return ImmutableSet.copyOf(versions);
    }

    private static @Nullable LiveWeavingServiceImpl.PointcutClassName getPointcutClassName(Advice advice) {
        LiveWeavingServiceImpl.PointcutClassName subTypeRestrictionPointcutClassName = null;
        Pattern subTypeRestrictionPattern = advice.pointcutSubTypeRestrictionPattern();
        if (subTypeRestrictionPattern != null) {
            subTypeRestrictionPointcutClassName = LiveWeavingServiceImpl.PointcutClassName.fromPattern(subTypeRestrictionPattern, null, false);
        } else {
            String subTypeRestriction = advice.pointcut().subTypeRestriction();
            if (!subTypeRestriction.isEmpty()) {
                subTypeRestrictionPointcutClassName = LiveWeavingServiceImpl.PointcutClassName.fromNonPattern(subTypeRestriction, null, false);
            }
        }
        Pattern classNamePattern = advice.pointcutClassNamePattern();
        if (classNamePattern != null) {
            return LiveWeavingServiceImpl.PointcutClassName.fromPattern(classNamePattern, subTypeRestrictionPointcutClassName, advice.pointcut().methodName().equals("<init>"));
        }
        String className = advice.pointcut().className();
        if (!className.isEmpty()) {
            return LiveWeavingServiceImpl.PointcutClassName.fromNonPattern(className, subTypeRestrictionPointcutClassName, advice.pointcut().methodName().equals("<init>"));
        }
        return null;
    }

    @OnlyUsedByTests
    public List<Advice> getAdvisors() {
        return this.getAdvisorsSupplier().get();
    }
}

