/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.org.glowroot.common.util;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.ListIterator;

public abstract class Traverser<T, E extends Exception> {
    private static final Object ALREADY_TRAVERSED_MARKER = new Object();
    private final Deque<Object> stack = new ArrayDeque<Object>();
    private int depth;

    public Traverser(T root) {
        this.stack.push(root);
    }

    public void traverse() throws E {
        while (!this.stack.isEmpty()) {
            Object popped = this.stack.pop();
            if (popped == ALREADY_TRAVERSED_MARKER) {
                this.revisitAfterChildren(this.stack.pop());
                --this.depth;
                continue;
            }
            Object unprocessed = popped;
            List<Object> childNodes = this.visit(unprocessed, this.depth);
            if (childNodes.isEmpty()) {
                this.revisitAfterChildren(unprocessed);
                continue;
            }
            this.stack.push(unprocessed);
            this.stack.push(ALREADY_TRAVERSED_MARKER);
            ListIterator<Object> i = childNodes.listIterator(childNodes.size());
            while (i.hasPrevious()) {
                this.stack.push(i.previous());
            }
            ++this.depth;
        }
    }

    public abstract List<T> visit(T var1, int var2) throws E;

    protected void revisitAfterChildren(T node) throws E {
    }
}

