/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.org.glowroot.common.model;

import java.util.List;
import java.util.Map;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Maps;
import org.glowroot.agent.shaded.com.google.common.collect.Ordering;
import org.glowroot.agent.shaded.com.google.common.primitives.Doubles;
import org.glowroot.agent.shaded.com.google.common.primitives.Longs;
import org.glowroot.agent.shaded.org.glowroot.common.model.ImmutableTransactionNameSummary;
import org.glowroot.agent.shaded.org.glowroot.common.model.Result;
import org.immutables.value.Value;

public class TransactionNameSummaryCollector {
    private static final Ordering<TransactionNameSummary> orderingByTotalTimeDesc = new Ordering<TransactionNameSummary>(){

        @Override
        public int compare(TransactionNameSummary left, TransactionNameSummary right) {
            return Doubles.compare(right.totalDurationNanos(), left.totalDurationNanos());
        }
    };
    private static final Ordering<TransactionNameSummary> orderingByAverageTimeDesc = new Ordering<TransactionNameSummary>(){

        @Override
        public int compare(TransactionNameSummary left, TransactionNameSummary right) {
            return Doubles.compare(right.totalDurationNanos() / (double)right.transactionCount(), left.totalDurationNanos() / (double)left.transactionCount());
        }
    };
    private static final Ordering<TransactionNameSummary> orderingByTransactionCountDesc = new Ordering<TransactionNameSummary>(){

        @Override
        public int compare(TransactionNameSummary left, TransactionNameSummary right) {
            return Longs.compare(right.transactionCount(), left.transactionCount());
        }
    };
    private static final Ordering<TransactionNameSummary> orderingByTotalCpuTimeDesc = new Ordering<TransactionNameSummary>(){

        @Override
        public int compare(TransactionNameSummary left, TransactionNameSummary right) {
            return Doubles.compare(right.totalCpuNanos(), left.totalCpuNanos());
        }
    };
    private static final Ordering<TransactionNameSummary> orderingByAverageCpuTimeDesc = new Ordering<TransactionNameSummary>(){

        @Override
        public int compare(TransactionNameSummary left, TransactionNameSummary right) {
            return Doubles.compare(right.totalCpuNanos() / (double)right.transactionCount(), left.totalCpuNanos() / (double)left.transactionCount());
        }
    };
    private static final Ordering<TransactionNameSummary> orderingByTotalAllocatedMemoryDesc = new Ordering<TransactionNameSummary>(){

        @Override
        public int compare(TransactionNameSummary left, TransactionNameSummary right) {
            return Doubles.compare(right.totalAllocatedBytes(), left.totalAllocatedBytes());
        }
    };
    private static final Ordering<TransactionNameSummary> orderingByAverageAllocatedMemoryDesc = new Ordering<TransactionNameSummary>(){

        @Override
        public int compare(TransactionNameSummary left, TransactionNameSummary right) {
            return Doubles.compare(right.totalAllocatedBytes() / (double)right.transactionCount(), left.totalAllocatedBytes() / (double)left.transactionCount());
        }
    };
    private final Map<String, MutableTransactionNameSummary> transactionNameSummaries = Maps.newHashMap();
    private long lastCaptureTime;

    public void collect(String transactionName, double totalDurationNanos, double totalCpuNanos, double totalAllocatedBytes, long transactionCount, long captureTime) {
        MutableTransactionNameSummary mts = this.transactionNameSummaries.get(transactionName);
        if (mts == null) {
            mts = new MutableTransactionNameSummary();
            this.transactionNameSummaries.put(transactionName, mts);
        }
        mts.totalDurationNanos += totalDurationNanos;
        mts.totalCpuNanos += totalCpuNanos;
        mts.totalAllocatedBytes += totalAllocatedBytes;
        mts.transactionCount += transactionCount;
        this.lastCaptureTime = Math.max(this.lastCaptureTime, captureTime);
    }

    public long getLastCaptureTime() {
        return this.lastCaptureTime;
    }

    public Result<TransactionNameSummary> getResult(SummarySortOrder sortOrder, int limit) {
        List<TransactionNameSummary> summaries = Lists.newArrayList();
        for (Map.Entry<String, MutableTransactionNameSummary> entry : this.transactionNameSummaries.entrySet()) {
            summaries.add(ImmutableTransactionNameSummary.builder().transactionName(entry.getKey()).totalDurationNanos(entry.getValue().totalDurationNanos).totalCpuNanos(entry.getValue().totalCpuNanos).totalAllocatedBytes(entry.getValue().totalAllocatedBytes).transactionCount(entry.getValue().transactionCount).build());
        }
        if ((summaries = TransactionNameSummaryCollector.sortTransactionNameSummaries(summaries, sortOrder)).size() > limit) {
            return new Result<TransactionNameSummary>(summaries.subList(0, limit), true);
        }
        return new Result<TransactionNameSummary>(summaries, false);
    }

    private static List<TransactionNameSummary> sortTransactionNameSummaries(Iterable<TransactionNameSummary> transactionNameSummaries, SummarySortOrder sortOrder) {
        switch (sortOrder) {
            case TOTAL_TIME: {
                return orderingByTotalTimeDesc.immutableSortedCopy(transactionNameSummaries);
            }
            case AVERAGE_TIME: {
                return orderingByAverageTimeDesc.immutableSortedCopy(transactionNameSummaries);
            }
            case THROUGHPUT: {
                return orderingByTransactionCountDesc.immutableSortedCopy(transactionNameSummaries);
            }
            case TOTAL_CPU_TIME: {
                return orderingByTotalCpuTimeDesc.immutableSortedCopy(transactionNameSummaries);
            }
            case AVERAGE_CPU_TIME: {
                return orderingByAverageCpuTimeDesc.immutableSortedCopy(transactionNameSummaries);
            }
            case TOTAL_ALLOCATED_MEMORY: {
                return orderingByTotalAllocatedMemoryDesc.immutableSortedCopy(transactionNameSummaries);
            }
            case AVERAGE_ALLOCATED_MEMORY: {
                return orderingByAverageAllocatedMemoryDesc.immutableSortedCopy(transactionNameSummaries);
            }
        }
        throw new AssertionError((Object)("Unexpected sort order: " + (Object)((Object)sortOrder)));
    }

    private static class MutableTransactionNameSummary {
        private double totalDurationNanos;
        private double totalCpuNanos;
        private double totalAllocatedBytes;
        private long transactionCount;

        private MutableTransactionNameSummary() {
        }
    }

    @Value.Immutable
    public static interface TransactionNameSummary {
        public String transactionName();

        public double totalDurationNanos();

        public double totalCpuNanos();

        public double totalAllocatedBytes();

        public long transactionCount();
    }

    public static enum SummarySortOrder {
        TOTAL_TIME,
        AVERAGE_TIME,
        THROUGHPUT,
        TOTAL_CPU_TIME,
        AVERAGE_CPU_TIME,
        TOTAL_ALLOCATED_MEMORY,
        AVERAGE_ALLOCATED_MEMORY;

    }
}

