/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.org.glowroot.common.model;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.Module;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.base.Strings;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.Iterators;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Maps;
import org.glowroot.agent.shaded.com.google.common.collect.PeekingIterator;
import org.glowroot.agent.shaded.com.google.common.collect.Queues;
import org.glowroot.agent.shaded.com.google.common.io.CharStreams;
import org.glowroot.agent.shaded.org.glowroot.common.util.ObjectMappers;
import org.glowroot.agent.shaded.org.glowroot.common.util.Traverser;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.ProfileOuterClass;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;

public class MutableProfile {
    private static final Logger logger = LoggerFactory.getLogger(MutableProfile.class);
    private static final ObjectMapper mapper = ObjectMappers.create(new Module[0]);
    private final Map<String, Integer> packageNameIndexes = Maps.newHashMap();
    private final Map<String, Integer> classNameIndexes = Maps.newHashMap();
    private final Map<String, Integer> methodNameIndexes = Maps.newHashMap();
    private final Map<String, Integer> fileNameIndexes = Maps.newHashMap();
    private final List<String> packageNames = Lists.newArrayList();
    private final List<String> classNames = Lists.newArrayList();
    private final List<String> methodNames = Lists.newArrayList();
    private final List<String> fileNames = Lists.newArrayList();
    private final List<ProfileNode> rootNodes = Lists.newArrayList();
    private long unfilteredSampleCount = -1L;

    public void merge(MutableProfile profile) {
        this.merge(profile.toProto());
    }

    public void merge(ProfileOuterClass.Profile profile) {
        Merger merger = new Merger(profile);
        merger.merge(profile.getNodeList(), this.rootNodes);
    }

    public void merge(List<StackTraceElement> stackTraceElements, Thread.State threadState) {
        PeekingIterator<StackTraceElement> i = Iterators.peekingIterator(Lists.reverse(stackTraceElements).iterator());
        ProfileNode lastMatchedNode = null;
        List mergeIntoNodes = this.rootNodes;
        boolean lookingForMatch = true;
        while (i.hasNext()) {
            String className;
            String packageName;
            StackTraceElement stackTraceElement = i.next();
            String fullClassName = stackTraceElement.getClassName();
            int index = fullClassName.lastIndexOf(46);
            if (index == -1) {
                packageName = "";
                className = fullClassName;
            } else {
                packageName = fullClassName.substring(0, index);
                className = fullClassName.substring(index + 1);
            }
            int packageNameIndex = MutableProfile.getNameIndex(packageName, this.packageNameIndexes, this.packageNames);
            int classNameIndex = MutableProfile.getNameIndex(className, this.classNameIndexes, this.classNames);
            int methodNameIndex = MutableProfile.getNameIndex(MoreObjects.firstNonNull(stackTraceElement.getMethodName(), "<null method name>"), this.methodNameIndexes, this.methodNames);
            int fileNameIndex = MutableProfile.getNameIndex(Strings.nullToEmpty(stackTraceElement.getFileName()), this.fileNameIndexes, this.fileNames);
            int lineNumber = stackTraceElement.getLineNumber();
            ProfileOuterClass.Profile.LeafThreadState leafThreadState = i.hasNext() ? ProfileOuterClass.Profile.LeafThreadState.NONE : MutableProfile.getThreadState(threadState);
            ProfileNode node = null;
            if (lookingForMatch) {
                for (ProfileNode childNode : mergeIntoNodes) {
                    if (!MutableProfile.isMatch(childNode, packageNameIndex, classNameIndex, methodNameIndex, fileNameIndex, lineNumber, leafThreadState)) continue;
                    node = childNode;
                    break;
                }
            }
            if (node == null) {
                lookingForMatch = false;
                node = new ProfileNode(packageNameIndex, classNameIndex, methodNameIndex, fileNameIndex, lineNumber, leafThreadState);
                mergeIntoNodes.add(node);
            }
            node.sampleCount++;
            lastMatchedNode = node;
            mergeIntoNodes = lastMatchedNode.childNodes;
        }
    }

    public void filter(List<String> includes, List<String> excludes) {
        ProfileNode rootNode;
        Iterator<ProfileNode> i;
        this.unfilteredSampleCount = this.getSampleCount();
        for (String include : includes) {
            i = this.rootNodes.iterator();
            while (i.hasNext()) {
                rootNode = i.next();
                new ProfileFilterer(rootNode, include, false).traverse();
                if (rootNode.matched) {
                    new ProfileResetMatches(rootNode).traverse();
                    continue;
                }
                i.remove();
            }
        }
        for (String exclude : excludes) {
            i = this.rootNodes.iterator();
            while (i.hasNext()) {
                rootNode = i.next();
                new ProfileFilterer(rootNode, exclude, true).traverse();
                if (!rootNode.matched) continue;
                i.remove();
            }
        }
    }

    public void truncateBranches(double truncateBranchPercentage) {
        ProfileNode node;
        if (truncateBranchPercentage == 0.0) {
            return;
        }
        int minSamples = (int)Math.ceil((double)this.getSampleCount() * truncateBranchPercentage / 100.0);
        ArrayDeque<ProfileNode> toBeVisited = new ArrayDeque<ProfileNode>();
        for (ProfileNode rootNode : this.rootNodes) {
            toBeVisited.add(rootNode);
        }
        while ((node = (ProfileNode)toBeVisited.poll()) != null) {
            Iterator i = node.childNodes.iterator();
            while (i.hasNext()) {
                ProfileNode childNode = (ProfileNode)i.next();
                if (childNode.sampleCount < (long)minSamples) {
                    i.remove();
                    node.ellipsedSampleCount += childNode.sampleCount;
                    continue;
                }
                toBeVisited.add(childNode);
            }
        }
    }

    public boolean isEmpty() {
        return this.rootNodes.isEmpty();
    }

    public long getSampleCount() {
        long sampleCount = 0L;
        for (ProfileNode rootNode : this.rootNodes) {
            sampleCount += rootNode.sampleCount;
        }
        return sampleCount;
    }

    public long getUnfilteredSampleCount() {
        if (this.unfilteredSampleCount == -1L) {
            return this.getSampleCount();
        }
        return this.unfilteredSampleCount;
    }

    public ProfileOuterClass.Profile toProto() {
        ArrayList<ProfileOuterClass.Profile.ProfileNode> nodes = Lists.newArrayList();
        for (ProfileNode rootNode : this.rootNodes) {
            new ProfileNodeCollector(rootNode, nodes).traverse();
        }
        return ProfileOuterClass.Profile.newBuilder().addAllPackageName(this.packageNames).addAllClassName(this.classNames).addAllMethodName(this.methodNames).addAllFileName(this.fileNames).addAllNode(nodes).build();
    }

    public String toJson() throws IOException {
        StringBuilder sb = new StringBuilder();
        JsonGenerator jg = mapper.getFactory().createGenerator(CharStreams.asWriter(sb));
        this.writeJson(jg);
        jg.close();
        return sb.toString();
    }

    public void writeJson(JsonGenerator jg) throws IOException {
        jg.writeStartObject();
        jg.writeNumberField("unfilteredSampleCount", this.getUnfilteredSampleCount());
        jg.writeArrayFieldStart("rootNodes");
        for (ProfileNode rootNode : this.rootNodes) {
            new ProfileWriter(rootNode, jg).traverse();
        }
        jg.writeEndArray();
        jg.writeEndObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toFlameGraphJson() throws IOException {
        StringBuilder sb = new StringBuilder();
        try (JsonGenerator jg = mapper.getFactory().createGenerator(CharStreams.asWriter(sb));){
            jg.writeStartObject();
            jg.writeNumberField("totalSampleCount", this.getSampleCount());
            jg.writeArrayFieldStart("rootNodes");
            int height = 0;
            for (ProfileNode rootNode : this.rootNodes) {
                if (rootNode.sampleCount <= rootNode.ellipsedSampleCount) continue;
                FlameGraphWriter flameGraphWriter = new FlameGraphWriter(rootNode, jg);
                flameGraphWriter.traverse();
                height = Math.max(height, flameGraphWriter.height);
            }
            jg.writeEndArray();
            jg.writeNumberField("height", height);
            jg.writeEndObject();
        }
        return sb.toString();
    }

    private static int getNameIndex(String name, Map<String, Integer> nameIndexes, List<String> names) {
        Integer index = nameIndexes.get(name);
        if (index == null) {
            index = names.size();
            names.add(name);
            nameIndexes.put(name, index);
        }
        return index;
    }

    private static ProfileOuterClass.Profile.LeafThreadState getThreadState(Thread.State state) {
        if (state == null) {
            return ProfileOuterClass.Profile.LeafThreadState.NONE;
        }
        switch (state) {
            case NEW: {
                return ProfileOuterClass.Profile.LeafThreadState.NEW;
            }
            case RUNNABLE: {
                return ProfileOuterClass.Profile.LeafThreadState.RUNNABLE;
            }
            case BLOCKED: {
                return ProfileOuterClass.Profile.LeafThreadState.BLOCKED;
            }
            case WAITING: {
                return ProfileOuterClass.Profile.LeafThreadState.WAITING;
            }
            case TIMED_WAITING: {
                return ProfileOuterClass.Profile.LeafThreadState.TIMED_WAITING;
            }
            case TERMINATED: {
                return ProfileOuterClass.Profile.LeafThreadState.TERMINATED;
            }
        }
        logger.warn("unexpected thread state: {}", (Object)state);
        return ProfileOuterClass.Profile.LeafThreadState.NONE;
    }

    private static boolean isMatch(ProfileNode profileNode, int packageNameIndex, int classNameIndex, int methodNameIndex, int fileNameIndex, int lineNumber, ProfileOuterClass.Profile.LeafThreadState leafThreadState) {
        return lineNumber == profileNode.lineNumber && fileNameIndex == profileNode.fileNameIndex && leafThreadState == profileNode.leafThreadState && methodNameIndex == profileNode.methodNameIndex && classNameIndex == profileNode.classNameIndex && packageNameIndex == profileNode.packageNameIndex;
    }

    private static int[] makeIndexMapping(List<String> toBeMergedNames, Map<String, Integer> existingIndexes, List<String> existingNames) {
        int[] indexMapping = new int[toBeMergedNames.size()];
        for (int i = 0; i < toBeMergedNames.size(); ++i) {
            String toBeMergedName = toBeMergedNames.get(i);
            Integer existingIndex = existingIndexes.get(toBeMergedName);
            if (existingIndex == null) {
                int newIndex = existingNames.size();
                existingNames.add(toBeMergedName);
                existingIndexes.put(toBeMergedName, newIndex);
                indexMapping[i] = newIndex;
                continue;
            }
            indexMapping[i] = existingIndex;
        }
        return indexMapping;
    }

    private static class FlameGraphWriter
    extends Traverser<ProfileNode, IOException> {
        private final JsonGenerator jg;
        private int height;

        private FlameGraphWriter(ProfileNode rootNode, JsonGenerator jg) {
            super(rootNode);
            this.jg = jg;
        }

        @Override
        public List<ProfileNode> visit(ProfileNode node, int depth) throws IOException {
            this.height = Math.max(this.height, depth + 1);
            this.jg.writeStartObject();
            this.jg.writeStringField("name", node.getText());
            this.jg.writeNumberField("value", node.sampleCount);
            if (!node.childNodes.isEmpty()) {
                this.jg.writeArrayFieldStart("children");
            }
            return node.childNodes;
        }

        @Override
        public void revisitAfterChildren(ProfileNode node) throws IOException {
            if (!node.childNodes.isEmpty()) {
                this.jg.writeEndArray();
            }
            this.jg.writeEndObject();
        }
    }

    private static class ProfileWriter
    extends Traverser<ProfileNode, IOException> {
        private final JsonGenerator jg;

        private ProfileWriter(ProfileNode rootNode, JsonGenerator jg) {
            super(rootNode);
            this.jg = jg;
        }

        @Override
        public List<ProfileNode> visit(ProfileNode node, int depth) throws IOException {
            List childNodes;
            this.jg.writeStartObject();
            this.jg.writeStringField("stackTraceElement", node.getText());
            ProfileOuterClass.Profile.LeafThreadState leafThreadState = node.leafThreadState;
            if (leafThreadState != ProfileOuterClass.Profile.LeafThreadState.NONE) {
                this.jg.writeStringField("leafThreadState", leafThreadState.name());
            }
            this.jg.writeNumberField("sampleCount", node.sampleCount);
            long ellipsedSampleCount = node.ellipsedSampleCount;
            if (ellipsedSampleCount > 0L) {
                this.jg.writeNumberField("ellipsedSampleCount", ellipsedSampleCount);
            }
            if (!(childNodes = node.childNodes).isEmpty()) {
                this.jg.writeArrayFieldStart("childNodes");
            }
            return childNodes;
        }

        @Override
        public void revisitAfterChildren(ProfileNode node) throws IOException {
            if (!node.childNodes.isEmpty()) {
                this.jg.writeEndArray();
            }
            this.jg.writeEndObject();
        }
    }

    private static class ProfileResetMatches
    extends Traverser<ProfileNode, RuntimeException> {
        private ProfileResetMatches(ProfileNode rootNode) {
            super(rootNode);
        }

        @Override
        public List<ProfileNode> visit(ProfileNode node, int depth) {
            node.matched = false;
            return node.childNodes;
        }
    }

    private static class ProfileFilterer
    extends Traverser<ProfileNode, RuntimeException> {
        private final String filterTextUpper;
        private final boolean exclusion;

        private ProfileFilterer(ProfileNode rootNode, String filterText, boolean exclusion) {
            super(rootNode);
            this.filterTextUpper = filterText.toUpperCase(Locale.ENGLISH);
            this.exclusion = exclusion;
        }

        @Override
        public List<ProfileNode> visit(ProfileNode node, int depth) {
            if (this.isMatch(node)) {
                node.matched = true;
                return ImmutableList.of();
            }
            return node.childNodes;
        }

        @Override
        public void revisitAfterChildren(ProfileNode node) {
            if (node.matched) {
                return;
            }
            if (node.childNodes.isEmpty()) {
                return;
            }
            if (this.removeNode(node)) {
                if (this.exclusion) {
                    node.matched = true;
                }
                return;
            }
            if (!this.exclusion) {
                node.matched = true;
            }
            long filteredSampleCount = 0L;
            Iterator i = node.childNodes.iterator();
            while (i.hasNext()) {
                ProfileNode childNode = (ProfileNode)i.next();
                if (this.exclusion == !childNode.matched) {
                    filteredSampleCount += childNode.sampleCount;
                    continue;
                }
                i.remove();
            }
            node.sampleCount = filteredSampleCount;
        }

        private boolean isMatch(ProfileNode node) {
            String leafThreadStateUpper;
            String textUpper = node.getTextUpper();
            if (textUpper.contains(this.filterTextUpper)) {
                return true;
            }
            ProfileOuterClass.Profile.LeafThreadState leafThreadState = node.leafThreadState;
            return leafThreadState != null && (leafThreadStateUpper = leafThreadState.name().toUpperCase(Locale.ENGLISH)).contains(this.filterTextUpper);
        }

        private boolean removeNode(ProfileNode node) {
            if (this.exclusion) {
                return ProfileFilterer.hasOnlyMatchedChildren(node);
            }
            return ProfileFilterer.hasNoMatchedChildren(node);
        }

        private static boolean hasOnlyMatchedChildren(ProfileNode node) {
            for (ProfileNode childNode : node.childNodes) {
                if (childNode.matched) continue;
                return false;
            }
            return true;
        }

        private static boolean hasNoMatchedChildren(ProfileNode node) {
            for (ProfileNode childNode : node.childNodes) {
                if (!childNode.matched) continue;
                return false;
            }
            return true;
        }
    }

    private static class ProfileNodeCollector
    extends Traverser<ProfileNode, RuntimeException> {
        private final List<ProfileOuterClass.Profile.ProfileNode> nodes;

        public ProfileNodeCollector(ProfileNode rootNode, List<ProfileOuterClass.Profile.ProfileNode> nodes) {
            super(rootNode);
            this.nodes = nodes;
        }

        @Override
        public List<ProfileNode> visit(ProfileNode node, int depth) {
            this.nodes.add(ProfileOuterClass.Profile.ProfileNode.newBuilder().setDepth(depth).setPackageNameIndex(node.packageNameIndex).setClassNameIndex(node.classNameIndex).setMethodNameIndex(node.methodNameIndex).setFileNameIndex(node.fileNameIndex).setLineNumber(node.lineNumber).setLeafThreadState(node.leafThreadState).setSampleCount(node.sampleCount).build());
            return node.childNodes;
        }
    }

    private class Merger {
        private final int[] packageNameIndexMapping;
        private final int[] classNameIndexMapping;
        private final int[] methodNameIndexMapping;
        private final int[] fileNameIndexMapping;
        private final Deque<List<ProfileNode>> destinationStack = Queues.newArrayDeque();

        private Merger(ProfileOuterClass.Profile toBeMergedProfile) {
            this.packageNameIndexMapping = MutableProfile.makeIndexMapping(toBeMergedProfile.getPackageNameList(), MutableProfile.this.packageNameIndexes, MutableProfile.this.packageNames);
            this.classNameIndexMapping = MutableProfile.makeIndexMapping(toBeMergedProfile.getClassNameList(), MutableProfile.this.classNameIndexes, MutableProfile.this.classNames);
            this.methodNameIndexMapping = MutableProfile.makeIndexMapping(toBeMergedProfile.getMethodNameList(), MutableProfile.this.methodNameIndexes, MutableProfile.this.methodNames);
            this.fileNameIndexMapping = MutableProfile.makeIndexMapping(toBeMergedProfile.getFileNameList(), MutableProfile.this.fileNameIndexes, MutableProfile.this.fileNames);
        }

        private void merge(List<ProfileOuterClass.Profile.ProfileNode> flatNodes, List<ProfileNode> destinationRootNodes) {
            this.destinationStack.push(destinationRootNodes);
            PeekingIterator<ProfileOuterClass.Profile.ProfileNode> i = Iterators.peekingIterator(flatNodes.iterator());
            while (i.hasNext()) {
                ProfileOuterClass.Profile.ProfileNode flatNode = i.next();
                int destinationDepth = this.destinationStack.size() - 1;
                for (int j = 0; j < destinationDepth - flatNode.getDepth(); ++j) {
                    this.destinationStack.pop();
                }
                ProfileNode destinationNode = this.mergeOne(flatNode, this.destinationStack.getFirst());
                if (!i.hasNext() || i.peek().getDepth() <= flatNode.getDepth()) continue;
                this.destinationStack.push(destinationNode.childNodes);
            }
        }

        private ProfileNode mergeOne(ProfileOuterClass.Profile.ProfileNode toBeMergedNode, List<ProfileNode> destinationNodes) {
            int toBeMergedPackageNameIndex = this.packageNameIndexMapping[toBeMergedNode.getPackageNameIndex()];
            int toBeMergedClassNameIndex = this.classNameIndexMapping[toBeMergedNode.getClassNameIndex()];
            int toBeMergedMethodNameIndex = this.methodNameIndexMapping[toBeMergedNode.getMethodNameIndex()];
            int toBeMergedFileNameIndex = this.fileNameIndexMapping[toBeMergedNode.getFileNameIndex()];
            int toBeMergedLineNumber = toBeMergedNode.getLineNumber();
            ProfileOuterClass.Profile.LeafThreadState toBeMergedLeafThreadState = toBeMergedNode.getLeafThreadState();
            for (ProfileNode destinationNode : destinationNodes) {
                if (!MutableProfile.isMatch(destinationNode, toBeMergedPackageNameIndex, toBeMergedClassNameIndex, toBeMergedMethodNameIndex, toBeMergedFileNameIndex, toBeMergedLineNumber, toBeMergedLeafThreadState)) continue;
                this.merge(toBeMergedNode, destinationNode);
                return destinationNode;
            }
            ProfileNode destinationNode = new ProfileNode(toBeMergedPackageNameIndex, toBeMergedClassNameIndex, toBeMergedMethodNameIndex, toBeMergedFileNameIndex, toBeMergedLineNumber, toBeMergedLeafThreadState);
            destinationNodes.add(destinationNode);
            this.merge(toBeMergedNode, destinationNode);
            return destinationNode;
        }

        private void merge(ProfileOuterClass.Profile.ProfileNode toBeMergedNode, ProfileNode destinationNode) {
            destinationNode.sampleCount += toBeMergedNode.getSampleCount();
        }
    }

    private class ProfileNode {
        private final int packageNameIndex;
        private final int classNameIndex;
        private final int methodNameIndex;
        private final int fileNameIndex;
        private final int lineNumber;
        private final ProfileOuterClass.Profile.LeafThreadState leafThreadState;
        private long sampleCount;
        private List<ProfileNode> childNodes = Lists.newArrayListWithCapacity(2);
        private @Nullable String text;
        private @Nullable String textUpper;
        private boolean matched;
        private long ellipsedSampleCount;

        private ProfileNode(int packageNameIndex, int classNameIndex, int methodNameIndex, int fileNameIndex, int lineNumber, ProfileOuterClass.Profile.LeafThreadState leafThreadState) {
            this.packageNameIndex = packageNameIndex;
            this.classNameIndex = classNameIndex;
            this.methodNameIndex = methodNameIndex;
            this.fileNameIndex = fileNameIndex;
            this.lineNumber = lineNumber;
            this.leafThreadState = leafThreadState;
        }

        private String getText() {
            if (this.text == null) {
                String packageName = (String)MutableProfile.this.packageNames.get(this.packageNameIndex);
                String className = (String)MutableProfile.this.classNames.get(this.classNameIndex);
                String fullClassName = packageName.isEmpty() ? className : packageName + '.' + className;
                this.text = new StackTraceElement(fullClassName, (String)MutableProfile.this.methodNames.get(this.methodNameIndex), (String)MutableProfile.this.fileNames.get(this.fileNameIndex), this.lineNumber).toString();
            }
            return this.text;
        }

        private String getTextUpper() {
            if (this.textUpper == null) {
                this.textUpper = this.getText().toUpperCase(Locale.ENGLISH);
            }
            return this.textUpper;
        }
    }
}

