/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.org.glowroot.common.config;

import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.org.glowroot.common.config.ImmutableGaugeConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.ImmutableMBeanAttribute;
import org.glowroot.agent.shaded.org.glowroot.common.util.Styles;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AgentConfigOuterClass;
import org.immutables.value.Value;

@Value.Immutable
public abstract class GaugeConfig {
    public abstract String mbeanObjectName();

    public abstract ImmutableList<ImmutableMBeanAttribute> mbeanAttributes();

    public AgentConfigOuterClass.AgentConfig.GaugeConfig toProto() {
        AgentConfigOuterClass.AgentConfig.GaugeConfig.Builder builder = AgentConfigOuterClass.AgentConfig.GaugeConfig.newBuilder().setMbeanObjectName(this.mbeanObjectName());
        for (MBeanAttribute mBeanAttribute : this.mbeanAttributes()) {
            builder.addMbeanAttribute(AgentConfigOuterClass.AgentConfig.MBeanAttribute.newBuilder().setName(mBeanAttribute.name()).setCounter(mBeanAttribute.counter()));
        }
        return builder.build();
    }

    public static ImmutableGaugeConfig create(AgentConfigOuterClass.AgentConfig.GaugeConfig config) {
        ImmutableGaugeConfig.Builder builder = ImmutableGaugeConfig.builder().mbeanObjectName(config.getMbeanObjectName());
        for (AgentConfigOuterClass.AgentConfig.MBeanAttribute mbeanAttribute : config.getMbeanAttributeList()) {
            builder.addMbeanAttributes(ImmutableMBeanAttribute.builder().name(mbeanAttribute.getName()).counter(mbeanAttribute.getCounter()).build());
        }
        return builder.build();
    }

    @Value.Immutable
    @Styles.AllParameters
    public static abstract class MBeanAttribute {
        public abstract String name();

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @Value.Default
        public boolean counter() {
            return false;
        }
    }
}

