/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.netty.handler.codec.compression;

import org.glowroot.agent.shaded.io.netty.buffer.ByteBuf;
import org.glowroot.agent.shaded.io.netty.handler.codec.compression.Crc32c;

public final class Snappy {
    private State state = State.READING_PREAMBLE;

    public void encode(ByteBuf in, ByteBuf out, int length) {
        int inIndex;
        int b;
        int i = 0;
        while (true) {
            if (((b = length >>> i * 7) & 0xFFFFFF80) == 0) break;
            out.writeByte(b & 0x7F | 0x80);
            ++i;
        }
        out.writeByte(b);
        int baseIndex = inIndex = in.readerIndex();
        short[] table = Snappy.getHashTable(length);
        int shift = Integer.numberOfLeadingZeros(table.length) + 1;
        int nextEmit = inIndex;
        if (length - inIndex >= 15) {
            int nextHash = Snappy.hash(in, ++inIndex, shift);
            block1: while (true) {
                int insertTail;
                int candidate;
                int skip = 32;
                int nextIndex = inIndex;
                do {
                    int bytesBetweenHashLookups;
                    inIndex = nextIndex;
                    int hash = nextHash;
                    if ((nextIndex = inIndex + (bytesBetweenHashLookups = skip++ >> 5)) > length - 4) break block1;
                    nextHash = Snappy.hash(in, nextIndex, shift);
                    candidate = baseIndex + table[hash];
                    table[hash] = (short)(inIndex - baseIndex);
                } while (in.getInt(inIndex) != in.getInt(candidate));
                Snappy.encodeLiteral(in, out, inIndex - nextEmit);
                do {
                    int base = inIndex;
                    int matched = 4 + Snappy.findMatchingLength(in, candidate + 4, inIndex + 4, length);
                    int offset = base - candidate;
                    Snappy.encodeCopy(out, offset, matched);
                    in.readerIndex(in.readerIndex() + matched);
                    insertTail = (inIndex += matched) - 1;
                    nextEmit = inIndex;
                    if (inIndex >= length - 4) break block1;
                    int prevHash = Snappy.hash(in, insertTail, shift);
                    table[prevHash] = (short)(inIndex - baseIndex - 1);
                    int currentHash = Snappy.hash(in, insertTail + 1, shift);
                    candidate = baseIndex + table[currentHash];
                    table[currentHash] = (short)(inIndex - baseIndex);
                } while (in.getInt(insertTail + 1) == in.getInt(candidate));
                nextHash = Snappy.hash(in, insertTail + 2, shift);
                ++inIndex;
            }
        }
        if (nextEmit < length) {
            Snappy.encodeLiteral(in, out, length - nextEmit);
        }
    }

    private static int hash(ByteBuf in, int index, int shift) {
        return in.getInt(index) * 506832829 >>> shift;
    }

    private static short[] getHashTable(int inputSize) {
        int htSize;
        for (htSize = 256; htSize < 16384 && htSize < inputSize; htSize <<= 1) {
        }
        return new short[htSize];
    }

    private static int findMatchingLength(ByteBuf in, int minIndex, int inIndex, int maxIndex) {
        int matched = 0;
        while (inIndex <= maxIndex - 4 && in.getInt(inIndex) == in.getInt(minIndex + matched)) {
            inIndex += 4;
            matched += 4;
        }
        while (inIndex < maxIndex && in.getByte(minIndex + matched) == in.getByte(inIndex)) {
            ++inIndex;
            ++matched;
        }
        return matched;
    }

    private static int bitsToEncode(int value) {
        int highestOneBit = Integer.highestOneBit(value);
        int bitLength = 0;
        while ((highestOneBit >>= 1) != 0) {
            ++bitLength;
        }
        return bitLength;
    }

    static void encodeLiteral(ByteBuf in, ByteBuf out, int length) {
        if (length < 61) {
            out.writeByte(length - 1 << 2);
        } else {
            int bitLength = Snappy.bitsToEncode(length - 1);
            int bytesToEncode = 1 + bitLength / 8;
            out.writeByte(59 + bytesToEncode << 2);
            for (int i = 0; i < bytesToEncode; ++i) {
                out.writeByte(length - 1 >> i * 8 & 0xFF);
            }
        }
        out.writeBytes(in, length);
    }

    private static void encodeCopyWithOffset(ByteBuf out, int offset, int length) {
        if (length < 12 && offset < 2048) {
            out.writeByte(1 | length - 4 << 2 | offset >> 8 << 5);
            out.writeByte(offset & 0xFF);
        } else {
            out.writeByte(2 | length - 1 << 2);
            out.writeByte(offset & 0xFF);
            out.writeByte(offset >> 8 & 0xFF);
        }
    }

    private static void encodeCopy(ByteBuf out, int offset, int length) {
        while (length >= 68) {
            Snappy.encodeCopyWithOffset(out, offset, 64);
            length -= 64;
        }
        if (length > 64) {
            Snappy.encodeCopyWithOffset(out, offset, 60);
            length -= 60;
        }
        Snappy.encodeCopyWithOffset(out, offset, length);
    }

    static int calculateChecksum(ByteBuf data) {
        return Snappy.calculateChecksum(data, data.readerIndex(), data.readableBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int calculateChecksum(ByteBuf data, int offset, int length) {
        Crc32c crc32 = new Crc32c();
        try {
            crc32.update(data, offset, length);
            int n = Snappy.maskChecksum(crc32.getValue());
            return n;
        }
        finally {
            crc32.reset();
        }
    }

    static int maskChecksum(long checksum) {
        return (int)((checksum >> 15 | checksum << 17) + -1568478504L);
    }

    private static enum State {
        READING_PREAMBLE,
        READING_TAG,
        READING_LITERAL,
        READING_COPY;

    }
}

