/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.grpc.internal;

import java.util.ArrayList;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.io.grpc.ConnectivityState;

@NotThreadSafe
final class ConnectivityStateManager {
    private ArrayList<Listener> listeners = new ArrayList();
    private volatile ConnectivityState state = ConnectivityState.IDLE;

    ConnectivityStateManager() {
    }

    void gotoState(@Nonnull ConnectivityState newState) {
        Preconditions.checkNotNull(newState, "newState");
        if (this.state != newState && this.state != ConnectivityState.SHUTDOWN) {
            this.state = newState;
            if (this.listeners.isEmpty()) {
                return;
            }
            ArrayList<Listener> savedListeners = this.listeners;
            this.listeners = new ArrayList();
            for (Listener listener : savedListeners) {
                listener.runInExecutor();
            }
        }
    }

    private static final class Listener {
        final Runnable callback;
        final Executor executor;

        void runInExecutor() {
            this.executor.execute(this.callback);
        }
    }
}

