/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.grpc;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import org.glowroot.agent.shaded.io.grpc.ChannelCredentials;

public final class TlsChannelCredentials
extends ChannelCredentials {
    private final boolean fakeFeature;
    private final byte[] certificateChain;
    private final byte[] privateKey;
    private final String privateKeyPassword;
    private final List<KeyManager> keyManagers;
    private final byte[] rootCertificates;
    private final List<TrustManager> trustManagers;

    public byte[] getCertificateChain() {
        if (this.certificateChain == null) {
            return null;
        }
        return Arrays.copyOf(this.certificateChain, this.certificateChain.length);
    }

    public byte[] getPrivateKey() {
        if (this.privateKey == null) {
            return null;
        }
        return Arrays.copyOf(this.privateKey, this.privateKey.length);
    }

    public String getPrivateKeyPassword() {
        return this.privateKeyPassword;
    }

    public List<KeyManager> getKeyManagers() {
        return this.keyManagers;
    }

    public byte[] getRootCertificates() {
        if (this.rootCertificates == null) {
            return null;
        }
        return Arrays.copyOf(this.rootCertificates, this.rootCertificates.length);
    }

    public List<TrustManager> getTrustManagers() {
        return this.trustManagers;
    }

    public Set<Feature> incomprehensible(Set<Feature> understoodFeatures) {
        EnumSet<Feature> incomprehensible = EnumSet.noneOf(Feature.class);
        if (this.fakeFeature) {
            TlsChannelCredentials.requiredFeature(understoodFeatures, incomprehensible, Feature.FAKE);
        }
        if (this.rootCertificates != null || this.privateKey != null || this.keyManagers != null) {
            TlsChannelCredentials.requiredFeature(understoodFeatures, incomprehensible, Feature.MTLS);
        }
        if (this.keyManagers != null || this.trustManagers != null) {
            TlsChannelCredentials.requiredFeature(understoodFeatures, incomprehensible, Feature.CUSTOM_MANAGERS);
        }
        return Collections.unmodifiableSet(incomprehensible);
    }

    private static void requiredFeature(Set<Feature> understoodFeatures, Set<Feature> incomprehensible, Feature feature) {
        if (!understoodFeatures.contains((Object)feature)) {
            incomprehensible.add(feature);
        }
    }

    @Override
    public ChannelCredentials withoutBearerTokens() {
        return this;
    }

    public static enum Feature {
        FAKE,
        MTLS,
        CUSTOM_MANAGERS;

    }
}

