/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.com.fasterxml.jackson.datatype.guava.deser.cache;

import java.io.Closeable;
import java.io.IOException;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.JsonParser;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.JsonToken;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.BeanProperty;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.JavaType;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.KeyDeserializer;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.deser.NullValueProvider;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.deser.impl.NullsConstantProvider;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.type.LogicalType;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.type.MapLikeType;
import org.glowroot.agent.shaded.com.google.common.cache.Cache;

public abstract class GuavaCacheDeserializer<T extends Cache<Object, Object>>
extends StdDeserializer<T>
implements ContextualDeserializer {
    private final MapLikeType type;
    private final KeyDeserializer keyDeserializer;
    private final TypeDeserializer elementTypeDeserializer;
    private final JsonDeserializer<?> elementDeserializer;
    private final NullValueProvider nullProvider;
    private final boolean skipNullValues;

    public GuavaCacheDeserializer(MapLikeType type, KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) {
        this(type, keyDeserializer, elementTypeDeserializer, elementDeserializer, null);
    }

    public GuavaCacheDeserializer(MapLikeType type, KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer, NullValueProvider nvp) {
        super(type);
        this.type = type;
        this.keyDeserializer = keyDeserializer;
        this.elementTypeDeserializer = elementTypeDeserializer;
        this.elementDeserializer = elementDeserializer;
        this.nullProvider = nvp;
        this.skipNullValues = nvp == null ? false : NullsConstantProvider.isSkipper(nvp);
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        KeyDeserializer kd = this.keyDeserializer;
        if (kd == null) {
            kd = ctxt.findKeyDeserializer(this.type.getKeyType(), property);
        }
        JsonDeserializer<Object> valueDeser = this.elementDeserializer;
        JavaType vt = this.type.getContentType();
        valueDeser = valueDeser == null ? ctxt.findContextualValueDeserializer(vt, property) : ctxt.handleSecondaryContextualization(valueDeser, property, vt);
        TypeDeserializer vtd = this.elementTypeDeserializer;
        if (vtd != null) {
            vtd = vtd.forProperty(property);
        }
        return this._createContextual(this.type, kd, vtd, valueDeser, this.findContentNullProvider(ctxt, property, valueDeser));
    }

    protected abstract T createCache();

    protected abstract JsonDeserializer<?> _createContextual(MapLikeType var1, KeyDeserializer var2, TypeDeserializer var3, JsonDeserializer<?> var4, NullValueProvider var5);

    @Override
    public LogicalType logicalType() {
        return LogicalType.Map;
    }

    @Override
    public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        return this.deserializeContents(p, ctxt);
    }

    private T deserializeContents(JsonParser p, DeserializationContext ctxt) throws IOException {
        T cache = this.createCache();
        JsonToken currToken = p.currentToken();
        if (currToken != JsonToken.FIELD_NAME && currToken != JsonToken.END_OBJECT) {
            this.expect(p, JsonToken.START_OBJECT);
            currToken = p.nextToken();
        }
        while (currToken == JsonToken.FIELD_NAME) {
            block3: {
                Object value;
                Object key;
                block4: {
                    block2: {
                        key = this.keyDeserializer != null ? this.keyDeserializer.deserializeKey(p.currentName(), ctxt) : p.currentName();
                        p.nextToken();
                        if (p.currentToken() != JsonToken.VALUE_NULL) break block2;
                        if (this.skipNullValues) break block3;
                        value = this.nullProvider.getNullValue(ctxt);
                        break block4;
                    }
                    value = this.elementTypeDeserializer != null ? this.elementDeserializer.deserializeWithType(p, ctxt, this.elementTypeDeserializer) : this.elementDeserializer.deserialize(p, ctxt);
                }
                cache.put((Object)key, (Object)value);
            }
            currToken = p.nextToken();
        }
        return cache;
    }

    private void expect(JsonParser p, JsonToken token) throws IOException {
        if (p.getCurrentToken() != token) {
            throw new JsonMappingException((Closeable)p, "Expecting " + (Object)((Object)token) + " to start `Cache` value, found " + (Object)((Object)p.currentToken()), p.getCurrentLocation());
        }
    }
}

