/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.com.fasterxml.jackson.core;

import java.io.Serializable;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.exc.StreamConstraintsException;

public class StreamReadConstraints
implements Serializable {
    protected final int _maxNestingDepth;
    protected final long _maxDocLen;
    protected final int _maxNumLen;
    protected final int _maxStringLen;
    protected final int _maxNameLen;
    private static StreamReadConstraints DEFAULT = new StreamReadConstraints(1000, -1L, 1000, 20000000, 50000);

    protected StreamReadConstraints(int maxNestingDepth, long maxDocLen, int maxNumLen, int maxStringLen, int maxNameLen) {
        this._maxNestingDepth = maxNestingDepth;
        this._maxDocLen = maxDocLen;
        this._maxNumLen = maxNumLen;
        this._maxStringLen = maxStringLen;
        this._maxNameLen = maxNameLen;
    }

    public static StreamReadConstraints defaults() {
        return DEFAULT;
    }

    public void validateNestingDepth(int depth) throws StreamConstraintsException {
        if (depth > this._maxNestingDepth) {
            throw this._constructException("Document nesting depth (%d) exceeds the maximum allowed (%d, from %s)", depth, this._maxNestingDepth, this._constrainRef("getMaxNestingDepth"));
        }
    }

    public void validateDocumentLength(long len) throws StreamConstraintsException {
        if (len > this._maxDocLen && this._maxDocLen > 0L) {
            throw this._constructException("Document length (%d) exceeds the maximum allowed (%d, from %s)", len, this._maxDocLen, this._constrainRef("getMaxDocumentLength"));
        }
    }

    public void validateFPLength(int length) throws StreamConstraintsException {
        if (length > this._maxNumLen) {
            throw this._constructException("Number value length (%d) exceeds the maximum allowed (%d, from %s)", length, this._maxNumLen, this._constrainRef("getMaxNumberLength"));
        }
    }

    public void validateIntegerLength(int length) throws StreamConstraintsException {
        if (length > this._maxNumLen) {
            throw this._constructException("Number value length (%d) exceeds the maximum allowed (%d, from %s)", length, this._maxNumLen, this._constrainRef("getMaxNumberLength"));
        }
    }

    public void validateStringLength(int length) throws StreamConstraintsException {
        if (length > this._maxStringLen) {
            throw this._constructException("String value length (%d) exceeds the maximum allowed (%d, from %s)", length, this._maxStringLen, this._constrainRef("getMaxStringLength"));
        }
    }

    public void validateNameLength(int length) throws StreamConstraintsException {
        if (length > this._maxNameLen) {
            throw this._constructException("Name length (%d) exceeds the maximum allowed (%d, from %s)", length, this._maxNameLen, this._constrainRef("getMaxNameLength"));
        }
    }

    public void validateBigIntegerScale(int scale) throws StreamConstraintsException {
        int absScale = Math.abs(scale);
        int limit = 100000;
        if (absScale > 100000) {
            throw this._constructException("BigDecimal scale (%d) magnitude exceeds the maximum allowed (%d)", scale, 100000);
        }
    }

    protected StreamConstraintsException _constructException(String msgTemplate, Object ... args) throws StreamConstraintsException {
        throw new StreamConstraintsException(String.format(msgTemplate, args));
    }

    protected String _constrainRef(String method) {
        return "`StreamReadConstraints." + method + "()`";
    }
}

