/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.play;

import org.glowroot.agent.plugin.api.Agent;
import org.glowroot.agent.plugin.api.MessageSupplier;
import org.glowroot.agent.plugin.api.OptionalThreadContext;
import org.glowroot.agent.plugin.api.ThreadContext;
import org.glowroot.agent.plugin.api.TimerName;
import org.glowroot.agent.plugin.api.TraceEntry;
import org.glowroot.agent.plugin.api.weaving.BindClassMeta;
import org.glowroot.agent.plugin.api.weaving.BindParameter;
import org.glowroot.agent.plugin.api.weaving.BindThrowable;
import org.glowroot.agent.plugin.api.weaving.BindTraveler;
import org.glowroot.agent.plugin.api.weaving.OnBefore;
import org.glowroot.agent.plugin.api.weaving.OnReturn;
import org.glowroot.agent.plugin.api.weaving.OnThrow;
import org.glowroot.agent.plugin.api.weaving.Pointcut;
import org.glowroot.agent.plugin.play.PlayInvoker;

public class Play1xAspect {

    @Pointcut(className="play.mvc.ActionInvoker", methodName="invoke", methodParameterTypes={"play.mvc.Http$Request", "play.mvc.Http$Response"}, timerName="http request")
    public static class ActionInvokerAdvice {
        private static final TimerName timerName = Agent.getTimerName(ActionInvokerAdvice.class);

        @OnBefore
        public static TraceEntry onBefore(OptionalThreadContext context) {
            return context.startTraceEntry(MessageSupplier.create("play action invoker"), timerName);
        }

        @OnReturn
        public static void onReturn(ThreadContext context, @BindTraveler TraceEntry traceEntry, @BindParameter Object request, @BindClassMeta PlayInvoker invoker) {
            String action = invoker.getAction(request);
            if (action != null) {
                int index = action.lastIndexOf(46);
                if (index != -1) {
                    action = action.substring(0, index) + '#' + action.substring(index + 1);
                }
                context.setTransactionName(action, -100);
            }
            traceEntry.end();
        }

        @OnThrow
        public static void onThrow(@BindThrowable Throwable t, @BindTraveler TraceEntry traceEntry) {
            traceEntry.endWithError(t);
        }
    }
}

