/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.netty;

import org.glowroot.agent.plugin.api.Agent;
import org.glowroot.agent.plugin.api.AuxThreadContext;
import org.glowroot.agent.plugin.api.OptionalThreadContext;
import org.glowroot.agent.plugin.api.ThreadContext;
import org.glowroot.agent.plugin.api.TimerName;
import org.glowroot.agent.plugin.api.TraceEntry;
import org.glowroot.agent.plugin.api.checker.Nullable;
import org.glowroot.agent.plugin.api.weaving.BindParameter;
import org.glowroot.agent.plugin.api.weaving.BindReceiver;
import org.glowroot.agent.plugin.api.weaving.BindThrowable;
import org.glowroot.agent.plugin.api.weaving.BindTraveler;
import org.glowroot.agent.plugin.api.weaving.IsEnabled;
import org.glowroot.agent.plugin.api.weaving.Mixin;
import org.glowroot.agent.plugin.api.weaving.OnBefore;
import org.glowroot.agent.plugin.api.weaving.OnReturn;
import org.glowroot.agent.plugin.api.weaving.OnThrow;
import org.glowroot.agent.plugin.api.weaving.Pointcut;
import org.glowroot.agent.plugin.api.weaving.Shim;
import org.glowroot.agent.plugin.netty.bclglowrootbcl.Util;

public class Netty3Aspect {

    @Pointcut(className="org.jboss.netty.channel.Channel", methodName="close", methodParameterTypes={})
    public static class CloseAdvice {
        @OnBefore
        public static void onBefore(ThreadContext context) {
            context.setTransactionAsyncComplete();
        }
    }

    @Pointcut(className="org.jboss.netty.channel.ChannelFutureListener", methodName="operationComplete", methodParameterTypes={"org.jboss.netty.channel.ChannelFuture"})
    public static class OperationCompleteAdvice {
        @IsEnabled
        public static boolean isEnabled(@BindReceiver ListenerMixin listener) {
            return listener.glowroot$getAuxContext() != null;
        }

        @OnBefore
        public static TraceEntry onBefore(@BindReceiver ListenerMixin listener) {
            AuxThreadContext auxContext = listener.glowroot$getAuxContext();
            listener.glowroot$setAuxContext(null);
            return auxContext.start();
        }

        @OnReturn
        public static void onReturn(@BindTraveler TraceEntry traceEntry) {
            traceEntry.end();
        }

        @OnThrow
        public static void onThrow(@BindThrowable Throwable t, @BindTraveler TraceEntry traceEntry) {
            traceEntry.endWithError(t);
        }
    }

    @Pointcut(className="org.jboss.netty.channel.ChannelFuture", methodName="addListener", methodParameterTypes={"org.jboss.netty.channel.ChannelFutureListener"})
    public static class AddListenerAdvice {
        @OnBefore
        public static void onBefore(ThreadContext context, @BindParameter ListenerMixin listener) {
            AuxThreadContext auxContext = context.createAuxThreadContext();
            listener.glowroot$setAuxContext(auxContext);
        }
    }

    @Pointcut(className="org.jboss.netty.channel.ChannelDownstreamHandler", methodName="handleDownstream", methodParameterTypes={"org.jboss.netty.channel.ChannelHandlerContext", "org.jboss.netty.channel.ChannelEvent"})
    public static class OutboundAdvice {
        @IsEnabled
        public static boolean isEnabled(@BindParameter @Nullable ChannelHandlerContextShim channelHandlerContext) {
            if (channelHandlerContext == null) {
                return false;
            }
            ChannelMixin channel = channelHandlerContext.glowroot$getChannel();
            return channel != null && channel.glowroot$getCompleteAsyncTransaction();
        }

        @OnBefore
        public static void onBefore(ThreadContext context, @BindParameter @Nullable ChannelHandlerContextShim channelHandlerContext, @BindParameter @Nullable Object channelEvent) {
            if (channelHandlerContext == null) {
                return;
            }
            if (channelEvent instanceof OrderedDownstreamChannelEventShim) {
                if (((OrderedDownstreamChannelEventShim)channelEvent).isLast()) {
                    OutboundAdvice.completeAsyncTransaction(context, channelHandlerContext);
                }
                return;
            }
            if (!(channelEvent instanceof MessageEventShim)) {
                return;
            }
            Object messageEvent = ((MessageEventShim)channelEvent).getMessage();
            if (messageEvent instanceof HttpMessageShim) {
                if (!((HttpMessageShim)messageEvent).isChunked()) {
                    OutboundAdvice.completeAsyncTransaction(context, channelHandlerContext);
                }
                return;
            }
            if (messageEvent instanceof HttpChunkShim) {
                if (((HttpChunkShim)messageEvent).isLast()) {
                    OutboundAdvice.completeAsyncTransaction(context, channelHandlerContext);
                }
                return;
            }
        }

        private static void completeAsyncTransaction(ThreadContext context, ChannelHandlerContextShim channelHandlerContext) {
            context.setTransactionAsyncComplete();
            ChannelMixin channel = channelHandlerContext.glowroot$getChannel();
            if (channel != null) {
                channel.glowroot$setCompleteAsyncTransaction(false);
            }
        }
    }

    @Shim(value={"com.typesafe.netty.http.pipelining.OrderedDownstreamChannelEvent"})
    public static interface OrderedDownstreamChannelEventShim {
        public boolean isLast();
    }

    @Pointcut(className="org.jboss.netty.channel.ChannelHandlerContext", methodName="sendUpstream", methodParameterTypes={"org.jboss.netty.channel.ChannelEvent"}, nestingGroup="netty-inbound", timerName="http request")
    public static class InboundAdvice {
        private static final TimerName timerName = Agent.getTimerName(InboundAdvice.class);

        @IsEnabled
        public static boolean isEnabled(@BindReceiver ChannelHandlerContextShim channelHandlerContext, @BindParameter @Nullable Object channelEvent) {
            return channelHandlerContext.glowroot$getChannel() != null && channelEvent != null && channelEvent instanceof MessageEventShim && ((MessageEventShim)channelEvent).getMessage() instanceof HttpRequestShim;
        }

        @OnBefore
        public static TraceEntry onBefore(OptionalThreadContext context, @BindReceiver ChannelHandlerContextShim channelHandlerContext, @BindParameter Object channelEvent) {
            ChannelMixin channel = channelHandlerContext.glowroot$getChannel();
            Object msg = ((MessageEventShim)channelEvent).getMessage();
            HttpRequestShim request = (HttpRequestShim)msg;
            HttpMethodShim method = request.glowroot$getMethod();
            String methodName = method == null ? null : method.getName();
            channel.glowroot$setCompleteAsyncTransaction(true);
            return Util.startAsyncTransaction(context, methodName, request.getUri(), timerName);
        }

        @OnReturn
        public static void onReturn(@BindTraveler TraceEntry traceEntry) {
            traceEntry.end();
        }

        @OnThrow
        public static void onThrow(@BindThrowable Throwable t, @BindTraveler TraceEntry traceEntry) {
            traceEntry.endWithError(t);
        }
    }

    @Shim(value={"org.jboss.netty.handler.codec.http.HttpChunk"})
    public static interface HttpChunkShim {
        public boolean isLast();
    }

    @Shim(value={"org.jboss.netty.handler.codec.http.HttpMessage"})
    public static interface HttpMessageShim {
        public boolean isChunked();
    }

    @Shim(value={"org.jboss.netty.channel.MessageEvent"})
    public static interface MessageEventShim {
        @Nullable
        public Object getMessage();
    }

    @Shim(value={"org.jboss.netty.handler.codec.http.HttpMethod"})
    public static interface HttpMethodShim {
        @Nullable
        public String getName();
    }

    @Shim(value={"org.jboss.netty.handler.codec.http.HttpRequest"})
    public static interface HttpRequestShim {
        @Shim(value={"org.jboss.netty.handler.codec.http.HttpMethod getMethod()"})
        public HttpMethodShim glowroot$getMethod();

        @Nullable
        public String getUri();
    }

    @Shim(value={"org.jboss.netty.channel.ChannelHandlerContext"})
    public static interface ChannelHandlerContextShim {
        @Shim(value={"org.jboss.netty.channel.Channel getChannel()"})
        @Nullable
        public ChannelMixin glowroot$getChannel();
    }

    public static interface ListenerMixin {
        @Nullable
        public AuxThreadContext glowroot$getAuxContext();

        public void glowroot$setAuxContext(@Nullable AuxThreadContext var1);
    }

    @Mixin(value={"org.jboss.netty.channel.ChannelFutureListener"})
    public static abstract class ListenerImpl
    implements ListenerMixin {
        @Nullable
        private volatile transient AuxThreadContext glowroot$auxContext;

        @Override
        @Nullable
        public AuxThreadContext glowroot$getAuxContext() {
            return this.glowroot$auxContext;
        }

        @Override
        public void glowroot$setAuxContext(@Nullable AuxThreadContext auxContext) {
            this.glowroot$auxContext = auxContext;
        }
    }

    public static interface ChannelMixin {
        public boolean glowroot$getCompleteAsyncTransaction();

        public void glowroot$setCompleteAsyncTransaction(boolean var1);
    }

    @Mixin(value={"org.jboss.netty.channel.Channel"})
    public static abstract class ChannelImpl
    implements ChannelMixin {
        private volatile transient boolean glowroot$completeAsyncTransaction;

        @Override
        public boolean glowroot$getCompleteAsyncTransaction() {
            return this.glowroot$completeAsyncTransaction;
        }

        @Override
        public void glowroot$setCompleteAsyncTransaction(boolean completeAsyncTransaction) {
            this.glowroot$completeAsyncTransaction = completeAsyncTransaction;
        }
    }
}

