/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.logger;

import org.glowroot.agent.plugin.api.Agent;
import org.glowroot.agent.plugin.api.Message;
import org.glowroot.agent.plugin.api.MessageSupplier;
import org.glowroot.agent.plugin.api.ThreadContext;
import org.glowroot.agent.plugin.api.TimerName;
import org.glowroot.agent.plugin.api.TraceEntry;
import org.glowroot.agent.plugin.api.checker.Nullable;
import org.glowroot.agent.plugin.api.weaving.BindParameter;
import org.glowroot.agent.plugin.api.weaving.BindReceiver;
import org.glowroot.agent.plugin.api.weaving.BindTraveler;
import org.glowroot.agent.plugin.api.weaving.OnAfter;
import org.glowroot.agent.plugin.api.weaving.OnBefore;
import org.glowroot.agent.plugin.api.weaving.Pointcut;
import org.glowroot.agent.plugin.api.weaving.Shim;
import org.glowroot.agent.plugin.logger.LoggerPlugin;

public class Log4jAspect {
    private static final String TIMER_NAME = "logging";
    private static final int OFF_INT = Integer.MAX_VALUE;
    private static final int FATAL_INT = 50000;
    private static final int ERROR_INT = 40000;
    private static final int WARN_INT = 30000;
    private static final int INFO_INT = 20000;
    private static final int DEBUG_INT = 10000;
    private static final int ALL_INT = Integer.MIN_VALUE;

    private static class LogMessageSupplier
    extends MessageSupplier {
        private final int level;
        @Nullable
        private final String loggerName;
        private final String messageText;

        private LogMessageSupplier(int level, @Nullable String loggerName, String messageText) {
            this.level = level;
            this.loggerName = loggerName;
            this.messageText = messageText;
        }

        @Override
        public Message get() {
            return Message.create("log {}: {} - {}", LogMessageSupplier.getLevelStr(this.level), LoggerPlugin.getAbbreviatedLoggerName(this.loggerName), this.messageText);
        }

        private static String getLevelStr(int lvl) {
            switch (lvl) {
                case -2147483648: {
                    return "all";
                }
                case 10000: {
                    return "debug";
                }
                case 20000: {
                    return "info";
                }
                case 30000: {
                    return "warn";
                }
                case 40000: {
                    return "error";
                }
                case 50000: {
                    return "fatal";
                }
                case 0x7FFFFFFF: {
                    return "off";
                }
            }
            return "unknown (" + lvl + ")";
        }
    }

    @Pointcut(className="org.apache.log4j.Category", methodName="forcedLog", methodParameterTypes={"java.lang.String", "org.apache.log4j.Priority", "java.lang.Object", "java.lang.Throwable"}, nestingGroup="logging", timerName="logging")
    public static class ForcedLogAdvice {
        private static final TimerName timerName = Agent.getTimerName(ForcedLogAdvice.class);

        @OnBefore
        public static TraceEntry onBefore(ThreadContext context, @BindReceiver Logger logger, @BindParameter @Nullable String fqcn, @BindParameter @Nullable Level level, @BindParameter @Nullable Object message, @BindParameter @Nullable Throwable t) {
            String messageText = String.valueOf(message);
            int lvl = level == null ? 0 : level.toInt();
            if (LoggerPlugin.markTraceAsError(lvl >= 40000, lvl >= 30000, t != null)) {
                context.setTransactionError(messageText, t);
            }
            return context.startTraceEntry(new LogMessageSupplier(lvl, logger.getName(), messageText), timerName);
        }

        @OnAfter
        public static void onAfter(@BindTraveler TraceEntry traceEntry, @BindParameter @Nullable String fqcn, @BindParameter @Nullable Level level, @BindParameter @Nullable Object message, @BindParameter @Nullable Throwable t) {
            int lvl;
            int n = lvl = level == null ? 0 : level.toInt();
            if (t != null) {
                if (lvl >= 30000) {
                    traceEntry.endWithError(t);
                } else {
                    traceEntry.endWithInfo(t);
                }
            } else if (lvl >= 30000) {
                traceEntry.endWithError(String.valueOf(message));
            } else {
                traceEntry.end();
            }
        }
    }

    @Shim(value={"org.apache.log4j.Priority"})
    public static interface Level {
        public int toInt();
    }

    @Shim(value={"org.apache.log4j.Category"})
    public static interface Logger {
        @Nullable
        public String getName();
    }
}

