/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.logger;

import org.glowroot.agent.plugin.api.Agent;
import org.glowroot.agent.plugin.api.MessageSupplier;
import org.glowroot.agent.plugin.api.ThreadContext;
import org.glowroot.agent.plugin.api.TimerName;
import org.glowroot.agent.plugin.api.TraceEntry;
import org.glowroot.agent.plugin.api.checker.Nullable;
import org.glowroot.agent.plugin.api.weaving.BindParameter;
import org.glowroot.agent.plugin.api.weaving.BindReceiver;
import org.glowroot.agent.plugin.api.weaving.BindTraveler;
import org.glowroot.agent.plugin.api.weaving.OnAfter;
import org.glowroot.agent.plugin.api.weaving.OnBefore;
import org.glowroot.agent.plugin.api.weaving.Pointcut;
import org.glowroot.agent.plugin.api.weaving.Shim;
import org.glowroot.agent.plugin.logger.LoggerPlugin;

public class Log4j2xAspect {
    private static final String TIMER_NAME = "logging";
    private static final int OFF = 0;
    private static final int FATAL = 100;
    private static final int ERROR = 200;
    private static final int WARN = 300;
    private static final int INFO = 400;
    private static final int DEBUG = 500;
    private static final int TRACE = 600;
    private static final int ALL = Integer.MAX_VALUE;

    private static class LogAdviceTraveler {
        private final TraceEntry traceEntry;
        private final int level;
        private final String formattedMessage;
        @Nullable
        private final Throwable throwable;

        private LogAdviceTraveler(TraceEntry traceEntry, int level, String formattedMessage, @Nullable Throwable throwable) {
            this.traceEntry = traceEntry;
            this.level = level;
            this.formattedMessage = formattedMessage;
            this.throwable = throwable;
        }
    }

    @Pointcut(className="org.apache.logging.log4j.spi.ExtendedLogger", methodName="logMessage", methodParameterTypes={"java.lang.String", "org.apache.logging.log4j.Level", "org.apache.logging.log4j.Marker", "org.apache.logging.log4j.message.Message", "java.lang.Throwable"}, nestingGroup="logging", timerName="logging")
    public static class CallAppendersAdvice {
        private static final TimerName timerName = Agent.getTimerName(CallAppendersAdvice.class);

        @OnBefore
        public static LogAdviceTraveler onBefore(ThreadContext context, @BindReceiver Logger logger, @BindParameter @Nullable String fqcn, @BindParameter @Nullable Level level, @BindParameter @Nullable Object marker, @BindParameter @Nullable Message message, @BindParameter @Nullable Throwable t) {
            String formattedMessage = message == null ? "" : CallAppendersAdvice.nullToEmpty(message.getFormattedMessage());
            int lvl = level == null ? 0 : level.intLevel();
            if (LoggerPlugin.markTraceAsError(lvl <= 200, lvl <= 300, t != null)) {
                context.setTransactionError(formattedMessage, t);
            }
            TraceEntry traceEntry = context.startTraceEntry(MessageSupplier.create("log {}: {} - {}", CallAppendersAdvice.getLevelStr(lvl), logger.getName(), formattedMessage), timerName);
            return new LogAdviceTraveler(traceEntry, lvl, formattedMessage, t);
        }

        @OnAfter
        public static void onAfter(@BindTraveler LogAdviceTraveler traveler) {
            Throwable t = traveler.throwable;
            if (t != null) {
                if (traveler.level <= 300) {
                    traveler.traceEntry.endWithError(t);
                } else {
                    traveler.traceEntry.endWithInfo(t);
                }
            } else if (traveler.level <= 300) {
                traveler.traceEntry.endWithError(traveler.formattedMessage);
            } else {
                traveler.traceEntry.end();
            }
        }

        private static String nullToEmpty(@Nullable String s) {
            return s == null ? "" : s;
        }

        private static String getLevelStr(int lvl) {
            switch (lvl) {
                case 0x7FFFFFFF: {
                    return "all";
                }
                case 600: {
                    return "trace";
                }
                case 500: {
                    return "debug";
                }
                case 400: {
                    return "info";
                }
                case 300: {
                    return "warn";
                }
                case 200: {
                    return "error";
                }
                case 100: {
                    return "fatal";
                }
                case 0: {
                    return "off";
                }
            }
            return "unknown (" + lvl + ")";
        }
    }

    @Shim(value={"org.apache.logging.log4j.message.Message"})
    public static interface Message {
        @Nullable
        public String getFormattedMessage();
    }

    @Shim(value={"org.apache.logging.log4j.Level"})
    public static interface Level {
        public int intLevel();
    }

    @Shim(value={"org.apache.logging.log4j.Logger"})
    public static interface Logger {
        @Nullable
        public String getName();
    }
}

