/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.kafka;

import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.glowroot.agent.plugin.api.Agent;
import org.glowroot.agent.plugin.api.AsyncTraceEntry;
import org.glowroot.agent.plugin.api.MessageSupplier;
import org.glowroot.agent.plugin.api.ParameterHolder;
import org.glowroot.agent.plugin.api.ThreadContext;
import org.glowroot.agent.plugin.api.TimerName;
import org.glowroot.agent.plugin.api.checker.Nullable;
import org.glowroot.agent.plugin.api.weaving.BindParameter;
import org.glowroot.agent.plugin.api.weaving.BindThrowable;
import org.glowroot.agent.plugin.api.weaving.BindTraveler;
import org.glowroot.agent.plugin.api.weaving.OnBefore;
import org.glowroot.agent.plugin.api.weaving.OnReturn;
import org.glowroot.agent.plugin.api.weaving.OnThrow;
import org.glowroot.agent.plugin.api.weaving.Pointcut;
import org.glowroot.agent.plugin.kafka.CallbackWrapper;
import org.glowroot.agent.plugin.kafka.CallbackWrapperForNullDelegate;

public class ProducerAspect {

    @Pointcut(className="org.apache.kafka.clients.producer.KafkaProducer", methodName="send", methodParameterTypes={"org.apache.kafka.clients.producer.ProducerRecord", "org.apache.kafka.clients.producer.Callback"}, nestingGroup="kafka-send", timerName="kafka send")
    public static class SendAdvice {
        private static final TimerName timerName = Agent.getTimerName(SendAdvice.class);

        @OnBefore
        @Nullable
        public static AsyncTraceEntry onBefore(ThreadContext context, @BindParameter @Nullable ProducerRecord<?, ?> record, @BindParameter ParameterHolder<Callback> callbackHolder) {
            if (record == null) {
                return null;
            }
            String topic = record.topic();
            if (topic == null) {
                topic = "";
            }
            AsyncTraceEntry asyncTraceEntry = context.startAsyncServiceCallEntry("Kafka", topic, MessageSupplier.create("kafka send: {}", topic), timerName);
            Callback callback = callbackHolder.get();
            if (callback == null) {
                callbackHolder.set(new CallbackWrapperForNullDelegate(asyncTraceEntry));
            } else {
                callbackHolder.set(new CallbackWrapper(callback, asyncTraceEntry, context.createAuxThreadContext()));
            }
            return asyncTraceEntry;
        }

        @OnReturn
        public static void onReturn(@BindTraveler @Nullable AsyncTraceEntry asyncTraceEntry) {
            if (asyncTraceEntry != null) {
                asyncTraceEntry.stopSyncTimer();
            }
        }

        @OnThrow
        public static void onThrow(@BindThrowable Throwable t, @BindTraveler @Nullable AsyncTraceEntry asyncTraceEntry) {
            if (asyncTraceEntry != null) {
                asyncTraceEntry.stopSyncTimer();
                asyncTraceEntry.endWithError(t);
            }
        }
    }
}

