/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.jdbc;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.glowroot.agent.plugin.api.Agent;
import org.glowroot.agent.plugin.api.QueryEntry;
import org.glowroot.agent.plugin.api.QueryMessageSupplier;
import org.glowroot.agent.plugin.api.ThreadContext;
import org.glowroot.agent.plugin.api.Timer;
import org.glowroot.agent.plugin.api.TimerName;
import org.glowroot.agent.plugin.api.checker.Nullable;
import org.glowroot.agent.plugin.api.config.BooleanProperty;
import org.glowroot.agent.plugin.api.config.ConfigListener;
import org.glowroot.agent.plugin.api.config.ConfigService;
import org.glowroot.agent.plugin.api.weaving.BindParameter;
import org.glowroot.agent.plugin.api.weaving.BindReceiver;
import org.glowroot.agent.plugin.api.weaving.BindReturn;
import org.glowroot.agent.plugin.api.weaving.BindThrowable;
import org.glowroot.agent.plugin.api.weaving.BindTraveler;
import org.glowroot.agent.plugin.api.weaving.IsEnabled;
import org.glowroot.agent.plugin.api.weaving.Mixin;
import org.glowroot.agent.plugin.api.weaving.OnAfter;
import org.glowroot.agent.plugin.api.weaving.OnBefore;
import org.glowroot.agent.plugin.api.weaving.OnReturn;
import org.glowroot.agent.plugin.api.weaving.OnThrow;
import org.glowroot.agent.plugin.api.weaving.Pointcut;
import org.glowroot.agent.plugin.api.weaving.Shim;
import org.glowroot.agent.plugin.jdbc.JdbcPluginProperties;
import org.glowroot.agent.plugin.jdbc.PreparedStatementMirror;
import org.glowroot.agent.plugin.jdbc.StatementMirror;
import org.glowroot.agent.plugin.jdbc.message.BatchPreparedStatementMessageSupplier;
import org.glowroot.agent.plugin.jdbc.message.BatchPreparedStatementMessageSupplier2;
import org.glowroot.agent.plugin.jdbc.message.PreparedStatementMessageSupplier;

public class StatementAspect {
    private static final String QUERY_TYPE = "SQL";
    private static final ConfigService configService = Agent.getConfigService("jdbc");
    private static final BooleanProperty captureStatementClose = configService.getBooleanProperty("captureStatementClose");
    private static boolean captureBindParameters;

    static {
        configService.registerConfigListener(new ConfigListener(){

            @Override
            public void onChange() {
                captureBindParameters = !configService.getListProperty("captureBindParametersIncludes").value().isEmpty();
            }
        });
    }

    @Pointcut(className="java.sql.Statement", methodName="close", methodParameterTypes={}, nestingGroup="jdbc", timerName="jdbc statement close")
    public static class CloseAdvice {
        private static final TimerName timerName = Agent.getTimerName(CloseAdvice.class);

        @IsEnabled
        public static boolean isEnabled(@BindReceiver HasStatementMirrorMixin statement) {
            return statement.glowroot$hasStatementMirror();
        }

        @OnBefore
        @Nullable
        public static Timer onBefore(ThreadContext context, @BindReceiver HasStatementMirrorMixin statement) {
            StatementMirror mirror = statement.glowroot$getStatementMirror();
            if (mirror != null) {
                mirror.clearLastQueryEntry();
            }
            if (captureStatementClose.value()) {
                return context.startTimer(timerName);
            }
            return null;
        }

        @OnAfter
        public static void onAfter(@BindTraveler @Nullable Timer timer) {
            if (timer != null) {
                timer.stop();
            }
        }
    }

    @Pointcut(className="java.sql.Statement", methodName="getResultSet", methodParameterTypes={".."}, methodReturnType="java.sql.ResultSet")
    public static class StatementGetResultSetAdvice {
        @IsEnabled
        public static boolean isEnabled(@BindReceiver HasStatementMirrorMixin statement) {
            return statement.glowroot$hasStatementMirror();
        }

        @OnReturn
        public static void onReturn(@BindReturn @Nullable HasStatementMirrorMixin resultSet, @BindReceiver HasStatementMirrorMixin statement) {
            if (resultSet == null) {
                return;
            }
            StatementMirror mirror = statement.glowroot$getStatementMirror();
            resultSet.glowroot$setStatementMirror(mirror);
        }
    }

    @Pointcut(className="java.sql.Statement", methodName="executeBatch", methodParameterTypes={}, nestingGroup="jdbc", timerName="jdbc query")
    public static class StatementExecuteBatchAdvice {
        private static final TimerName timerName = Agent.getTimerName(StatementExecuteBatchAdvice.class);

        @IsEnabled
        public static boolean isEnabled(@BindReceiver HasStatementMirrorMixin statement) {
            return statement.glowroot$hasStatementMirror();
        }

        @OnBefore
        public static QueryEntry onBefore(ThreadContext context, @BindReceiver HasStatementMirrorMixin statement) {
            StatementMirror mirror = statement.glowroot$getStatementMirror();
            if (statement instanceof PreparedStatement) {
                return StatementExecuteBatchAdvice.onBeforePreparedStatement(context, (PreparedStatementMirror)mirror);
            }
            return StatementExecuteBatchAdvice.onBeforeStatement(mirror, context);
        }

        @OnReturn
        public static void onReturn(@BindReturn int[] rowCounts, @BindTraveler QueryEntry queryEntry) {
            int totalRowCount = 0;
            boolean count = false;
            for (int rowCount : rowCounts) {
                if (rowCount <= 0) continue;
                totalRowCount += rowCount;
                count = true;
            }
            if (count) {
                queryEntry.setCurrRow(totalRowCount);
            }
            queryEntry.endWithLocationStackTrace(JdbcPluginProperties.stackTraceThresholdMillis(), TimeUnit.MILLISECONDS);
        }

        @OnThrow
        public static void onThrow(@BindThrowable Throwable t, @BindTraveler QueryEntry queryEntry) {
            queryEntry.endWithError(t);
        }

        private static QueryEntry onBeforePreparedStatement(ThreadContext context, PreparedStatementMirror mirror) {
            QueryMessageSupplier queryMessageSupplier;
            String queryText = mirror.getSql();
            int batchSize = mirror.getBatchSize();
            if (batchSize <= 0) {
                queryText = "[empty batch] " + queryText;
                queryMessageSupplier = QueryMessageSupplier.create("jdbc query: ");
                batchSize = 1;
            } else {
                queryMessageSupplier = captureBindParameters ? new BatchPreparedStatementMessageSupplier(mirror.getBatchedParameters(), batchSize) : new BatchPreparedStatementMessageSupplier2(batchSize);
            }
            QueryEntry queryEntry = context.startQueryEntry(StatementAspect.QUERY_TYPE, queryText, batchSize, queryMessageSupplier, timerName);
            mirror.setLastQueryEntry(queryEntry);
            mirror.clearBatch();
            return queryEntry;
        }

        private static QueryEntry onBeforeStatement(StatementMirror mirror, ThreadContext context) {
            String concatenated;
            List<String> batchedSql = mirror.getBatchedSql();
            if (batchedSql.isEmpty()) {
                concatenated = "[empty batch]";
            } else {
                StringBuilder sb = new StringBuilder("[batch] ");
                boolean first = true;
                for (String sql : batchedSql) {
                    if (!first) {
                        sb.append(", ");
                    }
                    sb.append(sql);
                    first = false;
                }
                concatenated = sb.toString();
            }
            QueryEntry queryEntry = context.startQueryEntry(StatementAspect.QUERY_TYPE, concatenated, QueryMessageSupplier.create("jdbc query: "), timerName);
            mirror.setLastQueryEntry(queryEntry);
            mirror.clearBatch();
            return queryEntry;
        }
    }

    @Pointcut(className="java.sql.PreparedStatement", methodName="executeUpdate", methodParameterTypes={}, methodReturnType="int", nestingGroup="jdbc")
    public static class PreparedStatementExecuteUpdateAdvice {
        @IsEnabled
        public static boolean isEnabled(@BindReceiver HasStatementMirrorMixin preparedStatement) {
            return preparedStatement.glowroot$hasStatementMirror();
        }

        @OnBefore
        public static QueryEntry onBefore(ThreadContext context, @BindReceiver HasStatementMirrorMixin preparedStatement) {
            return PreparedStatementExecuteAdvice.onBefore(context, preparedStatement);
        }

        @OnReturn
        public static void onReturn(@BindReturn int rowCount, @BindTraveler QueryEntry queryEntry) {
            queryEntry.setCurrRow(rowCount);
            queryEntry.endWithLocationStackTrace(JdbcPluginProperties.stackTraceThresholdMillis(), TimeUnit.MILLISECONDS);
        }

        @OnThrow
        public static void onThrow(@BindThrowable Throwable t, @BindTraveler QueryEntry queryEntry) {
            queryEntry.endWithError(t);
        }
    }

    @Pointcut(className="java.sql.PreparedStatement", methodName="executeQuery", methodParameterTypes={}, methodReturnType="java.sql.ResultSet", nestingGroup="jdbc")
    public static class PreparedStatementExecuteQueryAdvice {
        @IsEnabled
        public static boolean isEnabled(@BindReceiver HasStatementMirrorMixin preparedStatement) {
            return preparedStatement.glowroot$hasStatementMirror();
        }

        @OnBefore
        public static QueryEntry onBefore(ThreadContext context, @BindReceiver HasStatementMirrorMixin preparedStatement) {
            return PreparedStatementExecuteAdvice.onBefore(context, preparedStatement);
        }

        @OnReturn
        public static void onReturn(@BindReturn @Nullable HasStatementMirrorMixin resultSet, @BindReceiver HasStatementMirrorMixin preparedStatement, @BindTraveler QueryEntry queryEntry) {
            if (resultSet != null) {
                StatementMirror mirror = preparedStatement.glowroot$getStatementMirror();
                resultSet.glowroot$setStatementMirror(mirror);
            }
            queryEntry.endWithLocationStackTrace(JdbcPluginProperties.stackTraceThresholdMillis(), TimeUnit.MILLISECONDS);
        }

        @OnThrow
        public static void onThrow(@BindThrowable Throwable t, @BindTraveler QueryEntry queryEntry) {
            queryEntry.endWithError(t);
        }
    }

    @Pointcut(className="java.sql.PreparedStatement", methodName="execute", methodParameterTypes={}, nestingGroup="jdbc", timerName="jdbc query")
    public static class PreparedStatementExecuteAdvice {
        private static final TimerName timerName = Agent.getTimerName(PreparedStatementExecuteAdvice.class);

        @IsEnabled
        public static boolean isEnabled(@BindReceiver HasStatementMirrorMixin preparedStatement) {
            return preparedStatement.glowroot$hasStatementMirror();
        }

        @OnBefore
        public static QueryEntry onBefore(ThreadContext context, @BindReceiver HasStatementMirrorMixin preparedStatement) {
            PreparedStatementMirror mirror = (PreparedStatementMirror)preparedStatement.glowroot$getStatementMirror();
            String queryText = mirror.getSql();
            QueryMessageSupplier queryMessageSupplier = captureBindParameters ? new PreparedStatementMessageSupplier(mirror.getParameters(), queryText) : QueryMessageSupplier.create("jdbc query: ");
            QueryEntry queryEntry = context.startQueryEntry(StatementAspect.QUERY_TYPE, queryText, queryMessageSupplier, timerName);
            mirror.setLastQueryEntry(queryEntry);
            return queryEntry;
        }

        @OnReturn
        public static void onReturn(@BindTraveler QueryEntry queryEntry) {
            queryEntry.endWithLocationStackTrace(JdbcPluginProperties.stackTraceThresholdMillis(), TimeUnit.MILLISECONDS);
        }

        @OnThrow
        public static void onThrow(@BindThrowable Throwable t, @BindTraveler QueryEntry queryEntry) {
            queryEntry.endWithError(t);
        }
    }

    @Pointcut(className="java.sql.Statement", methodName="executeUpdate", methodParameterTypes={"java.lang.String", ".."}, methodReturnType="int", nestingGroup="jdbc")
    public static class StatementExecuteUpdateAdvice {
        @IsEnabled
        public static boolean isEnabled(@BindReceiver HasStatementMirrorMixin statement) {
            return statement.glowroot$hasStatementMirror();
        }

        @OnBefore
        @Nullable
        public static QueryEntry onBefore(ThreadContext context, @BindReceiver HasStatementMirrorMixin statement, @BindParameter @Nullable String sql) {
            return StatementExecuteAdvice.onBefore(context, statement, sql);
        }

        @OnReturn
        public static void onReturn(@BindReturn int rowCount, @BindTraveler @Nullable QueryEntry queryEntry) {
            if (queryEntry != null) {
                queryEntry.setCurrRow(rowCount);
                queryEntry.endWithLocationStackTrace(JdbcPluginProperties.stackTraceThresholdMillis(), TimeUnit.MILLISECONDS);
            }
        }

        @OnThrow
        public static void onThrow(@BindThrowable Throwable t, @BindTraveler @Nullable QueryEntry queryEntry) {
            if (queryEntry != null) {
                queryEntry.endWithError(t);
            }
        }
    }

    @Pointcut(className="java.sql.Statement", methodName="executeQuery", methodParameterTypes={"java.lang.String"}, methodReturnType="java.sql.ResultSet", nestingGroup="jdbc")
    public static class StatementExecuteQueryAdvice {
        @IsEnabled
        public static boolean isEnabled(@BindReceiver HasStatementMirrorMixin statement) {
            return statement.glowroot$hasStatementMirror();
        }

        @OnBefore
        @Nullable
        public static QueryEntry onBefore(ThreadContext context, @BindReceiver HasStatementMirrorMixin statement, @BindParameter @Nullable String sql) {
            return StatementExecuteAdvice.onBefore(context, statement, sql);
        }

        @OnReturn
        public static void onReturn(@BindReturn @Nullable HasStatementMirrorMixin resultSet, @BindReceiver HasStatementMirrorMixin statement, @BindTraveler @Nullable QueryEntry queryEntry) {
            if (resultSet != null) {
                StatementMirror mirror = statement.glowroot$getStatementMirror();
                resultSet.glowroot$setStatementMirror(mirror);
            }
            if (queryEntry != null) {
                queryEntry.endWithLocationStackTrace(JdbcPluginProperties.stackTraceThresholdMillis(), TimeUnit.MILLISECONDS);
            }
        }

        @OnThrow
        public static void onThrow(@BindThrowable Throwable t, @BindTraveler @Nullable QueryEntry queryEntry) {
            if (queryEntry != null) {
                queryEntry.endWithError(t);
            }
        }
    }

    @Pointcut(className="java.sql.Statement", methodName="execute", methodParameterTypes={"java.lang.String", ".."}, nestingGroup="jdbc", timerName="jdbc query")
    public static class StatementExecuteAdvice {
        private static final TimerName timerName = Agent.getTimerName(StatementExecuteAdvice.class);

        @IsEnabled
        public static boolean isEnabled(@BindReceiver HasStatementMirrorMixin statement) {
            return statement.glowroot$hasStatementMirror();
        }

        @OnBefore
        @Nullable
        public static QueryEntry onBefore(ThreadContext context, @BindReceiver HasStatementMirrorMixin statement, @BindParameter @Nullable String sql) {
            if (sql == null) {
                return null;
            }
            StatementMirror mirror = statement.glowroot$getStatementMirror();
            if (mirror == null) {
                return null;
            }
            QueryEntry query = context.startQueryEntry(StatementAspect.QUERY_TYPE, sql, QueryMessageSupplier.create("jdbc query: "), timerName);
            mirror.setLastQueryEntry(query);
            return query;
        }

        @OnReturn
        public static void onReturn(@BindTraveler @Nullable QueryEntry queryEntry) {
            if (queryEntry != null) {
                queryEntry.endWithLocationStackTrace(JdbcPluginProperties.stackTraceThresholdMillis(), TimeUnit.MILLISECONDS);
            }
        }

        @OnThrow
        public static void onThrow(@BindThrowable Throwable t, @BindTraveler @Nullable QueryEntry queryEntry) {
            if (queryEntry != null) {
                queryEntry.endWithError(t);
            }
        }
    }

    @Pointcut(className="java.sql.Statement", methodName="clearBatch", methodParameterTypes={})
    public static class ClearBatchAdvice {
        @OnReturn
        public static void onReturn(@BindReceiver HasStatementMirrorMixin statement) {
            StatementMirror mirror = statement.glowroot$getStatementMirror();
            if (mirror != null) {
                mirror.clearBatch();
            }
        }
    }

    @Pointcut(className="java.sql.PreparedStatement", methodName="addBatch", methodParameterTypes={})
    public static class PreparedStatementAddBatchAdvice {
        @OnReturn
        public static void onReturn(@BindReceiver HasStatementMirrorMixin preparedStatement) {
            PreparedStatementMirror mirror = (PreparedStatementMirror)preparedStatement.glowroot$getStatementMirror();
            if (mirror != null) {
                mirror.addBatch();
            }
        }
    }

    @Pointcut(className="java.sql.Statement", methodName="addBatch", methodParameterTypes={"java.lang.String"})
    public static class StatementAddBatchAdvice {
        @OnReturn
        public static void onReturn(@BindReceiver HasStatementMirrorMixin statement, @BindParameter @Nullable String sql) {
            if (sql == null) {
                return;
            }
            StatementMirror mirror = statement.glowroot$getStatementMirror();
            if (mirror != null) {
                mirror.addBatch(sql);
            }
        }
    }

    @Pointcut(className="java.sql.PreparedStatement", methodName="clearParameters", methodParameterTypes={})
    public static class ClearParametersAdvice {
        @IsEnabled
        public static boolean isEnabled() {
            return captureBindParameters;
        }

        @OnReturn
        public static void onReturn(@BindReceiver HasStatementMirrorMixin preparedStatement) {
            PreparedStatementMirror mirror = (PreparedStatementMirror)preparedStatement.glowroot$getStatementMirror();
            if (mirror != null) {
                mirror.clearParameters();
            }
        }
    }

    @Pointcut(className="java.sql.PreparedStatement", methodName="setNull", methodParameterTypes={"int", "int", ".."})
    public static class SetNullAdvice {
        @IsEnabled
        public static boolean isEnabled() {
            return captureBindParameters;
        }

        @OnReturn
        public static void onReturn(@BindReceiver HasStatementMirrorMixin preparedStatement, @BindParameter int parameterIndex) {
            PreparedStatementMirror mirror = (PreparedStatementMirror)preparedStatement.glowroot$getStatementMirror();
            if (mirror != null) {
                mirror.setParameterValue(parameterIndex, null);
            }
        }
    }

    @Pointcut(className="java.sql.PreparedStatement", methodName="setObject", methodParameterTypes={"int", "java.lang.Object", ".."})
    public static class SetObjectAdvice {
        @IsEnabled
        public static boolean isEnabled() {
            return captureBindParameters;
        }

        @OnReturn
        public static void onReturn(@BindReceiver HasStatementMirrorMixin preparedStatement, @BindParameter int parameterIndex, @BindParameter @Nullable Object x) {
            PreparedStatementMirror mirror = (PreparedStatementMirror)preparedStatement.glowroot$getStatementMirror();
            if (mirror != null) {
                if (x == null) {
                    mirror.setParameterValue(parameterIndex, null);
                } else if (x instanceof byte[]) {
                    SetBytesAdvice.setBytes(mirror, parameterIndex, (byte[])x);
                } else {
                    mirror.setParameterValue(parameterIndex, x);
                }
            }
        }
    }

    @Pointcut(className="java.sql.PreparedStatement", methodName="setBytes", methodParameterTypes={"int", "byte[]"})
    public static class SetBytesAdvice {
        @IsEnabled
        public static boolean isEnabled() {
            return captureBindParameters;
        }

        @OnReturn
        public static void onReturn(@BindReceiver HasStatementMirrorMixin preparedStatement, @BindParameter int parameterIndex, @BindParameter byte[] x) {
            PreparedStatementMirror mirror = (PreparedStatementMirror)preparedStatement.glowroot$getStatementMirror();
            if (mirror != null) {
                if (x == null) {
                    mirror.setParameterValue(parameterIndex, null);
                } else {
                    SetBytesAdvice.setBytes(mirror, parameterIndex, x);
                }
            }
        }

        private static void setBytes(PreparedStatementMirror mirror, int parameterIndex, byte[] x) {
            boolean displayAsHex = JdbcPluginProperties.displayBinaryParameterAsHex(mirror.getSql(), parameterIndex);
            mirror.setParameterValue(parameterIndex, new PreparedStatementMirror.ByteArrayParameterValue(x, displayAsHex));
        }
    }

    @Pointcut(className="java.sql.PreparedStatement", methodName="setAsciiStream|setBinaryStream|setBlob|setCharacterStream|setClob|setNCharacterStream|setNClob|setSQLXML|setUnicodeStream", methodParameterTypes={"int", "*", ".."})
    public static class SetStreamAdvice {
        @IsEnabled
        public static boolean isEnabled() {
            return captureBindParameters;
        }

        @OnReturn
        public static void onReturn(@BindReceiver HasStatementMirrorMixin preparedStatement, @BindParameter int parameterIndex, @BindParameter @Nullable Object x) {
            PreparedStatementMirror mirror = (PreparedStatementMirror)preparedStatement.glowroot$getStatementMirror();
            if (mirror != null) {
                if (x == null) {
                    mirror.setParameterValue(parameterIndex, null);
                } else {
                    mirror.setParameterValue(parameterIndex, new PreparedStatementMirror.StreamingParameterValue(x.getClass()));
                }
            }
        }
    }

    @Pointcut(className="java.sql.PreparedStatement", methodName="setArray|setBigDecimal|setBoolean|setByte|setDate|setDouble|setFloat|setInt|setLong|setNString|setRef|setRowId|setShort|setString|setTime|setTimestamp|setURL", methodParameterTypes={"int", "*", ".."})
    public static class SetXAdvice {
        @IsEnabled
        public static boolean isEnabled() {
            return captureBindParameters;
        }

        @OnReturn
        public static void onReturn(@BindReceiver HasStatementMirrorMixin preparedStatement, @BindParameter int parameterIndex, @BindParameter @Nullable Object x) {
            PreparedStatementMirror mirror = (PreparedStatementMirror)preparedStatement.glowroot$getStatementMirror();
            if (mirror != null) {
                mirror.setParameterValue(parameterIndex, x);
            }
        }
    }

    public static interface HasStatementMirrorMixin {
        @Nullable
        public StatementMirror glowroot$getStatementMirror();

        public void glowroot$setStatementMirror(@Nullable StatementMirror var1);

        public boolean glowroot$hasStatementMirror();
    }

    @Mixin(value={"java.sql.Statement", "java.sql.ResultSet"})
    public static class HasStatementMirrorImpl
    implements HasStatementMirrorMixin {
        @Nullable
        private transient StatementMirror glowroot$statementMirror;

        @Override
        @Nullable
        public StatementMirror glowroot$getStatementMirror() {
            return this.glowroot$statementMirror;
        }

        @Override
        public void glowroot$setStatementMirror(@Nullable StatementMirror statementMirror) {
            this.glowroot$statementMirror = statementMirror;
        }

        @Override
        public boolean glowroot$hasStatementMirror() {
            return this.glowroot$statementMirror != null;
        }
    }

    @Shim(value={"java.sql.PreparedStatement"})
    public static interface PreparedStatement {
    }
}

