/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.jakartaservlet;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import org.glowroot.agent.plugin.api.Logger;
import org.glowroot.agent.plugin.api.ThreadContext;
import org.glowroot.agent.plugin.api.weaving.BindClassMeta;
import org.glowroot.agent.plugin.api.weaving.BindReceiver;
import org.glowroot.agent.plugin.api.weaving.OnReturn;
import org.glowroot.agent.plugin.api.weaving.Pointcut;
import org.glowroot.agent.plugin.jakartaservlet.DetailCapture;
import org.glowroot.agent.plugin.jakartaservlet.bclglowrootbcl.RequestClassMeta;
import org.glowroot.agent.plugin.jakartaservlet.bclglowrootbcl.ServletMessageSupplier;

public class RequestParameterAspect {
    private static final Logger logger = Logger.getLogger(RequestParameterAspect.class);

    @Pointcut(className="jakarta.servlet.ServletRequest", methodName="getParameter*", methodParameterTypes={".."}, nestingGroup="servlet-inner-call")
    public static class GetParameterAdvice {
        @OnReturn
        public static void onReturn(ThreadContext context, @BindReceiver Object req, @BindClassMeta RequestClassMeta requestClassMeta) {
            if (!(req instanceof HttpServletRequest)) {
                return;
            }
            HttpServletRequest request = (HttpServletRequest)req;
            ServletMessageSupplier messageSupplier = (ServletMessageSupplier)context.getServletRequestInfo();
            if (messageSupplier == null || messageSupplier.isRequestParametersCaptured()) {
                return;
            }
            GetParameterAdvice.captureRequestParameters(requestClassMeta, request, messageSupplier);
        }

        private static void captureRequestParameters(RequestClassMeta requestClassMeta, HttpServletRequest request, ServletMessageSupplier messageSupplier) {
            Map parameterMap;
            if (requestClassMeta.isBadParameterMapImplementation()) {
                messageSupplier.setCaptureRequestParameters(DetailCapture.captureRequestParameters(request));
                return;
            }
            try {
                parameterMap = request.getParameterMap();
            }
            catch (Exception e) {
                logger.debug(e.getMessage(), e);
                requestClassMeta.setBadParameterMapImplementation();
                messageSupplier.setCaptureRequestParameters(DetailCapture.captureRequestParameters(request));
                return;
            }
            if (parameterMap == null) {
                return;
            }
            if (parameterMap.isEmpty()) {
                return;
            }
            messageSupplier.setCaptureRequestParameters(DetailCapture.captureRequestParameters(parameterMap));
        }
    }
}

