/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.elasticsearch;

import java.util.concurrent.TimeUnit;
import org.glowroot.agent.plugin.api.Agent;
import org.glowroot.agent.plugin.api.AsyncQueryEntry;
import org.glowroot.agent.plugin.api.QueryEntry;
import org.glowroot.agent.plugin.api.QueryMessageSupplier;
import org.glowroot.agent.plugin.api.ThreadContext;
import org.glowroot.agent.plugin.api.TimerName;
import org.glowroot.agent.plugin.api.checker.Nullable;
import org.glowroot.agent.plugin.api.config.ConfigListener;
import org.glowroot.agent.plugin.api.config.ConfigService;
import org.glowroot.agent.plugin.api.weaving.BindReceiver;
import org.glowroot.agent.plugin.api.weaving.BindReturn;
import org.glowroot.agent.plugin.api.weaving.BindThrowable;
import org.glowroot.agent.plugin.api.weaving.BindTraveler;
import org.glowroot.agent.plugin.api.weaving.OnBefore;
import org.glowroot.agent.plugin.api.weaving.OnReturn;
import org.glowroot.agent.plugin.api.weaving.OnThrow;
import org.glowroot.agent.plugin.api.weaving.Pointcut;
import org.glowroot.agent.plugin.api.weaving.Shim;
import org.glowroot.agent.plugin.elasticsearch.ActionFutureAspect;
import org.glowroot.agent.plugin.elasticsearch.QueryMessageSupplierWithId;

public class ActionRequestBuilderAspect {
    private static final String QUERY_TYPE = "Elasticsearch";
    private static final ConfigService configService = Agent.getConfigService("elasticsearch");
    private static int stackTraceThresholdMillis;

    private static String getQueryText(ActionRequestBuilder actionRequestBuilder) {
        ActionRequest actionRequest = actionRequestBuilder.glowroot$request();
        if (actionRequest instanceof IndexRequest) {
            IndexRequest request = (IndexRequest)actionRequest;
            return "PUT " + request.index() + '/' + request.type();
        }
        if (actionRequest instanceof GetRequest) {
            GetRequest request = (GetRequest)actionRequest;
            return "GET " + request.index() + '/' + request.type();
        }
        if (actionRequest instanceof UpdateRequest) {
            UpdateRequest request = (UpdateRequest)actionRequest;
            return "PUT " + request.index() + '/' + request.type();
        }
        if (actionRequest instanceof DeleteRequest) {
            DeleteRequest request = (DeleteRequest)actionRequest;
            return "DELETE " + request.index() + '/' + request.type();
        }
        if (actionRequest instanceof SearchRequest) {
            SearchRequest request = (SearchRequest)actionRequest;
            return ActionRequestBuilderAspect.getQueryText(request, (SearchRequestBuilder)((Object)actionRequestBuilder));
        }
        if (actionRequest == null) {
            return "(action request was null)";
        }
        return actionRequest.getClass().getName();
    }

    private static String getQueryText(SearchRequest request, SearchRequestBuilder actionRequestBuilder) {
        StringBuilder sb = new StringBuilder("SEARCH ");
        String[] indices = request.indices();
        String[] types = request.types();
        if (indices != null && indices.length > 0) {
            if (types != null && types.length > 0) {
                ActionRequestBuilderAspect.appendTo(sb, indices);
                sb.append('/');
                ActionRequestBuilderAspect.appendTo(sb, types);
            } else {
                ActionRequestBuilderAspect.appendTo(sb, indices);
            }
        } else if (types != null && types.length > 0) {
            sb.append("_any/");
            ActionRequestBuilderAspect.appendTo(sb, types);
        } else {
            sb.append('/');
        }
        Object sourceBuilder = actionRequestBuilder.glowroot$sourceBuilder();
        if (sourceBuilder != null) {
            sb.append(' ');
            sb.append(sourceBuilder);
        }
        return sb.toString();
    }

    private static QueryMessageSupplier getQueryMessageSupplier(ActionRequestBuilder actionRequestBuilder) {
        ActionRequest actionRequest = actionRequestBuilder.glowroot$request();
        if (actionRequest instanceof IndexRequest) {
            return QueryMessageSupplier.create("elasticsearch query: ");
        }
        if (actionRequest instanceof GetRequest) {
            GetRequest request = (GetRequest)actionRequest;
            return new QueryMessageSupplierWithId(request.id());
        }
        if (actionRequest instanceof UpdateRequest) {
            UpdateRequest request = (UpdateRequest)actionRequest;
            return new QueryMessageSupplierWithId(request.id());
        }
        if (actionRequest instanceof DeleteRequest) {
            DeleteRequest request = (DeleteRequest)actionRequest;
            return new QueryMessageSupplierWithId(request.id());
        }
        if (actionRequest instanceof SearchRequest) {
            return QueryMessageSupplier.create("elasticsearch query: ");
        }
        return QueryMessageSupplier.create("elasticsearch query: ");
    }

    private static void appendTo(StringBuilder sb, @Nullable String[] values) {
        boolean first = true;
        for (String value : values) {
            if (!first) {
                sb.append(',');
            }
            sb.append(value);
            first = false;
        }
    }

    static {
        configService.registerConfigListener(new ConfigListener(){

            @Override
            public void onChange() {
                Double value = configService.getDoubleProperty("stackTraceThresholdMillis").value();
                stackTraceThresholdMillis = value == null ? Integer.MAX_VALUE : value.intValue();
            }
        });
    }

    @Pointcut(className="org.elasticsearch.action.ActionRequestBuilder", methodName="execute", methodParameterTypes={}, nestingGroup="elasticsearch", timerName="elasticsearch query")
    public static class ExecuteAsyncAdvice {
        private static final TimerName timerName = Agent.getTimerName(ExecuteAsyncAdvice.class);

        @OnBefore
        @Nullable
        public static AsyncQueryEntry onBefore(ThreadContext context, @BindReceiver ActionRequestBuilder actionRequestBuilder) {
            return context.startAsyncQueryEntry(ActionRequestBuilderAspect.QUERY_TYPE, ActionRequestBuilderAspect.getQueryText(actionRequestBuilder), ActionRequestBuilderAspect.getQueryMessageSupplier(actionRequestBuilder), timerName);
        }

        @OnReturn
        public static void onReturn(@BindReturn @Nullable ActionFutureAspect.ActionFutureMixin future, @BindTraveler @Nullable AsyncQueryEntry asyncQueryEntry) {
            if (asyncQueryEntry == null) {
                return;
            }
            asyncQueryEntry.stopSyncTimer();
            if (future == null) {
                asyncQueryEntry.end();
                return;
            }
            future.glowroot$setAsyncQueryEntry(asyncQueryEntry);
            if (future.glowroot$isCompleted()) {
                Throwable exception = future.glowroot$getException();
                if (exception == null) {
                    asyncQueryEntry.end();
                } else {
                    asyncQueryEntry.endWithError(exception);
                }
                return;
            }
        }

        @OnThrow
        public static void onThrow(@BindThrowable Throwable t, @BindTraveler @Nullable AsyncQueryEntry asyncQueryEntry) {
            if (asyncQueryEntry != null) {
                asyncQueryEntry.stopSyncTimer();
                asyncQueryEntry.endWithError(t);
            }
        }
    }

    @Pointcut(className="org.elasticsearch.action.ActionRequestBuilder", methodName="get", methodParameterTypes={}, nestingGroup="elasticsearch", timerName="elasticsearch query", suppressionKey="wait-on-future")
    public static class ExecuteAdvice {
        private static final TimerName timerName = Agent.getTimerName(ExecuteAdvice.class);

        @OnBefore
        @Nullable
        public static QueryEntry onBefore(ThreadContext context, @BindReceiver ActionRequestBuilder actionRequestBuilder) {
            return context.startQueryEntry(ActionRequestBuilderAspect.QUERY_TYPE, ActionRequestBuilderAspect.getQueryText(actionRequestBuilder), ActionRequestBuilderAspect.getQueryMessageSupplier(actionRequestBuilder), timerName);
        }

        @OnReturn
        public static void onReturn(@BindTraveler @Nullable QueryEntry queryEntry) {
            if (queryEntry != null) {
                queryEntry.endWithLocationStackTrace(stackTraceThresholdMillis, TimeUnit.MILLISECONDS);
            }
        }

        @OnThrow
        public static void onThrow(@BindThrowable Throwable t, @BindTraveler @Nullable QueryEntry queryEntry) {
            if (queryEntry != null) {
                queryEntry.endWithError(t);
            }
        }
    }

    @Shim(value={"org.elasticsearch.common.bytes.BytesReference"})
    public static interface BytesReference {
        @Nullable
        public String toUtf8();
    }

    @Shim(value={"org.elasticsearch.action.search.SearchRequest"})
    public static interface SearchRequest
    extends ActionRequest {
        @Nullable
        public String[] indices();

        @Nullable
        public String[] types();
    }

    @Shim(value={"org.elasticsearch.action.delete.DeleteRequest"})
    public static interface DeleteRequest
    extends ActionRequest {
        @Nullable
        public String index();

        @Nullable
        public String type();

        @Nullable
        public String id();
    }

    @Shim(value={"org.elasticsearch.action.update.UpdateRequest"})
    public static interface UpdateRequest
    extends ActionRequest {
        @Nullable
        public String index();

        @Nullable
        public String type();

        @Nullable
        public String id();
    }

    @Shim(value={"org.elasticsearch.action.get.GetRequest"})
    public static interface GetRequest
    extends ActionRequest {
        @Nullable
        public String index();

        @Nullable
        public String type();

        @Nullable
        public String id();
    }

    @Shim(value={"org.elasticsearch.action.index.IndexRequest"})
    public static interface IndexRequest
    extends ActionRequest {
        @Nullable
        public String index();

        @Nullable
        public String type();
    }

    @Shim(value={"org.elasticsearch.action.ActionRequest"})
    public static interface ActionRequest {
    }

    @Shim(value={"org.elasticsearch.action.search.SearchRequestBuilder"})
    public static interface SearchRequestBuilder {
        @Shim(value={"org.elasticsearch.search.builder.SearchSourceBuilder sourceBuilder()"})
        @Nullable
        public Object glowroot$sourceBuilder();
    }

    @Shim(value={"org.elasticsearch.action.ActionRequestBuilder"})
    public static interface ActionRequestBuilder {
        @Shim(value={"org.elasticsearch.action.ActionRequest request()"})
        @Nullable
        public ActionRequest glowroot$request();
    }
}

