/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.cassandra;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.glowroot.agent.plugin.api.Agent;
import org.glowroot.agent.plugin.api.AsyncQueryEntry;
import org.glowroot.agent.plugin.api.QueryEntry;
import org.glowroot.agent.plugin.api.QueryMessageSupplier;
import org.glowroot.agent.plugin.api.ThreadContext;
import org.glowroot.agent.plugin.api.Timer;
import org.glowroot.agent.plugin.api.TimerName;
import org.glowroot.agent.plugin.api.checker.Nullable;
import org.glowroot.agent.plugin.api.config.ConfigListener;
import org.glowroot.agent.plugin.api.config.ConfigService;
import org.glowroot.agent.plugin.api.weaving.BindParameter;
import org.glowroot.agent.plugin.api.weaving.BindReturn;
import org.glowroot.agent.plugin.api.weaving.BindThrowable;
import org.glowroot.agent.plugin.api.weaving.BindTraveler;
import org.glowroot.agent.plugin.api.weaving.OnAfter;
import org.glowroot.agent.plugin.api.weaving.OnBefore;
import org.glowroot.agent.plugin.api.weaving.OnReturn;
import org.glowroot.agent.plugin.api.weaving.OnThrow;
import org.glowroot.agent.plugin.api.weaving.Pointcut;
import org.glowroot.agent.plugin.api.weaving.Shim;
import org.glowroot.agent.plugin.cassandra.ResultSetAspect;
import org.glowroot.agent.plugin.cassandra.ResultSetFutureAspect;

public class SessionAspect {
    private static final String QUERY_TYPE = "CQL";
    private static final ConfigService configService = Agent.getConfigService("cassandra");
    private static int stackTraceThresholdMillis;

    @Nullable
    private static QueryEntryInfo getQueryEntryInfo(@Nullable Object arg) {
        String queryText;
        if (arg == null) {
            return null;
        }
        if (arg instanceof String) {
            queryText = (String)arg;
        } else if (arg instanceof RegularStatement) {
            queryText = SessionAspect.nullToEmpty(((RegularStatement)arg).getQueryString());
        } else if (arg instanceof BoundStatement) {
            PreparedStatement preparedStatement = ((BoundStatement)arg).glowroot$preparedStatement();
            queryText = preparedStatement == null ? "" : SessionAspect.nullToEmpty(preparedStatement.getQueryString());
        } else if (arg instanceof BatchStatement) {
            Collection<Statement> statements = ((BatchStatement)arg).getStatements();
            if (statements == null) {
                statements = new ArrayList<Statement>();
            }
            queryText = SessionAspect.concatenate(statements);
        } else {
            return null;
        }
        return new QueryEntryInfo(queryText, QueryMessageSupplier.create("cassandra query: "));
    }

    private static String concatenate(Collection<Statement> statements) {
        if (statements.isEmpty()) {
            return "[empty batch]";
        }
        StringBuilder sb = new StringBuilder("[batch] ");
        String currQuery = null;
        int currCount = 0;
        boolean first = true;
        for (Statement statement : statements) {
            String query = SessionAspect.getQuery(statement);
            if (currQuery == null) {
                currQuery = query;
                currCount = 1;
                continue;
            }
            if (!query.equals(currQuery)) {
                if (!first) {
                    sb.append(", ");
                }
                first = false;
                if (currCount == 1) {
                    sb.append(currQuery);
                } else {
                    sb.append(currCount + " x " + currQuery);
                }
                currQuery = query;
                currCount = 1;
                continue;
            }
            ++currCount;
        }
        if (currQuery != null) {
            if (!first) {
                sb.append(", ");
            }
            if (currCount == 1) {
                sb.append(currQuery);
            } else {
                sb.append(currCount + " x " + currQuery);
            }
        }
        return sb.toString();
    }

    private static String getQuery(Statement statement) {
        if (statement instanceof RegularStatement) {
            String qs = ((RegularStatement)statement).getQueryString();
            return SessionAspect.nullToEmpty(qs);
        }
        if (statement instanceof BoundStatement) {
            PreparedStatement preparedStatement = ((BoundStatement)statement).glowroot$preparedStatement();
            String qs = preparedStatement == null ? "" : preparedStatement.getQueryString();
            return SessionAspect.nullToEmpty(qs);
        }
        if (statement instanceof BatchStatement) {
            return "[nested batch statement]";
        }
        return "[unexpected statement type: " + statement.getClass().getName() + "]";
    }

    private static String nullToEmpty(@Nullable String string) {
        return string == null ? "" : string;
    }

    static {
        configService.registerConfigListener(new ConfigListener(){

            @Override
            public void onChange() {
                Double value = configService.getDoubleProperty("stackTraceThresholdMillis").value();
                stackTraceThresholdMillis = value == null ? Integer.MAX_VALUE : value.intValue();
            }
        });
    }

    private static class QueryEntryInfo {
        private final String queryText;
        private final QueryMessageSupplier queryMessageSupplier;

        private QueryEntryInfo(String queryText, QueryMessageSupplier messageSupplier) {
            this.queryText = queryText;
            this.queryMessageSupplier = messageSupplier;
        }
    }

    @Pointcut(className="com.datastax.driver.core.Session", methodName="executeAsync", methodParameterTypes={"com.datastax.driver.core.Statement"}, nestingGroup="cassandra", timerName="cassandra query")
    public static class ExecuteAsyncAdvice {
        private static final TimerName timerName = Agent.getTimerName(ExecuteAsyncAdvice.class);

        @OnBefore
        @Nullable
        public static AsyncQueryEntry onBefore(ThreadContext context, @BindParameter @Nullable Object arg) {
            QueryEntryInfo queryEntryInfo = SessionAspect.getQueryEntryInfo(arg);
            if (queryEntryInfo == null) {
                return null;
            }
            return context.startAsyncQueryEntry(SessionAspect.QUERY_TYPE, queryEntryInfo.queryText, queryEntryInfo.queryMessageSupplier, timerName);
        }

        @OnReturn
        public static void onReturn(@BindReturn @Nullable ResultSetFutureAspect.ResultSetFutureMixin future, @BindTraveler @Nullable AsyncQueryEntry asyncQueryEntry) {
            if (asyncQueryEntry == null) {
                return;
            }
            asyncQueryEntry.stopSyncTimer();
            if (future == null) {
                asyncQueryEntry.end();
                return;
            }
            future.glowroot$setAsyncQueryEntry(asyncQueryEntry);
            if (future.glowroot$isCompleted()) {
                Throwable exception = future.glowroot$getException();
                if (exception == null) {
                    asyncQueryEntry.end();
                } else {
                    asyncQueryEntry.endWithError(exception);
                }
                return;
            }
        }

        @OnThrow
        public static void onThrow(@BindThrowable Throwable t, @BindTraveler @Nullable AsyncQueryEntry asyncQueryEntry) {
            if (asyncQueryEntry != null) {
                asyncQueryEntry.stopSyncTimer();
                asyncQueryEntry.endWithError(t);
            }
        }
    }

    @Pointcut(className="com.datastax.driver.core.Session", methodName="prepare", methodParameterTypes={"*"}, timerName="cql prepare", suppressionKey="wait-on-future")
    public static class PrepareAdvice {
        private static final TimerName timerName = Agent.getTimerName(PrepareAdvice.class);

        @OnBefore
        public static Timer onBefore(ThreadContext context) {
            return context.startTimer(timerName);
        }

        @OnAfter
        public static void onAfter(@BindTraveler Timer timer) {
            timer.stop();
        }
    }

    @Pointcut(className="com.datastax.driver.core.Session", methodName="execute", methodParameterTypes={"com.datastax.driver.core.Statement"}, nestingGroup="cassandra", timerName="cassandra query", suppressionKey="wait-on-future")
    public static class ExecuteAdvice {
        private static final TimerName timerName = Agent.getTimerName(ExecuteAdvice.class);

        @OnBefore
        @Nullable
        public static QueryEntry onBefore(ThreadContext context, @BindParameter @Nullable Object arg) {
            QueryEntryInfo queryEntryInfo = SessionAspect.getQueryEntryInfo(arg);
            if (queryEntryInfo == null) {
                return null;
            }
            return context.startQueryEntry(SessionAspect.QUERY_TYPE, queryEntryInfo.queryText, queryEntryInfo.queryMessageSupplier, timerName);
        }

        @OnReturn
        public static void onReturn(@BindReturn @Nullable ResultSetAspect.ResultSetMixin resultSet, @BindTraveler @Nullable QueryEntry queryEntry) {
            if (queryEntry != null) {
                if (resultSet != null) {
                    resultSet.glowroot$setQueryEntry(queryEntry);
                }
                queryEntry.endWithLocationStackTrace(stackTraceThresholdMillis, TimeUnit.MILLISECONDS);
            }
        }

        @OnThrow
        public static void onThrow(@BindThrowable Throwable t, @BindTraveler @Nullable QueryEntry queryEntry) {
            if (queryEntry != null) {
                queryEntry.endWithError(t);
            }
        }
    }

    @Shim(value={"com.datastax.driver.core.PreparedStatement"})
    public static interface PreparedStatement {
        @Nullable
        public String getQueryString();
    }

    @Shim(value={"com.datastax.driver.core.BatchStatement"})
    public static interface BatchStatement
    extends Statement {
        @Nullable
        public Collection<Statement> getStatements();
    }

    @Shim(value={"com.datastax.driver.core.BoundStatement"})
    public static interface BoundStatement
    extends Statement {
        @Shim(value={"com.datastax.driver.core.PreparedStatement preparedStatement()"})
        @Nullable
        public PreparedStatement glowroot$preparedStatement();
    }

    @Shim(value={"com.datastax.driver.core.RegularStatement"})
    public static interface RegularStatement
    extends Statement {
        @Nullable
        public String getQueryString();
    }

    @Shim(value={"com.datastax.driver.core.Statement"})
    public static interface Statement {
    }
}

